package com.mx.dla.dda.contrato.broadview.bos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.broadview.daos.ContratoBroadviewDAO;
import com.mx.dla.dda.contrato.broadview.dtos.ContratoBroadviewDTO;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;

@Component
public class ContratoBroadviewBO {

	private static Logger logger = Logger.getLogger(ContratoBroadviewBO.class);

	@Autowired
	private TerminosDAO terminosDao;

	@Autowired
	private TituloDAO titulosDao;

	@Autowired
	private ContratoBroadviewDAO broadviewDao;

	public List<ContratoBroadviewDTO> cargaListaBroadViewTitulos(Long idCntBv) {
		return broadviewDao.consultaBroadviewTitulos(idCntBv);
	}

	public List<Titulo> cargaListaTitulosContrato(Long idContrato) {
		return titulosDao.buscarTitulosContrato(idContrato);
	}

	public List<ContratoBroadviewDTO> procesaBroadviewAsignados(
			List<ContratoBroadviewDTO> broadviewList, List<Titulo> ddaList,
			Integer operacionAsignados) {

		Iterator<ContratoBroadviewDTO> i = broadviewList.iterator();
		while (i.hasNext()) {
			ContratoBroadviewDTO s = i.next();

			Boolean asignado = false;
			for (Titulo tItem : ddaList) {

				if (tItem.getIdBv() != null)
					if (s.getIdBroadview().longValue() == new Long(
							tItem.getIdBv()).longValue())
						asignado = true;
			}

			if (asignado) {
				s.setDdaAsignado(1);

				if (operacionAsignados == 0)
					i.remove();

			} else
				s.setDdaAsignado(0);
		}

		return broadviewList;
	}

	public List<Titulo> procesaDDAAsignados(List<Titulo> ddaList,
			Integer operacionAsignados) {

		Iterator<Titulo> i = ddaList.iterator();
		while (i.hasNext()) {
			Titulo s = i.next();

			if (operacionAsignados == 0 && s.getIdBv() != null)
				i.remove();

		}

		return ddaList;
	}

	public void asignaTitulosDDABroadviewPorDescripcion(
			List<ContratoBroadviewDTO> broadviewList, List<Titulo> ddaList) {

		for (ContratoBroadviewDTO broadviewItem : broadviewList)
			for (Titulo ddaItem : ddaList)
				if (broadviewItem.getDescripcionTitulo().equals(
						ddaItem.getDescTitulo()))
					if (!esBroadviewAsignado(ddaList,
							broadviewItem.getIdBroadview())) {
						broadviewItem.setDdaAsignado(1);
						ddaItem.setIdBv(broadviewItem.getIdBroadview()
								.toString());
					}

	}

	public List<ContratoBroadviewDTO> separaTitulosNoAsignadosBroadview(
			List<ContratoBroadviewDTO> broadviewList) {

		List<ContratoBroadviewDTO> newBroadviewList = new ArrayList<ContratoBroadviewDTO>();

		Iterator<ContratoBroadviewDTO> bv = broadviewList.iterator();
		while (bv.hasNext()) {
			ContratoBroadviewDTO s = bv.next();

			if (s != null && s.getDdaAsignado() != null
					&& s.getDdaAsignado() == 0)
				newBroadviewList.add(s);
		}

		return newBroadviewList;
	}

	public List<Titulo> separaTitulosNoAsignadosDla(List<Titulo> ddaList) {

		List<Titulo> newDdaList = new ArrayList<Titulo>();

		Iterator<Titulo> dla = ddaList.iterator();
		while (dla.hasNext()) {
			Titulo s = dla.next();

			if (s != null && s.getIdBv() == null)
				newDdaList.add(s);

		}

		return newDdaList;
	}

	public List<ContratoBroadviewDTO> separaTitulosAsignadosBroadview(
			List<ContratoBroadviewDTO> broadviewList) {

		List<ContratoBroadviewDTO> newBroadviewList = new ArrayList<ContratoBroadviewDTO>();

		Iterator<ContratoBroadviewDTO> bv = broadviewList.iterator();
		while (bv.hasNext()) {
			ContratoBroadviewDTO s = bv.next();

			if (s != null && s.getDdaAsignado() != null
					&& s.getDdaAsignado() == 1)
				newBroadviewList.add(s);
		}

		return newBroadviewList;
	}

	public List<Titulo> separaTitulosAsignadosDla(List<Titulo> ddaList) {

		List<Titulo> newDdaList = new ArrayList<Titulo>();

		Iterator<Titulo> dla = ddaList.iterator();
		while (dla.hasNext()) {
			Titulo s = dla.next();

			if (s != null && s.getIdBv() != null)
				newDdaList.add(s);

		}

		return newDdaList;
	}

	public boolean esBroadviewAsignado(List<Titulo> ddaList, Long idBroadview) {

		for (Titulo titulo : ddaList)
			if (titulo.getIdBv() != null
					&& new Long(titulo.getIdBv()).longValue() == idBroadview)
				return true;
		return false;
	}

	public List<Titulo> ordenaTitulosDdaAsignadosDlaPorBroadview(
			List<Titulo> ddaList, List<ContratoBroadviewDTO> broadviewOrdenList) {
		List<Titulo> newDdaList = new ArrayList<Titulo>();

		for (ContratoBroadviewDTO itemBusca : broadviewOrdenList)
			for (Titulo itemEncuentra : ddaList)
				if (itemEncuentra.getIdBv() != null
						&& new Long(itemEncuentra.getIdBv()).intValue() == itemBusca
								.getIdBroadview())
					newDdaList.add(itemEncuentra);

		return newDdaList;
	}

	/*
	 * public List<ContratoBroadviewDTO> quitaBroadviewAsignados(
	 * List<ContratoBroadviewDTO> broadviewList, List<Titulo> ddaList) {
	 * 
	 * Iterator<ContratoBroadviewDTO> i = broadviewList.iterator(); while
	 * (i.hasNext()) { ContratoBroadviewDTO s = i.next();
	 * 
	 * Boolean asignado = false;
	 * 
	 * for (Titulo tItem : ddaList) { if (s.getIdBroadview().longValue() == new
	 * Long(tItem.getIdBv()) .longValue()) asignado = true; }
	 * 
	 * if (asignado) i.remove(); }
	 * 
	 * return broadviewList; }
	 */
	public void guardarTitulosListaContrato(
			List<Titulo> titulosDDAEditadaTitulos, Long idContrato) {

		List<Titulo> listaDDAActualTitulos = titulosDao
				.buscarTitulosContrato(idContrato);

		for (Titulo catTitulo : listaDDAActualTitulos) {
			catTitulo.setIdBv(null);
			titulosDao.actualizarTitulosContrato(catTitulo);
		}

		for (Titulo catTitulo : titulosDDAEditadaTitulos)
			titulosDao.actualizarTitulosContrato(catTitulo);

	}

	public void actualizaBroadviewContrato(ContratoConsultaDTO contratoConsulta) {
		terminosDao.actualizaBroadviewContrato(contratoConsulta);
	}

	public Long consultaDealPorContrato(Long idContrato) {

		ContratoConsultaDTO contrato = new ContratoConsultaDTO();
		contrato.setIdContrato(idContrato);
		contrato = terminosDao.consultaContrato(contrato);

		if (contrato == null)
			return null;
		else if (contrato.getIdBv() == null)
			return null;
		else
			return new Long(contrato.getIdBv());

	}

}
