package com.mx.dla.dda.reporte.general.dtos;

import java.util.List;

import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.dtos.BaseDTO;

public class ExcelEstilosConfDTO extends BaseDTO {

	private static final long		  serialVersionUID = 5487098048509579095L;

	private String					  width;
	private String					  height;
	private String					  colspan;
	private String					  rowspan;
	private String					  align;
	private String					  valign;
	private String					  cellClass;
	private String					  value;
	private String					  text;
	private String					  datatype;
	private List<RangoExcelEstiloDTO> rangos;

	public ExcelEstilosConfDTO(String width, String height, String colspan, String rowspan, String align, String valign, String cellClass, String value, String text, String datatype,
	        List<RangoExcelEstiloDTO> rangos) {
		super();
		this.width = width;
		this.height = height;
		this.colspan = colspan;
		this.rowspan = rowspan;
		this.align = align;
		this.valign = valign;
		this.cellClass = cellClass;
		this.value = value;
		this.text = text;
		this.datatype = datatype;
		this.rangos = rangos;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getColspan() {
		return colspan;
	}

	public void setColspan(String colspan) {
		this.colspan = colspan;
	}

	public String getRowspan() {
		return rowspan;
	}

	public void setRowspan(String rowspan) {
		this.rowspan = rowspan;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public String getValign() {
		return valign;
	}

	public void setValign(String valign) {
		this.valign = valign;
	}

	public String getCellClass() {
		return cellClass;
	}

	public void setCellClass(String cellClass) {
		this.cellClass = cellClass;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getDatatype() {
		return datatype;
	}

	public void setDatatype(String datatype) {
		this.datatype = datatype;
	}

	public List<RangoExcelEstiloDTO> getRangos() {
		return rangos;
	}

	public void setRangos(List<RangoExcelEstiloDTO> rangos) {
		this.rangos = rangos;
	}

	public Boolean find(Long x, Long y) {
		
		for (RangoExcelEstiloDTO rango : rangos)
			if (x.longValue() >= rango.getxFrom().longValue() && x < rango.getxTo().longValue() && y >= rango.getyFrom().longValue() && y < rango.getyTo().longValue())
				return true;
		
		return false;
	}

	@Override
	public String toString() {
		return "ExcelEstilosConfDTO [width=" + width + ", height=" + height + ", colspan=" + colspan + ", rowspan=" + rowspan + ", align=" + align + ", valign=" + valign + ", cellClass=" + cellClass
		        + ", value=" + value + ", text=" + text + ", datatype=" + datatype + ", rangos=" + rangos + "]";
	}
	
	

}
