var idEstudio;

$(document).ready(
	function() {
		inicial();
		
		$('#fechaInicio').datepicker({
		changeYear: false,
	    changeMonth: false,
	    dateFormat: "yy/mm/dd",
	});
	
	$('#fechaFin').datepicker({
		changeYear: false,
	    changeMonth: false,
	    dateFormat: "yy/mm/dd",
	});
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
    // Obtener número de menú
    var menu = $("#pmn").val();
    var menuRegreso = $("#pmnReturn").val();
    var namespace = "/catalogos/excepciones/";
    var rowId = null;
    var oTable = null;
    
    oTable = $('#cataEstudio').DataTable({		    
        autoWidth: false,
        language: {	
            processing: "Procesando...",
            lengthMenu: "Mostrar _MENU_ registros",
            zeroRecords: "Sin eventos encontrados",
            emptyTable: "Sin eventos encontrados",
            info: "Mostrando _START_ al _END_ de _TOTAL_",
            infoEmpty: "0 registros",
            infoFiltered: "(filtrado de un total de _MAX_ registros)",
            search: "Buscar:",
            thousands: ",",
            loadingRecords: "Cargando...",
            paginate: {
                first: "Primero",
                last: "&Uacute;ltimo",
                next: "Siguiente",
                previous: "Anterior"
            }
        },
        pageLength: 10,
        info: false,
        filter: true,
        ordering: false,
        paging: true,
        pagingType: "full_numbers",
        order: [],
        ajax: {
            url: "listadoExcepciones",
            dataSrc: ""
        },
        columns: [
            { title: "Estudio", data: "estudio", searchable: true, width: "100px" },
            { title: "Titulo", data: "titulo", searchable: true, width: "100px" },
            { title: "Revenue Share", data: "revenueShare", searchable: true, width: "50px" },
            { title: "Fecha Inicio", data: "fechaInicio", searchable: true, width: "50px" },
            { title: "Fecha Fin", data: "fechaFin", searchable: true, width: "50px" },
            { title: "Accion", data: "titulo", searchable: true, width: "30px" }
        ],
        rowCallback: function(row, data, index) {
            var link = '<a onClick="actualizaExcepcion(' + data["idExcepcion"] + ')" data-bs-toggle="modal" data-bs-target="#modalAgregaActualiza">' + data["estudio"] + '</a>';
            var button = '<button class="btn btn-danger" type="button" onclick="eliminar(' + data["idExcepcion"] + ')">Eliminar</button>';
            $(row).attr("id", data["idExcepcion"]);
            $('td:eq(0)', row).html(link);
            $('td:eq(1)', row).html(data["titulo"]);
            $('td:eq(2)', row).html(data["revenueShare"]);
            $('td:eq(3)', row).html(data["fechaInicio"]);
            $('td:eq(4)', row).html(data["fechaFin"]);
            $('td:eq(5)', row).html(button);
        }
    });
}


function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanum\u00E9ricos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function eliminar(id){
	if(confirm('¿Esta seguro de borrar este registro?')){
		var jsonString = '{"idExcepcion" : "' + id + '"}';
		var stringJson = JSON.parse(jsonString);
		callActionAjax("/catalogos/excepciones/eliminaExcepcion", stringJson, procesaRespuestaActualiza);
	}
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/excepciones/dirigirAgregarExcepcion.action?pmn=213&pmnReturn=213";			
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 213;
	window.location.href = contextPath + "/catalogos/excepciones/index.action?pmn=" + menu;
}

function actualizaExcepcion(idExcepcio) {	
	idExcepcion = idExcepcio;
	llamaObtenExcepcion(idExcepcion);
}

function llamaObtenExcepcion(idExcepcion) {
	var jsonString = '{"idExcepcion" : "'+ idExcepcion +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaObtenExcepcion", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	var exc = jsonData.excepcion;
	var stdios = jsonData.estudiosTrans;
	//debugger
	$('#titulo').val(exc.titulo);
	$('#revenueShare').val(exc.revenueShare);
	$('#fechaInicio').val(exc.fechaInicio);
	$('#fechaFin').val(exc.fechaFin);
	
	$('#nombreEstudio').children().remove();
	
	var option;
	for(var i = 0; i < stdios.length; i++){
		std = stdios[i];
		if(exc.estudio == std.idEstudio) {
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'" selected> '+ std.nombre +' </option>');
		}else {
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'"> '+ std.nombre +' </option>');
		}						
	}
}

function llamaActualizaEstudio() {
	
	var nombre = $('#nombreEstudio').val();
	var titulo = $('#titulo').val();
	var revenue = $('#revenueShare').val();
	var inicio = $('#fechaInicio').val();
	var fin = $('#fechaFin').val();
	var jsonString = '{"idExcepcion" : "'+ idExcepcion + '", "nombreEstudio" : "' + nombre + '", "titulo" : "' + titulo 
		+ '", "revenueShare" : "' + revenue + '", "fechaInicio" : "' + inicio + '", "fechaFin" : "' + fin +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaActualizaExcepcion", stringJson, procesaRespuestaActualiza);

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.excepcionActualizada;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(seRepite) {
		showMessage("Actualizado con exito");
	}else {
		showError("No se pueden actualizar excepciones de meses cerrados.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}