package com.mx.dla.dda.reporte.pagoSuscriptores.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;



public enum TipoPago implements Catalogable {
	
	ESCALA("ESCALA","Escala"),
	FLAT("FLAT","Flat"),
;
	
	private String type;
	
	private String desc;
	
	TipoPago(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	@Override
	public String getValue() {
		return type;
	}
	
	public static TipoPago parse(String tipo)
	{
		TipoPago [] values = TipoPago.values();
		TipoPago target = null;
		for(TipoPago t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}
	
	
}
