function TitulosController(editForm, gridName) {
	this.editForm = editForm;
	this.service  = new TitulosService();
	var _data     = this.service.buscarTitulosPorFiltro({});
	this.grid     = new TitulosGrid(gridName, _data);
	var me        = this;
	
	this.uploader = new UploaderEX("cargaTitulosDiv" , function(data)
			{
				if(data.error == '' || data.error == null)
				{
					if(data.tipoCarga == 'N')
					{
						location.reload();
					}
					else
					{
						if (data.tipoCarga == 'C'){
							location.reload();
						} else {
							showMessage("El documento ["+data.fileUploadFileName+"] se ha subido con exito");
							me.buscarPorFiltro();
							$('#modalCarga').modal('hide');
							
							var resp = data.respuestaExcel;
							var totalErrores = resp.erroresNoControlados.length + resp.erroresControlados.length;
							var total = totalErrores + resp.exitos.length;
							$("#totalResultFile").html(total);
							$("#cargadoResultFile").html(resp.exitos.length);
							$("#rechazatoResultFile").html(totalErrores);
							$("#montoResultFile").html(resp.monto);
							$('#modalResultadosCarga').modal('show');
							
							if(totalErrores != 0) {
								$("#errorFile").show();
							}
							else {
								$("#errorFile").hide();
							}
						}
					}
					
				}
				else{
					showError(data.error);
					$('#modalCarga').modal('hide');
				}
			});
	this.initEditableForm();
}

TitulosController.prototype.leerForma = function(_forma,columns) {
	var _i = {};
	var me = this;
	columns.forEach(function(column, i) {
		var _item = $("#" + _forma + "   [name='" + column.name + "']");
		var val;
		if (_item.is(':checkbox')) {
			val = _item.prop('checked');
		} 
		else if (_item.is('select')) {
			if(_item.val()!= '')
			{
				val = {};
				val["desc"] = _item.find('option:selected').text();
				val["value"] = _item.val();
			}
		} 
		else if(_item.is(':radio'))
		{
			val = _item.filter(':checked').val();
		}
		else {
			val = _item.val();
		}
		if (val !== '') {
			me.service.deepSet(_i, column.name, val);
		}
	});
	return _i;
};

TitulosController.prototype.llenarForma = function(t,_forma,columns) {
	var me = this;
	columns.forEach(function(column, i) {
		var _item = $("#" + _forma + " [name='" + column.name + "']");
		var value = t[column.name];
		
		if (column.date  != null) {
			value = me.grid.grid.changeDateFormat(me.grid.grid.settings.dateFormatIn,
					me.grid.grid.settings.dateFormatOut, t[column.name]);
		}
		if (_item.is(':checkbox')) {
			_item.prop('checked', value);
		} else if (_item.is('select')) {
			if( typeof value != 'undefined'  && value != null )
			{
				_item.val(value.value);
			}
			
		} else if(_item.is(':radio'))
		{
			_item.filter("[value='"+value+"']" ).prop('checked', true);
		}
		else {
			_item.val(value);
		}
	});
}

TitulosController.prototype.limpiarForma = function(idForm) {
	$("#" + idForm).find(
			'input:text, input:hidden, input:password, input:file, select, textarea').val('');
	$("#" + idForm).find('input:radio, input:checkbox').removeAttr(
			'checked').removeAttr('selected');
};

TitulosController.prototype.openNewRow = function ()
{
	if ($("#idLAvalable").val() == $("#idLista").val())
	{	
		$("#fechaFin").datepicker("option", "minDate", null);
		$("#fechaInicio").datepicker("option", "maxDate", null);
		this["idFormTitulo"].resetForm();
		this.limpiarForma(this.editForm);
		$('#modalTitulo').modal('show');
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
};

TitulosController.prototype.openEditRow = function(link)
{
	$("#fechaFin").datepicker("option", "minDate", null);
	$("#fechaInicio").datepicker("option", "maxDate", null);
	this["idFormTitulo"].resetForm();
	this.limpiarForma(this.editForm);
	var index = $(link).attr("name");
	var a = this.grid.getItemByIndex(index);
	this.buscarCategoriasPagos(a.fechaInicio);
	this.llenarForma(a,this.editForm,this.grid.getColumns());
	$('#modalTitulo').modal('show');
};

TitulosController.prototype.openModal= function (idForm,idModal)
{
	$("#vFin").datepicker("option", "minDate", null);
	$("#vInicio").datepicker("option", "maxDate", null);
	this[idForm].resetForm();
	this.limpiarForma(idForm);
	var a = this.grid.itemsSelected();
	if(a.length == 0)
	{
		showError("Debe seleccionar m\u00EDnimo 1 registro");
	}
	else
	{	
		$('#'+idModal).modal('show');
	}
};

TitulosController.prototype.saveRow = function()
{
	if($("#idFormTitulo").valid())
	{
		var a = this.leerForma(this.editForm,this.grid.getColumns());
		if(a["idTituloCnt"] == '' || typeof a["idTituloCnt"] == 'undefined'){
			a["idLista"] =  $("#idLAvalable").val();
		}
		var indexes = [];
		indexes.push(a.idTituloCnt);
		this.save("EDITAR",a,indexes);
		$('#modalTitulo').modal('hide');	
	}
};

TitulosController.prototype.saveMultipleRow = function(idForm,modal,cambio)
{
	if($("#"+idForm).valid())
	{
		var a = this.leerForma(idForm,this.grid.getColumns());
		var v = this.grid.itemsSelected();
		var indexes = [];
		for(var i =0; i<v.length;i++)
		{
			indexes.push(v[i].idTituloCnt);
		}
		this.save(cambio,a,indexes);
		$('#'+modal).modal('hide');	
	}
};

TitulosController.prototype.buscarPorFiltro = function()
{
	var a = this.leerForma("idFormBusqueda",this.grid.getColumns());
	var _data = this.service.buscarTitulosPorFiltro(a);
	this.grid.reload(_data);
};


TitulosController.prototype.save = function (tipoCambio,item,indexes)
{
	var me = this;
	var indx = "";;
	for(var i=0;i<indexes.length;i++)
	{
		if(typeof indexes[i] != 'undefined'){
			indx+=indexes[i]+",";
		}
	}
	this.service.guardarTitulos(tipoCambio, item, indx, function (){
		showMessage("Datos guardados correctamente");
		me.buscarPorFiltro();
		me.cargarCatalogoTitulos();
	});
	
};

TitulosController.prototype.deleteItem = function (idForm)
{
	if($("#"+idForm).valid())
	{
		var me = this;
		var a ={};
		if(idForm == 'idFormEliminar' )
		{
			a = this.leerForma("idFormEliminar",this.grid.getColumns());
		}
		else
		{
			a = this.leerForma("idFormEliminarSAP",this.grid.getColumns());
		}
		this.service.eliminarTitulos(a, function () {
			$('#modalEliminar').modal('hide');
			$('#modalEliminarSAP').modal('hide');
			showMessage("Datos guardados correctamente");
			me.buscarPorFiltro();
		});
	}
};

TitulosController.prototype.openDeleteItem = function (link)
{
	var index = $(link).attr("name");
	var a = this.grid.getItemByIndex(index);
	$(".descTituloElim").html(a.descTitulo);
	this["idFormEliminar"].resetForm();
	this["idFormEliminarSAP"].resetForm();
	this.limpiarForma("idFormEliminar");
	this.limpiarForma("idFormEliminarSAP");
	if(a.idSap == '' || a.idSap == null || typeof a.idSap == 'undefined' )
	{
		this.llenarForma(a,"idFormEliminar",this.grid.getColumns());
		$('#modalEliminar').modal('show');
	}
	else
	{
		if(a.fechaInicio != null){
			var valueF = this.grid.grid.changeDateFormat(this.grid.grid.settings.dateFormatIn,
					this.grid.grid.settings.dateFormatOut, a.fechaInicio);
			$("#idFechaFinModalEliminar").datepicker("option", "minDate", valueF);
		}
		this.llenarForma(a,"idFormEliminarSAP",this.grid.getColumns());
		$('#modalEliminarSAP').modal('show');
	}
};

TitulosController.prototype.initEditableForm = function() {
	// Inicia date pickers
	var me = this;
	$('#fechaInicio').datepicker('option', 'onClose', function(selectedDate) {
		$("#fechaFin").datepicker("option", "minDate", selectedDate);
		me.buscarCategoriasPagos(selectedDate);
	});
	$('#fechaFin').datepicker('option', 'onClose', function(selectedDate) {
		$("#fechaInicio").datepicker("option", "maxDate", selectedDate);
	});
	
	$('#vInicio').datepicker('option', 'onClose', function(selectedDate) {
		$("#vFin").datepicker("option", "minDate", selectedDate);
	});
	$('#vFin').datepicker('option', 'onClose', function(selectedDate) {
		$("#vInicio").datepicker("option", "maxDate", selectedDate);
	});
	this.cargarCatalogoTitulos();
	// inicia validador de la forma
	this.idFormTitulo      = $("#idFormTitulo").validate({});
	this.idFormCategoria   = $("#idFormCategoria").validate({});
	this.idFormFormatos    = $("#idFormFormatos").validate({});
	this.idFormVentana     = $("#idFormVentana").validate({});
	this.idFormEliminarSAP = $("#idFormEliminarSAP").validate({});
	this.idFormEliminar    = $("#idFormEliminar").validate({});

};


TitulosController.prototype.cargarCatalogoTitulos = function() {
	// Inicia el auto completar de titulos
	var items = this.service.buscarCatalogoTitulos();
	var opts = new Bloodhound({
		datumTokenizer : Bloodhound.tokenizers.whitespace,
		queryTokenizer : Bloodhound.tokenizers.whitespace,
		local : items
	});
	$("#descTitulo").typeahead({
		hint : true,
		highlight : true,
		minLength : 1
	}, {
		name : 'Titulos',
		source : opts
	});
	$("#descTituloB").typeahead({
		hint : true,
		highlight : true,
		minLength : 1
	}, {
		name : 'Titulos',
		source : opts
	});
};

TitulosController.prototype.openCargarDocumento = function()
{
	if ($("#idLAvalable").val() == $("#idLista").val())
	{
		this.uploader.opentUploader();
	}
	else
	{
		showError("No es posible efectuar la acci\u00F3n");
	}
};

TitulosController.prototype.muestraFechaCarga = function(item)
{
	if($(item).val() == 'N')
	{
		$("#fechaInicioNuevaDiv").show();
	}else
	{
		$("#fechaInicioNuevaDiv").hide();
	}
};

TitulosController.prototype.startUpload = function(item)
{
	this.uploader.startUpload();
};

TitulosController.prototype.exportarBusqueda = function()
{
	var a = this.leerForma("idFormBusqueda",this.grid.getColumns());
	var _data = this.service.buscarTitulosPorFiltro(a);
	this.grid.reload(_data);
	this.service.descargarArchivo(a);
};

TitulosController.prototype.descargarArchivoErrores = function()
{
	this.service.descargarArchivoErrores();
};

TitulosController.prototype.guardarCambios =  function ()
{
	$("#trabajandoDiv").html("<h2 class='text-primary'> Guardando cambios </h2>");
	this.service.guardarCambios();
};

TitulosController.prototype.buscarPresupuesto =  function ()
{	
	var p = this.service.buscarPresupuesto();
	var columns = [
	               {name:"amortizable"},
	               {name:"comprometido"},
	               {name:"disponible"},
	               {name:"contratoActual"},
	               {name:"amortizableEstudio"},
	               {name:"comprometidoEstudiod"},
	               {name:"disponibleEstudio"}
	               ]; 
	this.llenarForma(p, "idFormPresupuesto", columns);
	if(p.errores != null)
	{
		if(p.errores.length != 0){showError(p.errores);}
	}
	this.buscarPorFiltro();
};

TitulosController.prototype.buscarCategoriasPagos =  function ( fecha)
{
	if(fecha !=''){
		this.service.buscarCategoriasPago(fecha, this.rellenaCombo);
	}
};

TitulosController.prototype.rellenaCombo =  function (nombre,valores)
{
	if(valores != null){
		$("#"+nombre).html("<option value=''>Seleccione</option>");
		valores.forEach(function(valor, i) {
			$("#"+nombre).append("<option value='"+valor.value+"'>"+valor.desc+"</option>");
		});
	}
};

var titulosController;

$().ready(function() {

	titulosController = new TitulosController("idFormTitulo", "dyn1");
});

