var releaseService  = function($filter, $http, $q, revenueService, precioService, tablaService, terminosValidateService) {

	return {
		
		crearTablaRelease: function(data, encabezados, objeto){
	    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Release"};
	    		    	    		    		    		    	
	    	//Se crean los metadatos de la tabla
	    	tabla.metadatos= [  {"nombre":"",  "tipo":"text",   "min":1, "max":10, "formateo":"numero"},
	   	                        {"nombre":"",  "tipo":"text",   "min":1, "max":10, "formateo":"numero"},
	   	                        {"nombre":"",  "tipo":"String", "min":1, "max":25, "formateo":"texto"}
	   	                     ];
	   		   	 
	    	tabla.datos = [];
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    	   
		           if(tabla.metadatos[j].tipo != "String")		    					    			
		    			fila.push({"valor" : $filter('number')(data[i][j])});
		    		else
			    	   fila.push({"valor" : data[i][j]});
			   }	
		       tabla.datos.push(fila);
		    }
		   			   	
		   	if(tabla.datos.length == 0)
		   	{
		   	    var fila = [];
		   	    fila.push({"valor" : null});
		   	    fila.push({"valor" : null});
		   	    fila.push({"valor" : null});
		   	    tabla.datos.push(fila);
		   	}		   		
	    
		   	tabla.mensajes = [""];
		   	for(var i=0; i < data.length;i++)
		   		tabla.mensajes.push("");
		   	 
	    	return tabla;
	    },
		
	    editarTablaRelease: function(operacion, index, tablaRelease, tablaPrecio, tablaRevenue, idsRelease, idsReleaseEli, formatos) {		
	    	var obj = {tablaRevenue:null, tablaRelease:null, tablaPrecios:null, idsRelease:null, idsReleaseEli:null};
	    	var tablaN;
			switch (operacion) 
			{
				case 'removeRow':
					tablaN       = tablaService.removeRow(tablaRelease.datos, index);															
					tablaPrecio  = precioService.editarTablaPrecios("removeRow", index, null, formatos, tablaPrecio);
					tablaRevenue = revenueService.editarTablaRevenue("removeRow", index, tablaRevenue);
															
					break;
				case 'addRow':
					tablaN       = tablaService.addRow(tablaRelease.datos);					
					tablaPrecio  = precioService.editarTablaPrecios("addRow", null, null, formatos, tablaPrecio);
					tablaRevenue = revenueService.editarTablaRevenue("addRow", null, tablaRevenue);
										
					break;
				default:
			}
			tablaRelease.datos            = tablaN.datos            != null ? tablaN.datos            : tablaRelease.datos;
			tablaRelease.columnasEliminar = tablaN.columnasEliminar != null ? tablaN.columnasEliminar : tablaRelease.columnasEliminar;
			tablaRelease.encabezados      = tablaN.encabezados      != null ? tablaN.encabezados      : tablaRelease.encabezados;
			
			obj.tablaRevenue  = tablaRevenue;
			obj.tablaRelease  = tablaRelease;
			obj.tablaPrecios  = tablaPrecio;
			obj.idsRelease    = null;
			obj.idsReleaseEli = null;
			return obj;
		},		
			    
	    actualizarReleaseCelda : function(fila, columna, tablaRelease, tablaRevenue, tablaPrecios, formatos, original) {

	    	var valor = tablaRelease.datos[fila][columna].valor;
	    	
	    	if (columna <= 1){
	    		if(isNaN(parseFloat(valor)))
		    		if(isNaN(parseFloat(original)))
	    			    valor = "0"; 
		    		else
		    			valor = original; 
	    		
	    		tablaRelease.datos[fila][columna].valor  = $filter('numDigMoneda')(String(valor));
	    	}else{
	    		if(valor && valor != ""){
					tablaRevenue.datos[fila][0].valor = valor;
					tablaPrecios.datos[fila * formatos.length][0].valor = valor;	
	    		}
	    	} 

			return {tablaRelease:tablaRelease, tablaRevenue:tablaRevenue, tablaPrecios:tablaPrecios}
	    },
	    	    
	    validarRelease : function(tablaRelease) {
	    	
			var continuar = true;

			if(continuar) 
			{ 
			  tablaRelease = terminosValidateService.validarCeldasVacias(tablaRelease, tablaRelease.datos[0].length, true); 
			  continuar    = terminosValidateService.mensajeValidacion(tablaRelease.valida, tablaRelease.nombre, ""); 
			}

			if(continuar) 
			{ 
			  tablaRelease = terminosValidateService.validarLongitudCeldas(tablaRelease, null, null, [2]); 
			  continuar    = terminosValidateService.mensajeValidacion(tablaRelease.valida, tablaRelease.nombre, ""); 
			}

			//Se validan categorias repetidas 		
			  
			if(continuar) 
			{ 
			   tablaRelease = terminosValidateService.validarCategoriasRepetidas(tablaRelease, 2); 
			   continuar    = terminosValidateService.mensajeValidacion(tablaRelease.valida, tablaRelease.nombre, ", existen categorias repetidas"); 
			}
			 
			//Se validan rangos 				  
			//if(continuar) 
			//{ 
			//  tablaRelease = terminosValidateService.validarRangosTablas(tablaRelease, 0 ,1, 0);
			//  continuar    = terminosValidateService.mensajeValidacion(tablaRelease.valida, tablaRelease.nombre, ""); 
			//}
			
			
			return continuar;
	    },
	    
	    obtenerEncabezadosExportar: function(){
	    	var enc = [];
	    	   enc[0] = "Desde";
			   enc[1] = "Hasta";
			   enc[2] = "Categorias";
			   return enc;
	    },
	    	              
	    importarExcelRelease: function(data, tablaRelease, tablaPrecio, tablaRevenue, idsRelease, idsReleaseEli, formatos){
	    	var res = {tablaRevenue:null, tablaRelease:null, tablaPrecios:null, idsRelease:null, idsReleaseEli:null};
	    	data.splice(0, 1);
			
			for(var i=0; i<data.length; i++)
			{
				if(!this.verifcarFilaVacia(data[i]))
				{
					var encontrado = false;
					for(var j=0; j<tablaRelease.datos.length; j++)
					{										
						if(tablaRelease.datos[j][2].valor == data[i].fila[2])
						{
							tablaRelease.datos[j][0].valor = data[i].fila[0];
							tablaRelease.datos[j][1].valor = data[i].fila[1];												
							encontrado = true;
						}					 
					}
					
					if(!encontrado)
					{						
						var obj = this.editarTablaRelease("addRow",null, tablaRelease, tablaPrecio, tablaRevenue, idsRelease, idsReleaseEli, formatos);
						
						tablaRevenue  = obj.tablaRevenue;
						tablaRelease  = obj.tablaRelease;
						tablaPrecios  = obj.tablaPrecio;
						idsRelease    = obj.idsRelease;
						idsReleaseEli = obj.idsReleaseEli;
											
						tablaRelease.datos[tablaRelease.datos.length-1][0].valor = data[i].fila[0];
						tablaRelease.datos[tablaRelease.datos.length-1][1].valor = data[i].fila[1];
						tablaRelease.datos[tablaRelease.datos.length-1][2].valor = data[i].fila[2];					
						tablaPrecio.datos[(tablaRelease.datos.length-1)*3][0].valor = data[i].fila[2];
						tablaRevenue.datos[tablaRelease.datos.length-1][0].valor = data[i].fila[2];
					}
				}
			}	 
			
			res.tablaRevenue  = tablaRevenue;
			res.tablaRelease  = tablaRelease;
			res.tablaPrecios  = tablaPrecio;
			res.idsRelease    = idsRelease;
			res.idsReleaseEli = idsReleaseEli;
			return res;
	    },
	    
	    verifcarFilaVacia : function(data) {		
			var cont = 0;
			
			for(var i=0; i<data.fila.length; i++)
			{
				if(data.fila[i] === "" || data.fila[i] == null)
				   cont++
			}
			
			if(cont == data.fila.length)
				return true;
			else
				return false;
		}


	};
};

registraService("releaseService", releaseService);