package com.mx.dla.dda.contrato.generales.bos;

import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.TitulosBroadViewDAO;
import com.mx.dla.dda.contrato.titulo.dtos.TituloBroadView;
import com.mx.dla.global.bos.BaseBO;

@Component
public class TitulosBroadViewBO extends BaseBO {
	
	@Autowired
	private TitulosBroadViewDAO titulosBv;
	
	public List<TituloBroadView> busquedaTitulosBraodView( Long contratoDda){
		List<TituloBroadView> titulos = titulosBv.buscarTitulosBroadView(contratoDda);
		TituloBroadView total = new TituloBroadView();
		int cntOk = 0;
		int cntError = 0;
		for (TituloBroadView titulo : titulos) {
			if(titulo.getValidaciones().equals("OK")) {
				cntOk++;
			}else {
				cntError++;
			}
		}
		total.setIdBv("Correctas: " + cntOk);
		total.setNombreUnico("Incorrectas: " + cntError);
		total.setValidaciones("Total: " + titulos.size());
		total.setContratoDda(Objects.nonNull(titulos.get(0)) ? titulos.get(0).getContratoDda() : StringUtils.EMPTY);
		titulos.add(0, total);
		return titulos;
	}
	
	public String insertaTitulosBraodView(Long contratoBv, Long contratoDda){
		titulosBv.insertaTitulosBroadView(contratoBv, contratoDda);
		return "";
	}
	
	public String actualizaTitulosBroadView(Long contratoDda){
		titulosBv.actualizaTitulosBroadView(contratoDda);
		return "";
	}
	
	public List<TituloBroadView> busquedaTitulosBraodViewTransac( Long contratoDda){
		List<TituloBroadView> titulos = titulosBv.buscarTitulosBroadViewTransac(contratoDda);
		TituloBroadView total = new TituloBroadView();
		int cntOk = 0;
		int cntError = 0;
		for (TituloBroadView titulo : titulos) {
			if(titulo.getValidaciones().equals("OK")) {
				cntOk++;
			}else {
				cntError++;
			}
		}
		total.setIdBv("Correctas: " + cntOk);
		total.setNombreUnico("Incorrectas: " + cntError);
		total.setValidaciones("Total: " + titulos.size());
		total.setContratoDda(Objects.nonNull(titulos.get(0)) ? titulos.get(0).getContratoDda() : StringUtils.EMPTY);
		titulos.add(0, total);
		return titulos;
	}
	
	public String insertaTitulosBraodViewTransac(Long contratoBv, Long contratoDda){
		titulosBv.insertaTitulosBroadViewTransac(contratoBv, contratoDda);
		return "";
	}
	
	public String actualizaTitulosBroadViewTransac(Long contratoDda){
		titulosBv.actualizaTitulosBroadViewTransac(contratoDda);
		return "";
	}
	
}
