package com.mx.dla.dda.contrato.titulo.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloGridBO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCambioTitulo;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

public class TituloGridAction extends BaseAction {

	private static final long serialVersionUID = 8148896697230880220L;

	@Autowired
	private TituloGridBO tituloGridBO;

	@Autowired
	private GeneralesBO generalesBO;

	private Titulo titulo;

	private List<Titulo> titulos;

	private String tipoCambio;

	private String idsTipoCambio;

	private String error;

	private CatalogoDTO categoriaTit;

	private CatalogoDTO pagoCateg;

	private String nombreUnico;

	private String descTitulo;

	private Date fechaInicio;

	private String mensaje;

	private List<SapNum> aumentos;

	private ContratoDTO contrato;

	public String guardar() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		Lista l = (Lista) getSession().get(ContratoConstats.LISTA_SESSION);

		try {
			if (TipoCambioTitulo.EDITAR.name().equals(tipoCambio)) {
				if (titulo.getIdTituloCnt() == null)
					this.mensaje = tituloGridBO.alta(ct, l, titulo);
				else
					tituloGridBO.cambio(ct, l, titulo);
			} else {
				tituloGridBO.cambioMultiple(ct, l, titulo, tipoCambio, this.getIds(idsTipoCambio));
			}
		} catch (TituloException e) {
			logger.error("Error :", e);
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String series() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		Lista l = (Lista) getSession().get(ContratoConstats.LISTA_SESSION);
		try {
			tituloGridBO.altaSeriesAuto(ct, l, titulo);
		} catch (TituloException e) {
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String baja() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		tituloGridBO.baja(ct, titulo);
		return SUCCESS;
	}

	public String busqueda() {
		try {
			titulos = tituloGridBO.busqueda(titulo, false, Lista.MIRROR);
		} catch (TituloException e) {
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String busquedaDetalle() {
		try {
			titulos = tituloGridBO.busquedaDetalle(titulo, false, Lista.MIRROR);
		} catch (TituloException e) {
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String busquedaAumentoSap() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		aumentos = tituloGridBO.getAumentosSapNumXTitulo(titulo.getIdTituloCnt(), ct.getIdContrato());
		return SUCCESS;
	}

	public String consultaContrato() throws TransaccionException {
		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		try {
			contrato = generalesBO.obtenContrato(idC);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public Titulo getTitulo() {
		return titulo;
	}

	public void setTitulo(Titulo titulo) {
		this.titulo = titulo;
	}

	public List<Titulo> getTitulos() {
		return titulos;
	}

	public void setTitulos(List<Titulo> titulos) {
		this.titulos = titulos;
	}

	public String getTipoCambio() {
		return tipoCambio;
	}

	public void setTipoCambio(String tipoCambio) {
		this.tipoCambio = tipoCambio;
	}

	public String getIdsTipoCambio() {
		return idsTipoCambio;
	}

	public void setIdsTipoCambio(String idsTipoCambio) {
		this.idsTipoCambio = idsTipoCambio;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public CatalogoDTO getCategoriaTit() {
		return categoriaTit;
	}

	public void setCategoriaTit(CatalogoDTO categoriaTit) {
		this.categoriaTit = categoriaTit;
	}

	public CatalogoDTO getPagoCateg() {
		return pagoCateg;
	}

	public void setPagoCateg(CatalogoDTO pagoCateg) {
		this.pagoCateg = pagoCateg;
	}

	public String getNombreUnico() {
		return nombreUnico;
	}

	public void setNombreUnico(String nombreUnico) {
		this.nombreUnico = nombreUnico;
	}

	public String getDescTitulo() {
		return descTitulo;
	}

	public void setDescTitulo(String descTitulo) {
		this.descTitulo = descTitulo;
	}

	public Date getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public String getMensaje() {
		return mensaje;
	}

	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}

	public List<Long> getIds(String ind) {
		List<Long> lista = new ArrayList<Long>();
		String[] indxs = ind.split(",");

		for (int i = 0; i < indxs.length; i++)
			lista.add(Long.parseLong(indxs[i]));
		return lista;
	}

	public List<SapNum> getAumentos() {
		return aumentos;
	}

	public void setAumentos(List<SapNum> aumentos) {
		this.aumentos = aumentos;
	}

	public ContratoDTO getContrato() {
		return contrato;
	}

	public void setContrato(ContratoDTO contrato) {
		this.contrato = contrato;
	}

}
