function eligeTemporadaCore() {
	//	RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio

	var actionpath = null;
	var parametros = null;

	if ($("#peliculasSeries").val() != "" && $("#peliculasSeries").val() != "Todos") {
		parametros = { idEstudio: $("#estudio").val(), nombreUnico: $("#peliculasSeries").val() };

		actionpath = '/reporte/reporteCostPerView/obtenerTemporada.action';

		if (actionpath != null) {

			$.post(contextPath + actionpath, parametros,
				function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {

						$('#temporadas')
							.find('option')
							.remove()
							.end()
							;

						if (data[0].desc == 'PELICULA') {
							$("#temporadas").append($('<option>', { value: "0", text: "PELICULA", selected: true }));
							$('#temporadas').prop('disabled', true);
						}
						else {
							$("#temporadas").append($('<option>', { value: "0", text: "Todos", selected: true }));

							for (var i = 0; i < data.length; i++)
								$("#temporadas").append($('<option>', {
									value: data[i].value,
									text: data[i].desc
								}));

							$('#temporadas').prop('disabled', false);

						}


					}


				}).fail(function() {
				});

		}




	} else {
		$("#temporadas").append($('<option>', { value: "0", text: "Todos", selected: true }));

		$('#temporadas').prop('disabled', true);
	}

}

var reporteDatosContratoController = function($scope, $filter, utileriasService) {

	$scope.cbvalue2 = 'NO';
	$scope.cbvalue3 = 'NO';
	$scope.cbvalue4 = 'YES';
	$scope.cbvalue5 = 'NO';
	$scope.activaBoton = 'NO';

	$scope.tipoReporte = null;
	$scope.tabla = null;
	$scope.aheader = null;
	$scope.bheader = null;
	$scope.estudios = [];
	$scope.estudio = null;
	$scope.hindex = null;
	$scope.paginationLimit = 100;
	$scope.totalDisplayed = $scope.paginationLimit;


	var nMeses = 1;
	var actualfecha = new Date();
	var year = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (actualfecha.getFullYear() - 1) : actualfecha.getFullYear();
	var month = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (12 + ((actualfecha.getMonth() + 1) - nMeses)) : ((actualfecha.getMonth() + 1) - nMeses);
	var date = ("00" + month).slice(-2) + '/' + year;

	$scope.fechaConsulta = date;

	$('#mes').datepicker({ dateFormat: 'mm/yy' });

	utileriasService.actionCall('/reporte/reporteCostPerView/inicializaCatalogos.action', {}).then(
		function(data) {
			if (data.errorMensaje != null)
				showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
			else {
				$scope.estudios = data.estudios;

				$("#estudio").append($('<option>', { value: "0", text: "Todos", selected: true }));
				$("#contratos").append($('<option>', { value: "0", text: "Todos", selected: true }));
				$("#peliculasSeries").append($('<option>', { value: "0", text: "Todos", selected: true }));
				$("#temporadas").append($('<option>', { value: "0", text: "Todos", selected: true }));

				for (var i = 0; i < $scope.estudios.length; i++)
					$("#estudio").append($('<option>', {
						value: $scope.estudios[i].value,
						text: $scope.estudios[i].desc
					}));

				$("#estudio").find('option').get(0).remove();
			}
		},
		function(error) {
			showError("Ha ocurrido un error.");
		}
	);

	$scope.muestraReporte = function(tipo, fecha, estudio) {

		$scope.generaReporte(tipo, fecha, estudio);

	}

	$scope.validaCasillas = function() {

		//cada ves que cambia el boton se activa la validacion

		if ($scope.cbvalue4 == "YES" && $scope.cbvalue5 == "YES" && $scope.cbvalue2 == "NO" && $scope.cbvalue3 == "YES") {
			showError("Al seleccionar amortizaci\u00F3n es necesario tener activada casilla T\u00EDtulos ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "NO" && $scope.cbvalue2 == "NO" && $scope.cbvalue3 == "NO") {
			showError("Es necesario tener activada alguna casilla ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "NO" && $scope.cbvalue2 == "NO" && $scope.cbvalue3 == "YES") {
			showError("Al seleccionar amortizaci\u00F3n es necesario tener activada casilla T\u00EDtulos ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "YES" && $scope.cbvalue5 == "NO" && $scope.cbvalue2 == "NO" && $scope.cbvalue3 == "YES") {
			showError("Al seleccionar amortizaci\u00F3n es necesario tener activada casilla T\u00EDtulos ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "NO" && $scope.cbvalue2 == "YES") {
			showError("Al seleccionar T\u00EDtulos es necesario tener activada casilla Datos generales  ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "YES" && $scope.cbvalue2 == "YES") {
			showError("Es necesario tener activada casilla Datos generales  ");
			$scope.activaBoton = 'NO';
		} else if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "YES") {
			showError("Al seleccionar Terminos comerciales es necesario tener activada casilla Datos generales  ");
			$scope.activaBoton = 'NO';
		} else {
			$scope.activaBoton = 'YES';
		}
	}

	$scope.resetTable = function() {
		$scope.validaCasillas();

		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;

	}
	$scope.activaFecha = function() {
		$scope.validaCasillas();

		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
	}
	$scope.generaReporte = function(tipo, fecha, estudio) {
		$scope.mostrarCargando = true;

		var parametros = { fecha: fecha, titulos: $scope.cbvalue2, amortizacion: $scope.cbvalue3, dgenerales: $scope.cbvalue4, tcomerciales: $scope.cbvalue5 };
		if ($("#estudio").val() != "")
			parametros = { fecha: fecha, idEstudio: $("#estudio").val(), contrato: $("#contratos").val(), nombreUnico: $("#peliculasSeries").val(), temporada: $("#temporadas").val(), titulos: $scope.cbvalue2, amortizacion: $scope.cbvalue3, dgenerales: $scope.cbvalue4, tcomerciales: $scope.cbvalue5 };

		var check = moment(fecha, 'MM/YYYY');
		var month = check.format('M');
		var size = 8;
		$scope.hindex = 0;

		if ($scope.cbvalue4 == "YES") {
			$scope.hindex = $scope.hindex + 12;
		}

		if ($scope.cbvalue5 == "YES") {
			$scope.hindex = $scope.hindex + 4;
		}

		if ($scope.cbvalue2 == "YES") {
			$scope.hindex = $scope.hindex + 11;
		}

		if ($scope.cbvalue3 == "YES") {
			$scope.hindex = $scope.hindex + 12;
		}

		$scope.totalDisplayed = $scope.paginationLimit;

		var actionpath = null;

		actionpath = '/reporte/reporteDatosContrato/obtenerDatosReporte.action';

		if (actionpath != null)
			utileriasService.actionCall(actionpath, parametros).then(function(data) {
				if (data.errorMensaje != null)
					showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
				else {
					$scope.tabla = data.reporteVista.tabla;
					$scope.bheader = data.reporteVista.rheader;
				}

				$scope.mostrarCargando = false;

			},
				function(error) {
					showError("Ha ocurrido un error.");
					$scope.mostrarCargando = false;
				});
	}

	$scope.descargaReporte = function(tipo, fecha, estudio) {

		var estudioParametro = "";
		if ($("#estudio").val() != "")
			estudioParametro = '&idEstudio=' + $("#estudio").val() +
				'&nombreUnico=' + $("#peliculasSeries").val() +
				'&temporada=' + $("#temporadas").val() +
				'&contrato=' + $("#contratos").val() +
				'&titulos=' + $scope.cbvalue2 +
				'&amortizacion=' + $scope.cbvalue3 +
				'&dgenerales=' + $scope.cbvalue4 +
				'&tcomerciales=' + $scope.cbvalue5;

		var url = contextPath + '/reporte/reporteDatosContrato/exportaReporte.action?tipoReporte=' + tipo + '&fecha=' + fecha + estudioParametro;
		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }

	}

	$scope.descargaZip = function(tipo, fecha, estudio) {

		if ($("#estudio").val() == "") {
			var url = contextPath + '/reporte/reporteDatosContrato/exportaZip.action?tipoReporte=' + tipo + '&fecha=' + fecha;
			try { window.open(url); }
			catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }
		}

	}

	$scope.imprime = function(idDivPrintArea, fecha) {

		$("#" + idDivPrintArea).printThis({
			importCSS: true,
			importStyle: true,
			header: "<h3 style='width: 950px; font-weight:bold;'><img style='padding-right: 50px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>REPORTE COST PER VIEW AL " + utileriasService.getMes(fecha) + " - " + utileriasService.getAnio(fecha) + "</h3>"

		});

	}

	$scope.descargaExcel = function() {
		var url = contextPath + '/reporte/reporteOveragesYPayments/descargarExcel.action';

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }
	}


	$scope.mostrarColumna = function(icolumna) {

		if ($scope.cbvalue4 == "YES" && icolumna <= 11) {
			return true;
		}

		if ($scope.cbvalue5 == "YES" && icolumna >= 12 && icolumna <= 15) {
			return true;
		}

		if ($scope.cbvalue2 == "YES" && icolumna >= 16 && icolumna <= 26) {
			return true;
		}

		if ($scope.cbvalue3 == "YES" && icolumna >= 27 && icolumna <= 38) {
			return true;
		}

		if ($scope.cbvalue4 == "NO" && $scope.cbvalue5 == "NO" && $scope.cbvalue2 == "NO" && $scope.cbvalue3 == "YES"
			&& (icolumna == 0 || icolumna == 1 || icolumna == 18 || icolumna == 20)) {
			return true;
		}
		return false;
	}



	$scope.obtenEstilo = function(row, column, x, y, tlength) {
		var styles = {};

		if (row[$scope.hindex] == 1) styles['font-weight'] = "900";
		if (row[$scope.hindex] == 2) { styles['font-weight'] = "600"; styles['color'] = "blue"; }
		if (row[$scope.hindex] == 3) { styles['font-weight'] = "100"; styles['color'] = "blue"; }

		if (y == 0 && x < tlength - 1)
			styles['text-align'] = "left";
		else
			styles['text-align'] = "right";

		return styles;
	}


	$scope.esStringVacio = function(valor) {
		return valor ? valor.trim().length == 0 : true;
	}

	$scope.loadMore = function() {
		$scope.totalDisplayed += $scope.paginationLimit;
	};

	$scope.reporteZip = function() {
		return $scope.esStringVacio($scope.estudio);
	};


	$scope.eligeEstudio = function() {
		$scope.estudio = $("#estudio").val();
		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
		$scope.contratos = $("#contratos").val();
		//		RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio

		var actionpath = null;
		var parametros = null;

		$('#contratos')
			.find('option')
			.remove()
			.end();

		if ($("#estudio").val() != "") {
			parametros = { idEstudio: $("#estudio").val() };
			actionpath = '/reporte/reporteDatosContrato/obtenerContratos.action';

			if (actionpath != null)
				utileriasService.actionCall(actionpath, parametros).then(function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {

						$('#contratos')
							.find('option')
							.remove()
							.end();

						$("#contratos").append($('<option>', { value: "0", text: "Todos", selected: true }));

						for (var i = 0; i < data.contratos.length; i++)
							$("#contratos").append($('<option>', {
								value: data.contratos[i].value,
								text: data.contratos[i].desc
							}));

						$('#contratos').prop('disabled', false);
						$('#contratos').focus();

					}

				},
					function(error) {
						showError("Ha ocurrido un error.");
					});



		} else {
			$("#contratos").append($('<option>', { value: "0", text: "Todos", selected: true }));

			$('#contratos').prop('disabled', true);
			$('#peliculasSeries').prop('disabled', true);
			$('#temporadas').prop('disabled', true);
		}

	}

	$scope.eligeContrato = function() {
		$scope.contratos = $("#contratos").val();
		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
		$scope.peliculasSeries = $("#peliculasSeries").val();

		//		RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio

		var actionpath = null;
		var parametros = null;

		if ($("#contratos").val() != "") {
			parametros = { contrato: $("#contratos").val() };
			actionpath = '/reporte/reporteDatosContrato/obtenerSeriesyPeliculas.action';

			if (actionpath != null)
				utileriasService.actionCall(actionpath, parametros).then(function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {
						$('#peliculasSeries')
							.find('option')
							.remove()
							.end();

						$("#peliculasSeries").append($('<option>', { value: "0", text: "Todos", selected: true }));

						for (var i = 0; i < data.peliculas_series.length; i++)
							$("#peliculasSeries").append($('<option>', {
								value: data.peliculas_series[i].value,
								text: data.peliculas_series[i].desc
							}));

						$('#peliculasSeries').prop('disabled', false);
						$('#peliculasSeries').focus();

					}

				},
					function(error) {
						showError("Ha ocurrido un error.");
					});

		} else {
			$('#peliculasSeries').prop('disabled', true);
			$('#temporadas').prop('disabled', true);
		}

	}


	$scope.eligeTemporada = function() {
		$scope.estudio = $("#estudio").val();
		$scope.peliculaSerie = $("#peliculasSeries").val();
		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
		//		RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio

		var actionpath = null;
		var parametros = null;

		if ($("#peliculasSeries").val() != "" && $("#peliculasSeries").val() != "Todos") {
			parametros = { idEstudio: $("#estudio").val(), nombreUnico: $("#peliculasSeries").val() };

			actionpath = '/reporte/reporteCostPerView/obtenerTemporada.action';
			$.post(contextPath + actionpath, parametros,
				function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {
						$('#temporadas')
							.find('option')
							.remove()
							.end();

						if (data[0].desc == 'PELICULA') {
							$("#temporadas").append($('<option>', { value: "0", text: "PELICULA", selected: true }));
							$('#temporadas').prop('disabled', true);
						}
						else {
							$("#temporadas").append($('<option>', { value: "0", text: "Todos", selected: true }));

							for (var i = 0; i < data.length; i++)
								$("#temporadas").append($('<option>', {
									value: data[i].value,
									text: data[i].desc
								}));
							$('#temporadas').prop('disabled', false);
						}

					}

				}).fail(function() {
				});
		} else {
			$('#temporadas').prop('disabled', true);
		}

	}
}

registraController("reporteDatosContratoController", reporteDatosContratoController);