package com.mx.dla.dda.admin.catalogos.estudios.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.ReporteAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoContratoDTO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.EstudioMenuDTO;

public interface CatalogoEstudiosDAO {

	public List<CatalogoEstudioDTO> catalogoEstudios();
	public List<EstudioAddonDTO> catalogoEstudiosAddOn();
	public EstudioAddonDTO catalogoEstudiosAddOnById(@Param("idEstudio")Long idEstudio);
	public List<EstudioMenuDTO> menuCatalogoEstudios();
	public void updateAddon(EstudioAddonDTO addon);
	public CatalogoEstudioDTO catalogoEstudiosPorId( int idEstudio );
	public CatalogoEstudioDTO obtenerEstudioPorId(Long idEstudio );
	public void updateEstudio(CatalogoEstudioDTO catalogoEstudioDTO);
	public void guardarEstudio(CatalogoEstudioDTO catalogoEstudioDTO);
	public void actualizaEstudio(CatalogoEstudioDTO estudio);
	public Long findIdGrupoDefault();
	public List<String> obtenSiglaEstudios(@Param("idEstudio")Long idEstudio, @Param("sigla") String sigla);
	public Integer numContratosXEstuio(@Param("idEstudio")Long idEstudio);
	public List<ReporteAddonDTO> getTiposReporte();
	public ReporteAddonDTO getTiposReporteById(@Param("id")String id);
	public void guardarAddon(EstudioAddonDTO addon);
	public void guardarHistorico(@Param("idEstudio")Long idEstudio,@Param("anio")Integer anio,@Param("mes")Integer mes,@Param("reportetype")Integer reportetype);
	public void cerrarHistorico(@Param("idEstudio")Long idEstudio,@Param("anio")Integer anio,@Param("mes")Integer mes);
	public List<CatalogoContratoDTO> contratosByEstudio(@Param("idEstudio")Long idEstudio);
}
