package com.mx.dla.dda.contrato.titulos.bos;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.Test;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloChunkDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloErrores;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;

public class TituloTest extends BaseDaoTest{

	@Autowired
	protected TituloDAO tituloDAO;
		
	@Autowired
	private CatalogosDAO catalogosDAO;
	
	@Autowired
	private TituloDmDAO tituloDmDAO;
	
	@Autowired
	private TituloChunkDAO tituloChunkDAO;
	
	@Autowired
	protected ListaDAO listaDAO;
	
	@Autowired
	protected TituloErrores tituloErrores;
		
	@Test(enabled = false)
	public void buscaTitulos()
	{
		
		List<CatalogoDTO> c =catalogosDAO.buscarFormatos();
		Assert.assertNotNull(c);
		for(CatalogoDTO a : c)
		{
			logger.debug("El catalogo [{}]",a);
		}
		
	}
				
	@Test(enabled = false)
	public void buscaFiltro()
	{
		Titulo t = new Titulo();
		
		t.setIdLista(52L);
//		t.setFrom(1L);
//		t.setTo(10L);
		//t.setDescTitulo("Breaking");
		List<Titulo>  titulos = tituloDmDAO.buscarTituloFiltroPaginado(t);
		logger.debug(titulos.toString());
		logger.debug("Total [{}]",titulos.size());
		Assert.assertNotNull(titulos);
		Assert.assertFalse(titulos.isEmpty());		
	}
	
	@Test(enabled = false)
	public void insertChunk()
	{
		
		tituloDmDAO.borrarTitulosPorLista(129L);
		List<Titulo> titulos = tituloDAO.buscarTitulosPorLista(129L);
		
		
		int total = titulos.size();
		int chunk = 100;
		int step = 0;
		int end = (total / chunk) +1;
		
		logger.debug("Total [{}]",total);
		logger.debug("End [{}]",end);
		Date a = new Date();
		if(total != 0){
			do
			{
				int from = step * chunk;
				int to  = from + chunk  > total ?  from + (total % chunk)  : from + chunk;
				step ++;
				logger.debug(" step[{}] from [{}]   ,  to [{}]",new Object[] {step, from, to-1});

				List<Titulo> p = titulos.subList(from, to);
				tituloChunkDAO.aEspejo(p);
				
			}while(step != end);
		}
		
		logger.debug("Total time ms [{}]",new Date().getTime() - a.getTime() );
		
		
		tituloDmDAO.borrarTitulosPorLista(129L);
		
		a = new Date();
		//tituloChunkDAO.aEspejoPorLista(129L);
		logger.debug("Total time 2 ms [{}]",new Date().getTime() - a.getTime() );
	}

	@Test(enabled = false)
	public void testNuevoDAOLista()
	{
		//squirrel -> /home/mike/SQuirreL SQL Client/squirrel-sql.sh
		List<Lista> lreal = listaDAO.buscarListas(160L,Lista.REAL);
		List<Lista> lespejo = listaDAO.buscarListas(160L,Lista.MIRROR);
		
		for(int i = 0 ; i<lreal.size() ; i++)
		{
			tituloChunkDAO.aTituloEspejoPorLista(lreal.get(i).getIdLista(), lespejo.get(i).getIdLista());
		}
	}
		
	@Test(enabled = false)
	public void testCorrectosCarga()
	{
		List<Long> a = new ArrayList<Long>();
		a =  tituloDmDAO.buscarIdsPorIdCarga("1");
		Assert.assertNotNull(a);
		Assert.assertTrue(a.size() == 0);
		
	}

	@Test(enabled = false)
	public void insertarSapSubnum(){
		SapNum sapNum = new SapNum(1l, 1l,1l);
		tituloDmDAO.insertarSapSubnum(sapNum);
	}
			
}
