/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.presupuestos.bos;

import com.mx.dla.dda.admin.presupuestos.dtos.AmortApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.ApartadoPreBD;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoDTO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresupuestoUtil {
    private static DecimalFormat df = new DecimalFormat("#.00");
    private static Logger logger = LoggerFactory.getLogger((String)"app");
    private static int ANIOMINIMO = 2013;

    public static PresupuestoApartadoDTO generarApartado(Double monto, Date fechaSap, PresupuestoApartadoDTO apartado, Long idPreApar) {
        apartado.setMontoAsignado(Double.valueOf(Double.parseDouble(df.format(monto))));
        apartado.setIdPreApart(idPreApar);
        return apartado;
    }

    public static Map<Integer, List<PresupuestoApartadoDTO>> getApartadosXAnio(List<PresupuestoApartadoDTO> apartados, List<PresupuestoDTO> presupuestos, Map<Long, Long> idTemp) {
        HashMap<Integer, List<PresupuestoApartadoDTO>> mapPre = new HashMap<Integer, List<PresupuestoApartadoDTO>>();
        for (int i = Calendar.getInstance().get(1) + 1; i >= ANIOMINIMO; --i) {
            ArrayList<PresupuestoApartadoDTO> apart = new ArrayList<PresupuestoApartadoDTO>(apartados.size());
            apart.addAll(apartados);
            mapPre.put(i, apart);
        }
        for (PresupuestoDTO pre : presupuestos) {
            if (!idTemp.containsKey(((PresupuestoApartadoDTO)pre.getApartados().get(0)).getId())) {
                idTemp.put(((PresupuestoApartadoDTO)pre.getApartados().get(0)).getId(), ((PresupuestoApartadoDTO)pre.getApartados().get(0)).getId());
            }
            PresupuestoApartadoDTO apartado = PresupuestoUtil.generarApartado(pre.getMontoAsignado(), pre.getFechaSAP(), (PresupuestoApartadoDTO)pre.getApartados().get(0), pre.getId());
            if (mapPre.containsKey(pre.getAnio())) {
                ((PresupuestoApartadoDTO)pre.getApartados().get(0)).setIdPreApart(pre.getId());
                ((PresupuestoApartadoDTO)pre.getApartados().get(0)).setFechaSAP(pre.getFechaSAP());
                List<PresupuestoApartadoDTO> actualizados = PresupuestoUtil.buscarApartado((List)mapPre.get(pre.getAnio()), (PresupuestoApartadoDTO)pre.getApartados().get(0));
                mapPre.put(pre.getAnio(), actualizados);
                continue;
            }
            ArrayList<PresupuestoApartadoDTO> apart = new ArrayList<PresupuestoApartadoDTO>(apartados.size());
            apart.addAll(apartados);
            List<PresupuestoApartadoDTO> actualizados = PresupuestoUtil.buscarApartado(apart, apartado);
            mapPre.put(pre.getAnio(), actualizados);
        }
        return mapPre;
    }

    public static List<PresupuestoApartadoDTO> buscarApartado(List<PresupuestoApartadoDTO> apartados, PresupuestoApartadoDTO apartado) {
        boolean encontrado = false;
        for (PresupuestoApartadoDTO apart : apartados) {
            if (apart.getId().longValue() != apartado.getId().longValue()) continue;
            encontrado = true;
            int index = apartados.indexOf(apart);
            PresupuestoApartadoDTO ap = new PresupuestoApartadoDTO();
            ap.setMontoAsignado(Double.valueOf(Double.parseDouble(df.format(apartado.getMontoAsignado()))));
            ap.setFechaSAP(apartado.getFechaSAP());
            ap.setId(apart.getId());
            ap.setNombre(apart.getNombre());
            ap.setType(apart.getType());
            ap.setIdPreApart(apartado.getIdPreApart());
            apartados.set(index, ap);
        }
        if (!encontrado) {
            apartados.add(apartado);
        }
        return apartados;
    }

    public static Map<String, Double> getAmortXApartados(List<Long> idApartados, List<AmortApartadoDTO> amortizacion) {
        HashMap<String, Double> apartadosAmor = new HashMap<String, Double>();
        for (AmortApartadoDTO am : amortizacion) {
            if (!apartadosAmor.containsKey(am.getAnio() + "-" + am.getId())) {
                apartadosAmor.put(am.getAnio() + "-" + am.getId(), am.getMontoAsignado());
                continue;
            }
            apartadosAmor.put(am.getAnio() + "-" + am.getId(), (Double)apartadosAmor.get(am.getAnio() + "-" + am.getId()) + am.getMontoAsignado());
        }
        return apartadosAmor;
    }

    public static List<PresupuestoDTO> getSumarizadoPresupuestos(Map<String, Double> apartadosAmor, Map<Integer, List<PresupuestoApartadoDTO>> apartados, List<AmortApartadoDTO> amortizables) {
        ArrayList<PresupuestoDTO> preAmortizables = new ArrayList<PresupuestoDTO>();
        for (Map.Entry<String, Double> entry : apartadosAmor.entrySet()) {
            String[] llave = entry.getKey().split("-");
            if (apartados.get(Integer.parseInt(llave[0])) == null) continue;
            for (PresupuestoApartadoDTO apartado : apartados.get(Integer.parseInt(llave[0]))) {
                Long idApartado = Long.parseLong(llave[1]);
                if (apartado.getId().longValue() != idApartado.longValue()) continue;
                apartado.setMontoComprometido(entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : apartados.entrySet()) {
            double comprometido = 0.0;
            double asignado = 0.0;
            for (PresupuestoApartadoDTO apartado : (List)entry.getValue()) {
                asignado = apartado.getMontoAsignado() == null ? asignado : asignado + apartado.getMontoAsignado();
                comprometido = apartado.getMontoComprometido() == null ? comprometido : comprometido + apartado.getMontoComprometido();
            }
            asignado = Double.parseDouble(df.format(asignado));
            comprometido = Double.parseDouble(df.format(comprometido));
            PresupuestoDTO pre = new PresupuestoDTO("Amortizable", (Integer)entry.getKey(), Double.valueOf(asignado), Double.valueOf(comprometido), (List)entry.getValue());
            for (AmortApartadoDTO amort : amortizables) {
                if (amort.getAnio().intValue() != pre.getAnio().intValue()) continue;
                pre.setMontoAmortizable(Double.valueOf(Double.parseDouble(df.format(amort.getMontoAsignado()))));
            }
            preAmortizables.add(pre);
        }
        return preAmortizables;
    }

    public static PresupuestoApartadoDTO apartadoPreBD2PresupuestoApartadoDTO(ApartadoPreBD bd) {
        PresupuestoApartadoDTO pto = new PresupuestoApartadoDTO();
        pto.setId(bd.getIdApartado());
        pto.setNombre(bd.getDescApartado());
        pto.setIdSap(bd.getIdSap());
        return pto;
    }
}

