/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.generales.bos;

import com.mx.dla.dda.contrato.generales.daos.ValidacionGeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.ws.dtos.ItemOrdenCompraDTO;
import com.mx.dla.dda.contrato.ws.dtos.ItemPosicionDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamAdendumEnmiendaDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamOrdenCompraDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ParametersWebService
extends BaseBO {
    @Autowired
    private ValidacionGeneralesDAO validacionGeneralesDAO;
    @Value(value="${adendumEnmienda.idPosicion}")
    private String idPosicionAdEn;
    @Value(value="${ordenInterna.idPosicion}")
    private String idPosicionOrdInt;
    @Value(value="${ordenInterna.idMaterial.suscripcion}")
    private String idMaterialSuscripcion;
    @Value(value="${ordenInterna.idMaterial.transaccines}")
    private String idMaterialTransaccion;
    @Value(value="${ordenInterna.idMaterial.licenseFee}")
    private String idMaterialLicense;
    @Value(value="${ordenInterna.centro}")
    private String centroOrdInt;
    @Value(value="${ordenInterna.precio}")
    private String precioOrdInt;
    @Value(value="${ordenInterna.indicadorIva}")
    private String indicadorIvaOrdInt;
    @Value(value="${ordenInterna.tipoImputacion.siAmortizable}")
    private String tipoInputacionSiAmortizableOrdInt;
    @Value(value="${ordenInterna.tipoImputacion.noAmortizable}")
    private String tipoInputacionNoAmortizableOrdInt;
    @Value(value="${ordenInterna.idPosicionAcc}")
    private String idPosicionAccOrdInt;
    @Value(value="${ordenInterna.centroCostos}")
    private String centroCostosOrdInt;
    @Value(value="${ordenInterna.idOrden}")
    private String idOrdenOrdInt;
    @Value(value="${ordenInterna.sociedad}")
    private String sociedadOrdInt;
    @Value(value="${ordenInterna.claseDoc.t}")
    private String claseDocTOrdInt;
    @Value(value="${ordenInterna.claseDoc.a}")
    private String claseDocAOrdInt;
    @Value(value="${ordenInterna.claseDoc.na}")
    private String claseDocNaOrdInt;
    @Value(value="${ordenInterna.orgCompras}")
    private String orgComprasOrdInt;
    @Value(value="${ordenInterna.grupoCompras}")
    private String grupoComprasOrdInt;

    public ParamOrdenCompraDTO obtenParametroOrdenCompra(ContratoDTO contrato, String expediente) {
        ItemOrdenCompraDTO itemDTO = new ItemOrdenCompraDTO();
        ArrayList<ItemOrdenCompraDTO> listItemDTO = new ArrayList<ItemOrdenCompraDTO>();
        ParamOrdenCompraDTO paramDTO = new ParamOrdenCompraDTO();
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd.MM.yyyy");
        boolean amortizable = false;
        if (contrato.getAmortizable().equals("SI")) {
            amortizable = true;
        }
        this.logger.debug("Amortizable: " + amortizable);
        itemDTO.setIdPosicion(this.idPosicionOrdInt);
        if (contrato.getIdTipoContrato() == 1L) {
            itemDTO.setIdMaterial(this.idMaterialSuscripcion);
        } else if (contrato.getIdTipoContrato() == 2L) {
            itemDTO.setIdMaterial(this.idMaterialTransaccion);
        } else {
            itemDTO.setIdMaterial(this.idMaterialLicense);
        }
        itemDTO.setCentro(this.centroOrdInt);
        Double cantidad = this.validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
        this.logger.info("cantidad : " + cantidad);
        if (contrato.getIdTipoContrato() == 1L || contrato.getIdTipoContrato() == 3L) {
            if (cantidad != null) {
                itemDTO.setCantidad(String.format("%.2f", cantidad));
            } else {
                itemDTO.setCantidad("1");
            }
        } else {
            itemDTO.setCantidad("1");
        }
        itemDTO.setPrecio("1");
        itemDTO.setIndicadorIVA(contrato.getClaveIva());
        if (amortizable) {
            itemDTO.setTipoImputacion(this.tipoInputacionSiAmortizableOrdInt);
        } else {
            itemDTO.setTipoImputacion(this.tipoInputacionNoAmortizableOrdInt);
        }
        itemDTO.setIdPosicionAcc(this.idPosicionAccOrdInt);
        if (amortizable) {
            itemDTO.setCentroCostos("");
        } else {
            itemDTO.setCentroCostos(this.centroCostosOrdInt);
        }
        if (amortizable) {
            itemDTO.setIdOrden(this.validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado()));
        } else {
            itemDTO.setIdOrden("");
        }
        listItemDTO.add(itemDTO);
        paramDTO.setSociedad(this.sociedadOrdInt);
        if (contrato.getIdTipoContrato() == 2L) {
            paramDTO.setClaseDoc(this.claseDocTOrdInt);
        } else if (amortizable) {
            paramDTO.setClaseDoc(this.claseDocAOrdInt);
        } else {
            paramDTO.setClaseDoc(this.claseDocNaOrdInt);
        }
        paramDTO.setIdProveedor(this.validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());
        paramDTO.setOrgCompras(this.orgComprasOrdInt);
        paramDTO.setGrupoCompras(this.grupoComprasOrdInt);
        paramDTO.setFechaDoc(formatoDeFecha.format(new Date()));
        paramDTO.setReferencia(contrato.getNumeroContrato());
        paramDTO.setIdContrato(contrato.getIdContrato().toString());
        paramDTO.setExpediente(expediente);
        paramDTO.setItems(listItemDTO);
        return paramDTO;
    }

    public ParamAdendumEnmiendaDTO obtenParametroEnmienda(ContratoDTO contrato, String expediente) {
        ItemPosicionDTO itemDTO = new ItemPosicionDTO();
        ArrayList<ItemPosicionDTO> listItemDTO = new ArrayList<ItemPosicionDTO>();
        ParamAdendumEnmiendaDTO paramDTO = new ParamAdendumEnmiendaDTO();
        Date fechaModificaSAP = contrato.getFechaModificaSAP();
        boolean modifica = false;
        Double cantidadP = 0.0;
        Double cantidadH = 0.0;
        cantidadP = this.validacionGeneralesDAO.obtenCantidad(contrato.getIdContratoOriginal());
        cantidadH = this.validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
        String ordenInterna = this.validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado());
        if (fechaModificaSAP == null) {
            if (cantidadP != null && cantidadH != null) {
                if (cantidadP - cantidadH != 0.0) {
                    modifica = true;
                }
            } else {
                this.logger.debug("cantidadH en hardcode : " + cantidadH);
            }
        }
        this.logger.debug("cantidadP = " + cantidadP + " cantidadH = " + cantidadH + " modifica : " + modifica + " posicion : " + this.idPosicionAdEn);
        itemDTO.setPosicion(this.idPosicionAdEn);
        itemDTO.setCantidad(cantidadH.toString());
        listItemDTO.add(itemDTO);
        paramDTO.setIdContrato(contrato.getIdContrato().toString());
        paramDTO.setIdSAP(contrato.getIdSap());
        paramDTO.setExpediente(expediente);
        paramDTO.setProveedor(this.validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());
        paramDTO.setClaveIVA(contrato.getClaveIva());
        paramDTO.setOrdenInterna(ordenInterna);
        return paramDTO;
    }
}

