/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.minimum.bos;

import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.contrato.minimum.daos.MinimunDAO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimumPantallaDTO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimunDTO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MinimunBO {
    static final Logger logger = Logger.getLogger(MinimunBO.class);
    private final DecimalFormat formateador = new DecimalFormat("###,###");
    @Autowired
    private MinimunDAO minimunDAO;

    public List<MinimumPantallaDTO> getValoresMinimun(Long idContrato, List<FormatoDTO> formatos, List<ReleaseDTO> releasses, List<PaisVentaDTO> paises) {
        ArrayList<MinimumPantallaDTO> valores = new ArrayList<MinimumPantallaDTO>();
        ArrayList<MinimumPantallaDTO> valoresAux = new ArrayList<MinimumPantallaDTO>();
        List valoresBD = new ArrayList();
        ArrayList<Long> idPaises = new ArrayList<Long>();
        for (PaisVentaDTO pais : paises) {
            idPaises.add(pais.getIdPais());
        }
        valoresBD = this.minimunDAO.getMinimunsXPais(idPaises, idContrato);
        MinimumPantallaDTO encabezados = new MinimumPantallaDTO();
        ArrayList<String> encabezadosValores = new ArrayList<String>();
        encabezados.setPais("Pa\u00c3\u00adses");
        boolean listo = false;
        for (PaisVentaDTO pais : paises) {
            MinimumPantallaDTO minPantalla = new MinimumPantallaDTO();
            minPantalla.setPais(pais.getDescripcionPais());
            ArrayList<String> idRegistros = new ArrayList<String>();
            ArrayList<String> valorPantalla = new ArrayList<String>();
            for (ReleaseDTO release : releasses) {
                for (FormatoDTO formato : formatos) {
                    if (!listo) {
                        encabezadosValores.add(formato.getDescripcion());
                    }
                    boolean encontrado = false;
                    for (MinimunDTO minimun : valoresBD) {
                        if (minimun.getIdPais().intValue() != pais.getIdPais().intValue() || minimun.getIdRealese().intValue() != release.getIdRelease().intValue() || minimun.getIdFormato().intValue() != formato.getIdFormato().intValue()) continue;
                        idRegistros.add("" + idContrato + "-" + pais.getIdPais() + "-" + release.getIdRelease() + "-" + formato.getIdFormato() + "-" + minimun.getIdMinimun());
                        valorPantalla.add(this.formateador.format(minimun.getMonto()));
                        encontrado = true;
                        break;
                    }
                    if (encontrado) continue;
                    idRegistros.add("" + idContrato + "-" + pais.getIdPais() + "-" + release.getIdRelease() + "-" + formato.getIdFormato() + "-" + 0);
                    valorPantalla.add("");
                }
            }
            listo = true;
            minPantalla.setIdRegistro(idRegistros);
            minPantalla.setValores(valorPantalla);
            valoresAux.add(minPantalla);
        }
        encabezados.setValores(encabezadosValores);
        valores.add(encabezados);
        valores.addAll(valoresAux);
        return valores;
    }

    public void actualizarInformacion(List<MinimunDTO> minimuns) {
        ArrayList<MinimunDTO> minimunsInsert = new ArrayList<MinimunDTO>();
        ArrayList<MinimunDTO> minimunsAct = new ArrayList<MinimunDTO>();
        for (MinimunDTO item : minimuns) {
            if (item.getIdMinimun().intValue() == 0 && item.getMonto() != null) {
                minimunsInsert.add(item);
                continue;
            }
            if (item.getIdMinimun().intValue() == 0 || item.getMonto() == null) continue;
            minimunsAct.add(item);
        }
        if (!minimunsAct.isEmpty()) {
            this.actualizarMinimun(minimunsAct);
        }
        if (!minimunsInsert.isEmpty()) {
            this.agregarMinimun(minimunsInsert);
        }
    }

    public void agregarMinimun(List<MinimunDTO> minimuns) {
        for (MinimunDTO minimun : minimuns) {
            minimun.setIdMinimun(this.minimunDAO.getSecuenciaMinimun());
        }
        this.minimunDAO.agregarMinimun(minimuns);
    }

    public void actualizarMinimun(List<MinimunDTO> minimuns) {
        this.minimunDAO.actualizarMinimun(minimuns);
    }
}

