/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.amortizacion.bos;

import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.reporte.amortizacion.daos.ReporteAmortizacionDAO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RegistroMontoDTO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RegistroRubroDTO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RemanenteDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteAmortizacionBO
extends BaseBO {
    @Autowired
    private ReporteAmortizacionDAO reporteAmortizacionDAO;
    @Autowired
    private CatalogoEstudiosDAO catalogoEstudiosDAO;

    public List<RegistroRubroDTO> obtenListaMontosTotalesContratoPorEstudio(Long idEstudio, Long idContrato, String fecha, Long mesesSearch) throws ParseException {
        ArrayList<RegistroRubroDTO> totalesPorContrato = new ArrayList<RegistroRubroDTO>();
        List montosContrato = this.reporteAmortizacionDAO.obtenMontosTotalesContrato(idEstudio, fecha, mesesSearch);
        HashMap contratosMonto = new HashMap();
        for (RegistroMontoDTO monto : montosContrato) {
            if (Objects.isNull(contratosMonto.get(monto.getIdContrato()))) {
                contratosMonto.put(monto.getIdContrato(), new ArrayList());
            }
            ((List)contratosMonto.get(monto.getIdContrato())).add(monto);
        }
        List<String> meses = this.getFechasAConsultar(fecha);
        for (Map.Entry contrato : contratosMonto.entrySet()) {
            List montos = (List)contrato.getValue();
            List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
            if (montos == null || montos.isEmpty()) continue;
            for (RegistroMontoDTO item : montos) {
                this.buscaRegistroMontoMes(list, item);
            }
            if (idContrato != null && idContrato >= 0L && !idContrato.equals(((RegistroMontoDTO)montos.get(0)).getIdContrato())) continue;
            RegistroRubroDTO totalContrato = new RegistroRubroDTO();
            totalContrato.setId((Long)contrato.getKey());
            totalContrato.setDescripcion(((RegistroMontoDTO)montos.get(0)).getNumContrato());
            totalContrato.setCosto(((RegistroMontoDTO)montos.get(0)).getCosto());
            totalContrato.setMontoMes(list);
            totalContrato.setFechaFin(((RegistroMontoDTO)montos.get(0)).getFechaFin());
            totalContrato.setFechainicio(((RegistroMontoDTO)montos.get(0)).getFechaInicio());
            totalContrato.setCodigoSAP("-");
            totalContrato.setSistema("DDA");
            totalContrato.setIdBroadview("-");
            totalContrato.setRemanente(new Double(0.0));
            totalesPorContrato.add(totalContrato);
        }
        return totalesPorContrato;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudio(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudio(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        totalesEstudio.setRemanente(new Double(0.0));
        return totalesEstudio;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudioDLASAP(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudio(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        return totalesEstudio;
    }

    private void addMontoEstudio(RegistroRubroDTO princ, Map<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA, int place, Long idEstudio, String fecha, String sistema, Integer month) throws ParseException {
        if (Objects.nonNull(princ)) {
            RegistroRubroDTO ant = this.obtenMontosTotalesPorEstudio(idEstudio, fecha);
            RegistroRubroDTO sig = this.obtenMontosTotalesPorEstudio(idEstudio, fecha);
            princ.setSistema(sistema);
            princ.setAcumuladoAnterior(Double.valueOf(0.0));
            princ.setAcumuladoPosterior(Double.valueOf(0.0));
            princ.setId(Long.valueOf(-1L));
            if (Objects.nonNull(ant)) {
                princ.setAcumuladoAnterior(((RegistroMontoDTO)ant.getMontoMes().get(12)).getMonto());
            }
            if (Objects.nonNull(sig)) {
                princ.setAcumuladoPosterior(((RegistroMontoDTO)sig.getMontoMes().get(12)).getMonto());
            }
            princ.setIdBroadview("-");
            princ.setCodigoSAP("-");
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(place, princ);
        } else {
            RegistroRubroDTO emptyValue = new RegistroRubroDTO();
            List<String> meses = this.getFechasAConsultar(fecha);
            emptyValue.setMontoMes(this.obtenMontosMesesVacios(meses));
            emptyValue.setSistema(sistema);
            emptyValue.setCodigoSAP("-");
            emptyValue.setIdBroadview("-");
            emptyValue.setAcumuladoAnterior(Double.valueOf(0.0));
            emptyValue.setAcumuladoPosterior(Double.valueOf(0.0));
            emptyValue.setRemanente(Double.valueOf(0.0));
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(emptyValue);
        }
    }

    private void addMontoEstudioSAP(RegistroRubroDTO princ, Map<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA, int place, Long idEstudio, String fecha, String sistema, Integer month) throws ParseException {
        if (Objects.nonNull(princ)) {
            RegistroRubroDTO ant = this.obtenMontosTotalesPorEstudioSAP(idEstudio, fecha);
            RegistroRubroDTO sig = this.obtenMontosTotalesPorEstudioSAP(idEstudio, fecha);
            princ.setSistema(sistema);
            princ.setAcumuladoAnterior(Double.valueOf(0.0));
            princ.setAcumuladoPosterior(Double.valueOf(0.0));
            princ.setId(Long.valueOf(-1L));
            if (Objects.nonNull(ant)) {
                princ.setAcumuladoAnterior(((RegistroMontoDTO)ant.getMontoMes().get(12)).getMonto());
            }
            if (Objects.nonNull(sig)) {
                princ.setAcumuladoPosterior(((RegistroMontoDTO)sig.getMontoMes().get(12)).getMonto());
            }
            princ.setIdBroadview("-");
            princ.setCodigoSAP("-");
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(place, princ);
        } else {
            RegistroRubroDTO emptyValue = new RegistroRubroDTO();
            List<String> meses = this.getFechasAConsultar(fecha);
            emptyValue.setMontoMes(this.obtenMontosMesesVacios(meses));
            emptyValue.setSistema(sistema);
            emptyValue.setCodigoSAP("-");
            emptyValue.setIdBroadview("-");
            emptyValue.setAcumuladoAnterior(Double.valueOf(0.0));
            emptyValue.setAcumuladoPosterior(Double.valueOf(0.0));
            emptyValue.setRemanente(Double.valueOf(0.0));
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(emptyValue);
        }
    }

    public Map<String, List<RegistroRubroDTO>> obtenListaMontosTotalesContratoPorEstudioDLASAP(Long idEstudio, Long idContrato, String fecha, Integer year, Integer month) throws ParseException {
        RegistroRubroDTO totalesMontosEstudio = this.obtenMontosTotalesPorEstudio(idEstudio, fecha);
        RegistroRubroDTO totalesMontosEstudioSAP = this.obtenMontosTotalesPorEstudioSAP(idEstudio, fecha);
        List remanentes = this.reporteAmortizacionDAO.obtenerRemanente(null, null, month + "/" + year);
        List remanentesSAP = this.reporteAmortizacionDAO.obtenerRemanenteSAP(null, null, month + "/" + year);
        for (RemanenteDTO remanente : remanentesSAP) {
            if (remanente == null || !totalesMontosEstudioSAP.getId().toString().equals(remanente.getDiferenciador())) continue;
            totalesMontosEstudioSAP.setRemanente(Double.valueOf(Double.parseDouble(remanente.getRemanente())));
        }
        for (RemanenteDTO remanente : remanentes) {
            if (remanente == null || !totalesMontosEstudio.getId().toString().equals(remanente.getDiferenciador())) continue;
            totalesMontosEstudio.setRemanente(Double.valueOf(Double.parseDouble(remanente.getRemanente())));
        }
        LinkedHashMap<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA = new LinkedHashMap<String, List<RegistroRubroDTO>>();
        totalesPorContratoSAPDLA.put(idEstudio.toString(), new ArrayList());
        this.addMontoEstudio(totalesMontosEstudio, totalesPorContratoSAPDLA, 0, idEstudio, "01/" + (year - 1), "DDA", month);
        this.addMontoEstudioSAP(totalesMontosEstudioSAP, totalesPorContratoSAPDLA, 0, idEstudio, "01/" + (year + 1), "SAP", month);
        Map<String, List<RegistroRubroDTO>> totalesPorContratoAnioAnterior = null;
        Map<String, List<RegistroRubroDTO>> totalesPorContratoAnioSiguiente = null;
        totalesPorContratoSAPDLA.putAll(this.getListResult(idEstudio, idContrato, fecha, month + "/" + year));
        totalesPorContratoAnioAnterior = this.getListResult(idEstudio, idContrato, "01/" + (year - 1), month + "/" + year);
        totalesPorContratoAnioSiguiente = this.getListResult(idEstudio, idContrato, "01/" + (year + 1), month + "/" + year);
        for (Map.Entry total : totalesPorContratoSAPDLA.entrySet()) {
            if (((List)total.getValue()).size() < 2) {
                RegistroRubroDTO emptyValue = new RegistroRubroDTO();
                List<String> meses = this.getFechasAConsultar(fecha);
                emptyValue.setMontoMes(this.obtenMontosMesesVacios(meses));
                emptyValue.setSistema(((RegistroRubroDTO)((List)total.getValue()).get(0)).getSistema().equals("DDA") ? "SAP" : "DDA");
                emptyValue.setFechainicio(((RegistroRubroDTO)((List)total.getValue()).get(0)).getFechainicio());
                emptyValue.setFechaFin(((RegistroRubroDTO)((List)total.getValue()).get(0)).getFechaFin());
                emptyValue.setCodigoSAP(((RegistroRubroDTO)((List)total.getValue()).get(0)).getCodigoSAP());
                emptyValue.setIdBroadview(((RegistroRubroDTO)((List)total.getValue()).get(0)).getIdBroadview());
                ((List)total.getValue()).add(emptyValue);
            }
            for (int i = 0; ((List)total.getValue()).size() > i; ++i) {
                if (((String)total.getKey()).equals(idEstudio.toString())) continue;
                if (Objects.nonNull(totalesPorContratoAnioAnterior.get(total.getKey())) && totalesPorContratoAnioAnterior.get(total.getKey()).size() > i) {
                    if (Objects.nonNull(totalesPorContratoAnioAnterior.get(total.getKey()))) {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(((RegistroMontoDTO)totalesPorContratoAnioAnterior.get(total.getKey()).get(i).getMontoMes().get(12)).getMonto());
                    } else {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(Double.valueOf(0.0));
                    }
                    if (Objects.nonNull(totalesPorContratoAnioSiguiente.get(total.getKey()))) {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(((RegistroMontoDTO)totalesPorContratoAnioSiguiente.get(total.getKey()).get(i).getMontoMes().get(12)).getMonto());
                        continue;
                    }
                    ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(Double.valueOf(0.0));
                    continue;
                }
                ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(Double.valueOf(0.0));
                ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(Double.valueOf(0.0));
            }
        }
        for (Map.Entry total : totalesPorContratoSAPDLA.entrySet()) {
            for (RegistroMontoDTO mesDDA : ((RegistroRubroDTO)((List)total.getValue()).get(0)).getMontoMes()) {
                for (RegistroMontoDTO mesSAP : ((RegistroRubroDTO)((List)total.getValue()).get(1)).getMontoMes()) {
                    if (mesDDA.getFecha() == null || !mesDDA.getFecha().equals(mesSAP.getFecha())) continue;
                    if (mesDDA.getMonto().equals(mesSAP.getMonto())) {
                        mesDDA.setColor("right");
                        mesSAP.setColor("right");
                        continue;
                    }
                    mesDDA.setColor("danger");
                    mesSAP.setColor("danger");
                }
            }
        }
        return totalesPorContratoSAPDLA;
    }

    public Map<String, List<RegistroRubroDTO>> getListResult(Long idEstudio, Long idContrato, String fecha, String fechaRem) throws ParseException {
        List<RegistroRubroDTO> totalesPorContrato = this.obtenListaMontosTotalesContratoPorEstudio(idEstudio, idContrato, fecha, 11L);
        List<RegistroRubroDTO> totalesPorContratoSAP = this.obtenListaMontosTotalesContratoPorEstudioSAP(idEstudio, idContrato, fecha, 11L);
        List remanentes = this.reporteAmortizacionDAO.obtenerRemanente(idEstudio, null, fechaRem);
        List remanentesSAP = this.reporteAmortizacionDAO.obtenerRemanenteSAP(idEstudio, null, fechaRem);
        LinkedHashMap<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA = new LinkedHashMap<String, List<RegistroRubroDTO>>();
        totalesPorContrato.addAll(totalesPorContratoSAP);
        for (RegistroRubroDTO total : totalesPorContrato) {
            if (!totalesPorContratoSAPDLA.containsKey(total.getDescripcion())) {
                totalesPorContratoSAPDLA.put(total.getDescripcion(), new ArrayList());
            }
            if (total.getSistema().equals("SAP")) {
                for (RemanenteDTO remanente : remanentesSAP) {
                    if (remanente == null || !total.getDescripcion().equals(remanente.getDiferenciador())) continue;
                    total.setRemanente(Double.valueOf(Double.parseDouble(remanente.getRemanente())));
                }
            } else {
                for (RemanenteDTO remanente : remanentes) {
                    if (remanente == null || !total.getDescripcion().equals(remanente.getDiferenciador())) continue;
                    total.setRemanente(Double.valueOf(Double.parseDouble(remanente.getRemanente())));
                }
            }
            ((List)totalesPorContratoSAPDLA.get(total.getDescripcion())).add(total);
        }
        return totalesPorContratoSAPDLA;
    }

    public List<String> getFechasAConsultar(String fechaIni) throws ParseException {
        ArrayList<String> fechas = new ArrayList<String>();
        SimpleDateFormat formato = new SimpleDateFormat("MM/yyyy");
        Date date = formato.parse(fechaIni);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String fecha = formato.format(cal.getTime());
        fechas.add(fecha);
        for (int i = 1; i < 12; ++i) {
            cal.add(2, 1);
            fecha = formato.format(cal.getTime());
            fechas.add(fecha);
        }
        return fechas;
    }

    public List<RegistroMontoDTO> obtenMontosMesesVacios(List<String> meses) throws ParseException {
        ArrayList<RegistroMontoDTO> response = new ArrayList<RegistroMontoDTO>();
        SimpleDateFormat formato = new SimpleDateFormat("MM/yyyy");
        for (String mes : meses) {
            RegistroMontoDTO newItem = new RegistroMontoDTO();
            Date fecha = formato.parse(mes);
            newItem.setFecha(fecha);
            newItem.setMonto(Double.valueOf(0.0));
            response.add(newItem);
        }
        RegistroMontoDTO newItem = new RegistroMontoDTO();
        newItem.setFecha(null);
        newItem.setMonto(Double.valueOf(0.0));
        response.add(newItem);
        return response;
    }

    private void buscaRegistroMontoMes(List<RegistroMontoDTO> montos, RegistroMontoDTO actualizaMonto) throws ParseException {
        Double parcial = 0.0;
        RegistroMontoDTO total = null;
        for (RegistroMontoDTO monto : montos) {
            if (monto == null) continue;
            if (monto.getFecha() != null) {
                if (!monto.getFecha().equals(actualizaMonto.getFecha())) continue;
                parcial = actualizaMonto.getMonto();
                monto.setMonto(parcial);
                continue;
            }
            total = monto;
        }
        if (total != null) {
            total.setMonto(Double.valueOf(ReporteAmortizacionBO.truncateTo(total.getMonto() + parcial, 2)));
        }
    }

    static double truncateTo(double unroundedNumber, int decimalPlaces) {
        int truncatedNumberInt = (int)(unroundedNumber * Math.pow(10.0, decimalPlaces));
        double truncatedNumber = (double)truncatedNumberInt / Math.pow(10.0, decimalPlaces);
        return truncatedNumber;
    }

    public List<RegistroRubroDTO> obtenListaMontoTitulosPorContrato(Long idContrato, String fecha) throws ParseException {
        List montosTitulosContrato = this.reporteAmortizacionDAO.obtenMontosTitulosContrato(idContrato, fecha);
        ArrayList<RegistroRubroDTO> montosTitulos = new ArrayList();
        montosTitulos = this.separaMensualmente(montosTitulosContrato, fecha);
        return montosTitulos;
    }

    private List<RegistroRubroDTO> separaMensualmente(List<RegistroMontoDTO> titulosMontos, String fecha) throws ParseException {
        ArrayList<RegistroRubroDTO> montoTitulos = new ArrayList<RegistroRubroDTO>();
        HashMap<String, List<RegistroMontoDTO>> map = new HashMap<String, List<RegistroMontoDTO>>();
        List<String> meses = this.getFechasAConsultar(fecha);
        for (RegistroMontoDTO item : titulosMontos) {
            String season = Objects.isNull(item.getTemporada()) ? "" : " Season " + StringUtils.leftPad((String)item.getTemporada(), (int)2, (String)"0");
            List<RegistroMontoDTO> list = (List<RegistroMontoDTO>)map.get(item.getDescripcion() + season);
            if (list == null) {
                list = this.obtenMontosMesesVacios(meses);
                map.put(item.getDescripcion() + season, list);
                RegistroRubroDTO montoTituloRegistro = new RegistroRubroDTO();
                montoTituloRegistro.setTemporada(item.getTemporada());
                montoTituloRegistro.setDescripcion(item.getDescripcion() + season);
                montoTituloRegistro.setNombreUnico(item.getDescripcion());
                montoTituloRegistro.setCosto(item.getCosto());
                montoTituloRegistro.setMontoMes(list);
                montoTituloRegistro.setId(item.getIdContrato());
                montoTituloRegistro.setSistema(item.getSistema());
                montoTituloRegistro.setCodigoSAP(item.getIdSap());
                montoTituloRegistro.setIdBroadview(item.getIdBroadView());
                montoTitulos.add(montoTituloRegistro);
                this.logger.debug("id cto:" + item.getId() + " no tit:" + montoTitulos.size());
            }
            this.buscaRegistroMontoMes(list, item);
        }
        return montoTitulos;
    }

    public List<RegistroRubroDTO> obtenListaMontosTotalesContratoPorEstudioSAP(Long idEstudio, Long idContrato, String fecha, Long mesesSearch) throws ParseException {
        ArrayList<RegistroRubroDTO> totalesPorContrato = new ArrayList<RegistroRubroDTO>();
        List montosContrato = this.reporteAmortizacionDAO.obtenMontosTotalesContratoSAP(idEstudio, fecha, mesesSearch);
        HashMap contratosMonto = new HashMap();
        for (RegistroMontoDTO monto : montosContrato) {
            if (Objects.isNull(contratosMonto.get(monto.getIdContrato()))) {
                contratosMonto.put(monto.getIdContrato(), new ArrayList());
            }
            ((List)contratosMonto.get(monto.getIdContrato())).add(monto);
        }
        List<String> meses = this.getFechasAConsultar(fecha);
        for (Map.Entry contrato : contratosMonto.entrySet()) {
            List montos = (List)contrato.getValue();
            List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
            if (montos == null || montos.isEmpty()) continue;
            for (RegistroMontoDTO item : montos) {
                this.buscaRegistroMontoMes(list, item);
            }
            if (idContrato != null && idContrato >= 0L && !idContrato.equals(((RegistroMontoDTO)montos.get(0)).getIdContrato())) continue;
            RegistroRubroDTO totalContrato = new RegistroRubroDTO();
            totalContrato.setId(((RegistroMontoDTO)montos.get(0)).getIdContrato());
            totalContrato.setDescripcion(((RegistroMontoDTO)montos.get(0)).getNumContrato());
            totalContrato.setCosto(((RegistroMontoDTO)montos.get(0)).getCosto());
            totalContrato.setMontoMes(list);
            totalContrato.setFechaFin(((RegistroMontoDTO)montos.get(0)).getFechaFin());
            totalContrato.setFechainicio(((RegistroMontoDTO)montos.get(0)).getFechaInicio());
            totalContrato.setCodigoSAP("-");
            totalContrato.setSistema("SAP");
            totalContrato.setIdBroadview("-");
            totalContrato.setRemanente(new Double(0.0));
            totalesPorContrato.add(totalContrato);
        }
        return totalesPorContrato;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudioSAP(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudioSAP(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        totalesEstudio.setRemanente(new Double(0.0));
        return totalesEstudio;
    }

    public List<RegistroRubroDTO> obtenListaMontoTitulosPorContratoSAP(Long idContrato, String fecha) throws ParseException {
        List montosTitulosContrato = this.reporteAmortizacionDAO.obtenMontosTitulosContratoSAP(idContrato, fecha);
        ArrayList<RegistroRubroDTO> montosTitulos = new ArrayList();
        montosTitulos = this.separaMensualmente(montosTitulosContrato, fecha);
        return montosTitulos;
    }
}

