/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.grupoestudio.bos;

import com.mx.dla.dda.admin.catalogos.grupoestudio.daos.GrupoEstudioDAO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.dtos.GrupoEstudioDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrupoEstudioBO
extends BaseBO {
    @Autowired
    private GrupoEstudioDAO grupoEstudioDAO;

    public List<GrupoEstudioDTO> obtenerGrupoEstudio(Long idEstudio) {
        List grupos = null;
        try {
            grupos = this.grupoEstudioDAO.obtenerGrupoEstudio();
            GrupoEstudioDTO grupo = null;
            if (idEstudio != null) {
                grupo = this.grupoEstudioDAO.obtenerGrupoEstudioInactivoByEstudio(idEstudio);
            }
            if (grupo != null) {
                grupos.add(grupo);
            }
            Collections.sort(grupos, new Comparator<GrupoEstudioDTO>(){

                @Override
                public int compare(GrupoEstudioDTO o1, GrupoEstudioDTO o2) {
                    return o1.getDescripcionGrupo().compareTo(o2.getDescripcionGrupo());
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Error: [{}]", (Throwable)ex);
        }
        return grupos;
    }

    public GrupoEstudioDTO obtenerGrupo(Long idGrupo) {
        GrupoEstudioDTO grupo = null;
        try {
            grupo = this.grupoEstudioDAO.obtenerGrupo(idGrupo);
        }
        catch (Exception ex) {
            this.logger.error("Error: [{}]", (Throwable)ex);
        }
        return grupo;
    }

    public void registraActualizaGrupo(String operacion, Long idGrupo, String descripcion, Integer estatus, Integer orden, Integer colapsa) {
        GrupoEstudioDTO grupo = new GrupoEstudioDTO();
        grupo.setIdGrupo(idGrupo);
        grupo.setDescripcionGrupo(descripcion);
        grupo.setEstatus(estatus);
        grupo.setOrden(orden);
        grupo.setColapsa(colapsa);
        try {
            if (operacion.equals("Actualiza")) {
                this.grupoEstudioDAO.actualizaGrupoEstudio(grupo);
            } else {
                this.grupoEstudioDAO.registrarGrupoEstudio(grupo);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error: [{}]", (Throwable)ex);
        }
    }
}

