/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.generales.bos;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.IndicadorDTO;
import com.mx.dla.dda.catalogos.dtos.RegistroCatalogoDTO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.daos.PoblarGeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;
import com.mx.dla.dda.contrato.generales.dtos.AreaAutorizadorDTO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.generales.dtos.BotonDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.NumeroTitulosTransDTO;
import com.mx.dla.dda.contrato.generales.enums.CatalogoTipo;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PoblarGeneralesBO
extends BaseBO {
    @Autowired
    private PoblarGeneralesDAO poblarGeneralesDAO;
    @Autowired
    private GeneralesDAO generalesDAO;

    public Long toLongTipoContrato(Object tipoContrato) {
        Long tipoContratoL = null;
        String tipoContratoS = "";
        if (tipoContrato != null) {
            tipoContratoS = tipoContrato.toString();
            tipoContratoL = Long.parseLong(tipoContratoS);
        }
        return tipoContratoL;
    }

    public List<EstudioDTO> obtenListaEstudiosAddons() {
        List estudios = null;
        try {
            estudios = this.poblarGeneralesDAO.obtenerEstudiosAddons();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estudios;
    }

    public List<EstudioDTO> obtenListaEstudios() {
        List estudios = null;
        try {
            estudios = this.poblarGeneralesDAO.obtenerEstudios();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estudios;
    }

    public List<? extends RegistroCatalogoDTO> obtenListaComponentes(CatalogoTipo tipo, Long tipoContrato) {
        List componentes = null;
        if (tipo.equals((Object)CatalogoTipo.CATEGORIA)) {
            componentes = this.poblarGeneralesDAO.obtenerCategorias();
        } else if (tipo.equals((Object)CatalogoTipo.SERVICIO)) {
            componentes = this.poblarGeneralesDAO.obtenerServiciosPorTipo(tipoContrato);
        } else if (tipo.equals((Object)CatalogoTipo.TERRITORIO)) {
            componentes = this.poblarGeneralesDAO.obtenerTerritorios();
        } else if (tipo.equals((Object)CatalogoTipo.MEDIO)) {
            componentes = this.poblarGeneralesDAO.obtenerMediosEntrega();
        } else if (tipo.equals((Object)CatalogoTipo.FILIAL)) {
            componentes = this.poblarGeneralesDAO.obtenerFiliales();
        } else if (tipo.equals((Object)CatalogoTipo.TYPE)) {
            componentes = this.poblarGeneralesDAO.obtenerTypesPorTipo(tipoContrato);
        }
        return componentes;
    }

    public List<? extends RegistroCatalogoDTO> obtenerListaComponentesActuales(Long idContrato, CatalogoTipo tipo) {
        List componentes = null;
        if (tipo.equals((Object)CatalogoTipo.CATEGORIA)) {
            componentes = this.poblarGeneralesDAO.obtenerCategoriasActuales(idContrato);
        } else if (tipo.equals((Object)CatalogoTipo.SERVICIO)) {
            componentes = this.poblarGeneralesDAO.obtenerServiciosActuales(idContrato);
        } else if (tipo.equals((Object)CatalogoTipo.TERRITORIO)) {
            componentes = this.poblarGeneralesDAO.obtenerTerritoriosActuales(idContrato);
        } else if (tipo.equals((Object)CatalogoTipo.MEDIO)) {
            componentes = this.poblarGeneralesDAO.obtenerMediosEntregaActuales(idContrato);
        } else if (tipo.equals((Object)CatalogoTipo.FILIAL)) {
            componentes = this.poblarGeneralesDAO.obtenerFilialesActuales(idContrato);
        } else if (tipo.equals((Object)CatalogoTipo.TYPE)) {
            componentes = this.poblarGeneralesDAO.obtenerTypesActuales(idContrato);
        }
        return componentes;
    }

    public Long establecerEstatusInicial() {
        return Estatus.Sin.getValor();
    }

    public String obtenDescripcionEstatus(Long idEstatus) {
        String descripcion = null;
        try {
            descripcion = this.poblarGeneralesDAO.obtenerDescripcionEstatus(idEstatus);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return descripcion;
    }

    public List<BotonDTO> obtenerBotones(Long idEstatus) {
        List botones = null;
        try {
            botones = this.poblarGeneralesDAO.obtenerBotones(idEstatus);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return botones;
    }

    public Long establecerMovimientoInicial() {
        return Movimiento.Original.getValor();
    }

    public String obtenerDescripcionMovimiento(Long idMovimiento) {
        String descripcion = null;
        try {
            descripcion = this.poblarGeneralesDAO.obtenerDescripcionMovimiento(idMovimiento);
        }
        catch (Exception ex) {
            this.logger.info("", (Throwable)ex);
        }
        return descripcion;
    }

    public List<EstudioDTO> obtenerEstudioActual(Long idContrato) {
        List estudio = null;
        try {
            estudio = this.poblarGeneralesDAO.obtenerEstudioActual(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estudio;
    }

    public Long obtenEstudioActualV(Long idContrato) {
        Long idEstudio = null;
        for (EstudioDTO estudioTemp : this.obtenerEstudioActual(idContrato)) {
            idEstudio = estudioTemp.getIdEstudio();
        }
        return idEstudio;
    }

    public String formateaFecha(Date fecha) {
        String respuesta = null;
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("MM/dd/yyyy");
        if (fecha != null) {
            respuesta = formatoDeFecha.format(fecha);
        }
        return respuesta;
    }

    public Date obtenerFechaMinContratoTitulo(Long idContrato) {
        Date fechaMin = null;
        try {
            fechaMin = this.poblarGeneralesDAO.obtenerFechaMinContratoTitulo(idContrato);
        }
        catch (Exception e) {
            this.logger.error("Error : ", (Throwable)e);
        }
        return fechaMin;
    }

    public Date obtnerFechaMaxContratoTitulo(Long idContrato) {
        Date fechaMax = null;
        try {
            fechaMax = this.poblarGeneralesDAO.obtenerFechaMaxContratoTitulo(idContrato);
        }
        catch (Exception e) {
            this.logger.error("Error : ", (Throwable)e);
        }
        return fechaMax;
    }

    public List<? extends RegistroCatalogoDTO> filtraRegistrosCatalogo(List<? extends RegistroCatalogoDTO> todos, List<? extends RegistroCatalogoDTO> seleccionados) {
        HashMap<Integer, String> hashSeleccionados = new HashMap<Integer, String>();
        ArrayList<RegistroCatalogoDTO> noSeleccionados = new ArrayList<RegistroCatalogoDTO>();
        for (RegistroCatalogoDTO registroCatalogoDTO : seleccionados) {
            hashSeleccionados.put(registroCatalogoDTO.getId(), registroCatalogoDTO.getDescripcion());
        }
        for (RegistroCatalogoDTO registroCatalogoDTO : todos) {
            String descripcion = (String)hashSeleccionados.get(registroCatalogoDTO.getId());
            if (descripcion != null) continue;
            noSeleccionados.add(registroCatalogoDTO);
        }
        return noSeleccionados;
    }

    public List<AreaAutorizadorDTO> obtenAreaAutorizador(Long idContrato) {
        List listaAreaAutorizador = null;
        try {
            listaAreaAutorizador = this.poblarGeneralesDAO.obtenerAreaAutorizador(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return listaAreaAutorizador;
    }

    public List<AreaAutorizadorDTO> habilitaSiguienteAutorizacion(List<AreaAutorizadorDTO> areaAutorizador, String expediente) {
        int i;
        AreaDTO infoArea = this.generalesDAO.obtenerAreaPorExpediente(expediente);
        for (i = 0; i < areaAutorizador.size() && areaAutorizador.get(i).getExpediente() != null; ++i) {
        }
        if (i < areaAutorizador.size() && areaAutorizador.get(i).getDescripcionArea().equals(infoArea.getDescripcionArea())) {
            areaAutorizador.get(i).setSeHabilita(Integer.valueOf(1));
        }
        return areaAutorizador;
    }

    public Integer obtenerOrdenWF(List<AreaAutorizadorDTO> areaAutorizador) {
        Integer resp = 0;
        for (AreaAutorizadorDTO aa : areaAutorizador) {
            if (aa.getExpediente() != null) continue;
            resp = aa.getOrden();
            break;
        }
        return resp;
    }

    public List<EstudioDTO> obtenerEstudioOficial() {
        List estudiosOficiales = null;
        try {
            estudiosOficiales = this.poblarGeneralesDAO.obtenerEstudioOficial();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estudiosOficiales;
    }

    public boolean hayContratosConVirtual(Long idEstudio, Long idContrato) {
        List contratosConVirtual = null;
        try {
            contratosConVirtual = this.poblarGeneralesDAO.obtenContratoConVirtual(idEstudio, idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return contratosConVirtual.size() != 0;
    }

    public List<ApartadoDTO> obtenerApartados(Long idEstudio, Long idApartado) {
        List apartados = null;
        ApartadoDTO aux = new ApartadoDTO();
        try {
            apartados = this.poblarGeneralesDAO.obtenerApartados(idEstudio);
            if (idApartado != null) {
                for (int i = 0; i < apartados.size(); ++i) {
                    if (((ApartadoDTO)apartados.get(i)).getIdApartado() != idApartado) continue;
                    aux = (ApartadoDTO)apartados.get(i);
                    apartados.remove(i);
                    apartados.add(0, aux);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return apartados;
    }

    public FechasDTO obtenFechasContrato(Long idContrato) {
        FechasDTO fechas = null;
        try {
            fechas = this.poblarGeneralesDAO.obtenFechasContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return fechas;
    }

    public List<Long> validaIdsCatalogo(List<Long> idsCatalogo, Long idContrato, String tipo) {
        ArrayList<Long> noQuitar = new ArrayList<Long>();
        Integer noVeces = 0;
        try {
            for (Long n : idsCatalogo) {
                noVeces = tipo.equals("categorias") ? this.poblarGeneralesDAO.obtenNoCategoriaEnContratoTitulo(n, idContrato) : this.poblarGeneralesDAO.obtenNoServiciosEnContratoServicio(n, idContrato);
                if (noVeces <= 0) continue;
                noQuitar.add(n);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return noQuitar;
    }

    public String tipoOperacionPorNumeroContrato(String numeroContrato) {
        String tipo = "";
        char c = numeroContrato.charAt(numeroContrato.length() - 1);
        switch (c) {
            case 'O': {
                tipo = Movimiento.Original.getDescripcion();
                break;
            }
            case 'A': {
                tipo = Movimiento.Adendum.getDescripcion();
                break;
            }
            case 'E': {
                tipo = Movimiento.Enmienda.getDescripcion();
                break;
            }
            case 'C': {
                tipo = Movimiento.Enmienda.getDescripcion();
                break;
            }
            case 'V': {
                tipo = Movimiento.Virtual.getDescripcion();
            }
        }
        return tipo;
    }

    public String obtenerDescripcionEstudio(Long idContrato) {
        String descripcionEstudio = "";
        List<EstudioDTO> estudios = this.obtenerEstudioActual(idContrato);
        descripcionEstudio = estudios.get(0).getDescripcionEstudio();
        return descripcionEstudio;
    }

    public List<IndicadorDTO> obtenerIndicadores() {
        List indicadores = null;
        try {
            indicadores = this.poblarGeneralesDAO.obtenerIndicadores();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return indicadores;
    }

    public List<IndicadorDTO> obtenerIndicadoresConActual(String indicadorActual) {
        List<IndicadorDTO> indicadores = null;
        indicadores = this.obtenerIndicadores();
        if (!indicadores.isEmpty() && indicadorActual != null) {
            IndicadorDTO aux = new IndicadorDTO();
            int position = 0;
            for (int i = 0; i < indicadores.size(); ++i) {
                this.logger.debug("ac : [{}]  rec : [{}]", (Object)indicadorActual, (Object)indicadores.get(i).getClaveIva());
                if (!indicadores.get(i).getClaveIva().equals(indicadorActual)) continue;
                aux = indicadores.get(i);
                position = i;
            }
            indicadores.remove(position);
            indicadores.add(0, aux);
        }
        return indicadores;
    }

    public Integer obtenerNumeroTitulosEnContratoSL(Long idContrato) {
        Integer numeroTitulos = 0;
        try {
            numeroTitulos = this.poblarGeneralesDAO.numeroTitulosEnContratoTL(idContrato);
            if (numeroTitulos == null) {
                numeroTitulos = 0;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return numeroTitulos;
    }

    public NumeroTitulosTransDTO obtenerNumeroTitulosEnContratoTrans(Long idContrato) {
        NumeroTitulosTransDTO numeroTitulos = null;
        try {
            numeroTitulos = this.poblarGeneralesDAO.numeroTitulosEnContratoTrans(idContrato);
            if (numeroTitulos == null) {
                numeroTitulos = new NumeroTitulosTransDTO(idContrato, Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return numeroTitulos;
    }
}

