/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.pago.bos;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.reporte.pago.daos.ReportePagoAlternoDAO;
import com.mx.dla.dda.reporte.pago.daos.ReportePagoDAO;
import com.mx.dla.dda.reporte.pago.dtos.DetalleContratoDTO;
import com.mx.dla.dda.reporte.pago.dtos.DetalleViewDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoBaseDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoViewDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteRowDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportePagoBO
extends BaseBO {
    @Autowired
    private ReportePagoDAO reportePagoDAO;
    @Autowired
    private ReportePagoAlternoDAO reportePagoAlterno;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;

    public void obtenInfoReporte() {
        try {
            List infos = this.reportePagoDAO.obtenerReportePagoTitulos(Long.valueOf(24L), new Date(), new Date());
            for (ReportePagoBaseDTO info : infos) {
                this.logger.debug("[{}]", (Object)info);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error [{}] : ", (Throwable)ex);
            this.logger.debug("Error [{}] : ", (Throwable)ex);
        }
    }

    public void obtenInfoReporteMapeo(Long idContratro, Date fI, Date fF, Long idEstudio) {
        try {
            String[] llaves = this.obtenLlaves(fI, fF);
            List<ReportePagoDTO> infos = this.obtenInfoReportePago(idContratro, fI, fF, llaves, idEstudio);
            this.logger.debug("-----------------------------------------------------------------");
            for (ReportePagoDTO info : infos) {
                this.logger.debug("[{}] -- [{}] -- total: " + info.getTotal(), (Object)info.getIdContrato(), (Object)info.getNumeroContrato());
                for (ReportePagoViewDTO rp : info.getDetalleTitulos()) {
                    this.logger.debug("[{}]  -- [{}]", (Object)rp.getIdTituloCntorig(), (Object)rp.getNombreEstandar());
                    this.logger.debug("[{}]", (Object)rp.getDetalleCompleto());
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error [{}] : ", (Throwable)ex);
            this.logger.debug("Error [{}] : ", (Throwable)ex);
        }
    }

    public String[] obtenLlaves(Date fechaInicio, Date fechaFin) {
        Calendar cI = Calendar.getInstance();
        Calendar cF = Calendar.getInstance();
        cI.setTime(new Date());
        cF.setTime(new Date());
        cI.set(2, cI.get(2) - 6);
        cF.set(2, cF.get(2) + 2);
        fechaInicio = cI.getTime();
        fechaFin = cF.getTime();
        long diferenciaTiempo = fechaFin.getTime() - fechaInicio.getTime();
        long diferenciaDias = diferenciaTiempo / 86400000L;
        Double meses = Math.floor(diferenciaDias / 30L);
        String[] llaves = new String[meses.intValue()];
        Calendar cal = Calendar.getInstance();
        cal.setTime(fechaInicio);
        int mesInicio = cal.get(2) + 1;
        int annioInicio = cal.get(1);
        this.logger.debug("meses : [{}]", (Object)meses);
        for (int i = 0; i < llaves.length; ++i) {
            llaves[i] = mesInicio++ + " - " + annioInicio;
            this.logger.debug("llave : [{}]", (Object)llaves[i]);
            if (mesInicio <= 12) continue;
            mesInicio = 1;
            ++annioInicio;
        }
        return llaves;
    }

    public List<ReportePagoDTO> obtenInfoReportePago(Long idContrato, Date fechaInicio, Date fechaFin, String[] llaves, Long idEstudio) {
        Calendar cI = Calendar.getInstance();
        Calendar cF = Calendar.getInstance();
        cI.setTime(new Date());
        cF.setTime(new Date());
        cI.set(2, cI.get(2) - 6);
        cF.set(2, cF.get(2) + 2);
        fechaInicio = cI.getTime();
        fechaFin = cF.getTime();
        ArrayList<ReportePagoDTO> infoCompleta = new ArrayList<ReportePagoDTO>();
        try {
            List infoReporte = this.reportePagoDAO.obtenerMapeoReportePagoTitulos(idContrato, fechaInicio, fechaFin, idEstudio);
            boolean esPrimero = true;
            Double total = 0.0;
            for (ReportePagoDTO info : infoReporte) {
                this.logger.debug("[{}] -- [{}]", (Object)info.getIdContrato(), (Object)info.getNumeroContrato());
                if (esPrimero) {
                    total = ((DetalleViewDTO)((ReportePagoViewDTO)info.getDetalleTitulos().get(0)).getDetalle().get(0)).getMonto();
                    esPrimero = false;
                    continue;
                }
                info.setTotal(total);
                for (ReportePagoViewDTO rpv : info.getDetalleTitulos()) {
                    this.logger.debug("[{}] -- [{}]", (Object)rpv.getIdTituloCntorig(), (Object)rpv.getNombreEstandar());
                    rpv.setDetalleCompleto(this.obtenDetalleCompleto(rpv.getDetalle(), llaves));
                    rpv.setDetalle(null);
                }
                infoCompleta.add(info);
                esPrimero = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error [{}] : ", (Throwable)ex);
            this.logger.debug("Error [{}] : ", (Throwable)ex);
        }
        return infoCompleta;
    }

    public Map<String, Double> obtenDetalleCompleto(List<DetalleViewDTO> detalles, String[] llaves) {
        Map<String, Double> detalleCompleto = this.contruyeRenglonMeses(llaves);
        this.logger.debug("[{}] -- [{}]", (Object)llaves, detalleCompleto);
        for (DetalleViewDTO detalle : detalles) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(detalle.getMesPago());
            detalleCompleto.put(cal.get(2) + 1 + " - " + cal.get(1), detalle.getMonto());
        }
        return detalleCompleto;
    }

    public Map<String, Double> contruyeRenglonMeses(String[] llaves) {
        HashMap<String, Double> renglon = new HashMap<String, Double>();
        for (String llave : llaves) {
            renglon.put(llave, 0.0);
        }
        return renglon;
    }

    public List<DetalleContratoDTO> obtenerDetalleContratoPorEstudio(Long idEstudio) {
        List detalleContratos = null;
        try {
            detalleContratos = this.reportePagoDAO.obtenerDetalleContratoPorEstudioSAP(idEstudio);
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
        }
        return detalleContratos;
    }

    public void pruebaDAO() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("fechaInicio", "'01-12-2015'");
        parametros.put("fechaFin", "'01-12-2016'");
        parametros.put("M1", "'12-2015'");
        parametros.put("M2", "'01-2016'");
        parametros.put("M3", "'02-2016'");
        parametros.put("M4", "'03-2016'");
        parametros.put("M5", "'04-2016'");
        parametros.put("M6", "'05-2016'");
        parametros.put("M7", "'06-2016'");
        parametros.put("M8", "'07-2016'");
        parametros.put("M9", "'08-2016'");
        parametros.put("M10", "'09-2016'");
        parametros.put("M11", "'10-2016'");
        parametros.put("M12", "'11-2016'");
        parametros.put("M13", "'12-2016'");
        List listaReporteRow = null;
        try {
            listaReporteRow = this.reportePagoAlterno.obtenerReporteRows(Long.valueOf(20L), Long.valueOf(108L), parametros);
            if (listaReporteRow != null) {
                for (ReporteRowDTO detalle : listaReporteRow) {
                    this.logger.debug("[{}]", (Object)detalle);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] obtenerLlaves() {
        String[] llaves = new String[]{"Concepto", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13", "Total"};
        return llaves;
    }

    public String[] obtenerEncabezado(Date fechaInicio) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fechaInicio);
        int mes = calendar.get(2) + 1;
        int annio = calendar.get(1);
        String[] encabezado = this.obtenerLlaves();
        String[] meses = new String[]{"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"};
        for (int i = 1; i < encabezado.length - 1; ++i) {
            encabezado[i] = meses[mes - 1] + " - " + annio;
            if (mes == 12) {
                mes = 1;
                ++annio;
                continue;
            }
            ++mes;
        }
        return encabezado;
    }

    public Map<String, String> obtenerParametrosQuery(Date fechaInicio) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fechaInicio);
        String cad = "";
        int mes = calendar.get(2) + 1;
        int annio = calendar.get(1);
        cad = mes < 10 ? "0" : "";
        String fI = "'01-" + cad + mes + "-" + annio + "'";
        String fF = "'01-" + cad + mes + "-" + (annio + 1) + "'";
        String[] llaves = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13"};
        String[] valores = new String[llaves.length];
        parametros.put("fechaInicio", fI);
        parametros.put("fechaFin", fF);
        for (int i = 0; i < llaves.length; ++i) {
            cad = mes < 10 ? "0" : "";
            valores[i] = "'" + cad + mes + "-" + annio + "'";
            parametros.put(llaves[i], "'" + cad + mes + "-" + annio + "'");
            if (mes == 12) {
                mes = 1;
                ++annio;
                continue;
            }
            ++mes;
        }
        this.logger.debug("parametros : [{}]", parametros);
        return parametros;
    }

    public List<ReporteRowDTO> obteneReporte(Date fechaInicio, Long idContrato, Long idEstudio) {
        List reporte = null;
        Map<String, String> parametros = this.obtenerParametrosQuery(fechaInicio);
        try {
            reporte = this.reportePagoAlterno.obtenerReporteRows(idContrato, idEstudio, parametros);
            this.logger.debug("Regresando reporte");
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
            this.logger.debug("No regresa reporte reporte");
        }
        return reporte;
    }

    public InputStream obtenerReporteEnExcel(Date fechaInicio, Long idContrato, Long idEstudio) {
        byte[] info = null;
        ByteArrayInputStream reporte = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("reportePago");
        this.logger.info("{}", (Object)mapper);
        String[] encabezado = this.obtenerEncabezado(fechaInicio);
        Map<String, String> parametros = null;
        List reporteInfo = null;
        try {
            for (int i = 0; i < encabezado.length; ++i) {
                String s = String.format(((ExcelRule)mapper.getRules().get(i)).getHeader(), encabezado[i]);
                ((ExcelRule)mapper.getRules().get(i)).setHeader(s);
            }
            parametros = this.obtenerParametrosQuery(fechaInicio);
            reporteInfo = this.reportePagoAlterno.obtenerReporteRows(idContrato, idEstudio, parametros);
            this.logger.info("{}", (Object)mapper);
            info = this.excelMapperTransform.transformObjectToExcel(reporteInfo, mapper, ReporteRowDTO.class);
            reporte = new ByteArrayInputStream(info);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return reporte;
    }

    public void consultaListaMapa() {
        this.logger.debug("Inicia");
        try {
            List listaMapas = this.reportePagoAlterno.obtenerListaMapas();
            this.logger.debug("listaMapas : [{}]", (Object)listaMapas);
        }
        catch (Exception ex) {
            this.logger.debug("Exception : [{}]", (Throwable)ex);
        }
        this.logger.debug("Finaliza");
    }
}

