package com.mx.dla.dda.contrato.license.terminos.actions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.license.exceptions.dtos.LicenseException;
import com.mx.dla.dda.contrato.license.terminos.bos.TerminosFeeBO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoDTO;
import com.opensymphony.xwork2.Action;

@Service
public class ContratoTerminosLicenseAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	@Autowired
	private TerminosFeeBO terminosBO; 
		
	private TerminoDTO          termino;
	private ContratoConsultaDTO contrato;
	private String              mensaje;
	
	public String index(){
		return Action.SUCCESS;
	}
	
	public String obtenerTermino(){		
		try
		{
			Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);		
			termino  = terminosBO.getTerminos(idC);
			contrato = terminosBO.getInformacionContrato(idC, termino);			
		}
		catch(LicenseException  le)
		{
		    this.mensaje = le.getMessage(); 
		}
		
		return "regresar";
	}
	
	public String guardarTermino(){
		try
		{
			Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);						
			terminosBO.guardarTerminos(this.mensaje, idC);		
			termino  = terminosBO.getTerminos(idC);
			contrato = terminosBO.getInformacionContrato(idC, termino);
			this.mensaje = null;
		}catch(LicenseException  le)
		{
		    this.mensaje = le.getMessage(); 
		}
		return "regresar";
	}	
	
	public TerminoDTO getTermino() { return termino; }
	public ContratoConsultaDTO getContrato() { return contrato; }
	public String getMensaje() {return mensaje; }
	
	public void setTermino(TerminoDTO termino) { this.termino = termino; }		
	public void setContrato(ContratoConsultaDTO contrato) { this.contrato = contrato; }		
	public void setMensaje(String mensaje) { this.mensaje = mensaje; }		
}