package com.mx.dla.dda.contrato.listado.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.dtos.DocumentoDTO;
import com.mx.dla.dda.contrato.listado.bos.ListadoContratoBO;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;

public class DescargarArchivoAction extends BaseAction{
		
	private String path;		
	private InputStream documento = null;	
	private long contentLength;
	private String contentName;
	private String contentType;
	private Long   idArchivo;
	private String  msgError;	
	
	@Autowired
	private ListadoContratoBO listadoContratoBO;
	
	public String descargar()
	{
		byte[] result = null;
		
		try
		{
			DocumentoDTO documento = listadoContratoBO.getDocumento(idArchivo);
			
			this.path        = documento.getRutaServidor();
			this.contentName = documento.getNombre();
		
			File file = new File(path+idArchivo);
				
			result = IOUtils.toByteArray(new FileInputStream(file));
						
			FileUtils.writeByteArrayToFile(file, result);
						
			this.contentType = ContentType.getType(FilenameUtils.getExtension(path));
			
			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(result.length);
			response.setContentType(this.contentType);
			
			//Reemplaza los caracteres NO ASCII y la "," del nombre del archivo
			String fileName = contentName.replaceAll("[^\\x00-\\x7F]", "_").replaceAll(",", "_");
			
			logger.info("descar:"+path+fileName);
						
			response.setHeader("Content-Disposition", "attachment; filename="+fileName);
				
			
			ServletOutputStream out = response.getOutputStream();
			out.write(result);
			out.flush();
		
		}catch (Exception ex){
		       this.msgError = "Carga Suscriptores. Error-101";
		       logger.error("Error en [" + this.getClass() +"]", ex);		       
		}
		
		return null;
	}

	public String verificar()
	{
		byte[] result = null;		
		try
		{
			logger.debug("verificar archivo");
			DocumentoDTO documento = listadoContratoBO.getDocumento(idArchivo);
			
			this.path        = documento.getRutaServidor();
			this.contentName = documento.getNombre();
		
			File file = new File(path+idArchivo);							
			result    = IOUtils.toByteArray(new FileInputStream(file));						
			FileUtils.writeByteArrayToFile(file, result);									
		
		}catch (Exception ex){
		       this.msgError = "Carga Suscriptores. Error-101";
		       logger.error("Error en [" + this.getClass() +"]", ex);		       
		}
		
		return Action.SUCCESS;
	}
		
	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public InputStream getDocumento() {
		return documento;
	}

	public void setDocumento(InputStream documento) {
		this.documento = documento;
	}

	public long getContentLength() 
	{
		return this.contentLength;
	}

	public String getContentName() 
	{
		return this.contentName;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public Long getIdArchivo() {
		return idArchivo;
	}

	public void setIdArchivo(Long idArchivo) {
		this.idArchivo = idArchivo;
	}

	public void setContentLength(long contentLength) {
		this.contentLength = contentLength;
	}

	public void setContentName(String contentName) {
		this.contentName = contentName;
	}

	public String getMsgError() {
		return msgError;
	}		
}
