function TituloService() {
	this.titulo = "";
}

TituloService.prototype.guardarTitulos = function(tipoCambio,item,indexes,func) {
	
	var pagoCateg;
	var pagodesc;
	
	if(typeof item.pagoCateg != 'undefined') 
	{
		pagoCateg = item.pagoCateg.value;
		pagodesc  = item.pagoCateg.desc;
	}
		
	var categoria   = (typeof item.categoriaTit != 'undefined') ?  item.categoriaTit.value: "";
	var flagCalculo = (typeof item.flgcalculoPrecio != 'undefined') && item.flgcalculoPrecio == true ? 1 : 0;
	
	this.ajax("guardarTituloGrid", { 
		"titulo.idBv"              : item.idBv ,
		"titulo.idLista"           : item.idLista ,
		"titulo.idTituloCnt"       : item.idTituloCnt,
		"titulo.descTitulo"        : item.descTitulo,
		"titulo.fechaInicio"       : item.fechaInicio,
		"titulo.fechaFin"          : item.fechaFin,
		"titulo.pagoCateg.value"   : pagoCateg,
		"titulo.pagoCateg.desc"    : pagodesc,
		"titulo.briefcase"         : item.briefcase,
		"titulo.threed"            : item.threed,
		"idsTipoCambio"            : indexes,
		"tipoCambio"               : tipoCambio,
		"titulo.nombreUnico"       : item.nombreUnico,
		"titulo.episodio"          : item.episodio,
		"titulo.categoriaTit.value": categoria,
		"titulo.precioAnual"       : item.precioAnual,
		"titulo.amortizacion"      : item.amortizacion,
		"titulo.temporada"         : item.temporada,
		"titulo.pjeExclusivo"      : item.pjeExclusivo,
		"titulo.mesesExclusivo"    : item.mesesExclusivo,
		"titulo.flgcalculoPrecio"  : flagCalculo,
		"titulo.anioContrato"      : item.anioContrato,
		"titulo.fechaContabilizacion" 		: item.fechaContabilizacion
		
	} , function (ret)
						{							
							func(ret);
						}, function (ret)
						{					
							if(ret.tipoCambio != "" && ret.error)
								showMessage(ret.error);
							
							$("#errPerCat").text(ret.error).show();							
						});
};

TituloService.prototype.guardarSeriesAuto = function(item,func) {

	var pagoCateg;
	var pagodesc;
	
	if(typeof item.pagoCateg != 'undefined') 
	{
		pagoCateg = item.pagoCateg.value;
		pagodesc  = item.pagoCateg.desc;
	}
		
	var categoria   = (typeof item.categoriaTit != 'undefined') ?  item.categoriaTit.value: "";
	var flagCalculo = (typeof item.flgcalculoPrecio != 'undefined') && item.flgcalculoPrecio == true ? 1 : 0;
	
	this.ajax("seriesTituloGrid", { 
		"titulo.idBv"              : item.idBv ,
		"titulo.idLista"           : item.idLista ,
		"titulo.idTituloCnt"       : item.idTituloCnt,
		"titulo.descTitulo"        : item.descTitulo,
		"titulo.fechaInicio"       : item.fechaInicio,
		"titulo.fechaFin"          : item.fechaFin,
		"titulo.pagoCateg.value"   : pagoCateg,
		"titulo.pagoCateg.desc"    : pagodesc,
		"titulo.briefcase"         : item.briefcase,
		"titulo.threed"            : item.threed,		
		"titulo.nombreUnico"       : item.nombreUnico,
		"titulo.episodio"          : item.episodio,
		"titulo.categoriaTit.value": categoria,
		"titulo.precioAnual"       : item.precioAnual,
		"titulo.amortizacion"      : item.amortizacion,
		"titulo.temporada"         : item.temporada,
		"titulo.pjeExclusivo"      : item.pjeExclusivo,
		"titulo.mesesExclusivo"    : item.mesesExclusivo,
		"titulo.flgcalculoPrecio"  : flagCalculo,
		"titulo.anioContrato"      : item.anioContrato
		
	} , function (ret)
						{							
							func(ret);
						}, function (ret)
						{							
							$("#errPerCat").text(ret.error).show();
						});

};

TituloService.prototype.eliminarTitulos = function(item,func) {
	
	this.ajax("bajaTituloGrid", { 
		"titulo.idLista" 		: item.idLista ,
		"titulo.idTituloCnt" 	: item.idTituloCnt,
		"titulo.bajaPerdida" 	: item.bajaPerdida,
		"titulo.fechaFin" 		: item.fechaFin,
		"titulo.fechaContabilizacion" 		: item.fechaContabilizacion
		
	} , function (ret)
						{
							func(ret);
						}, function (ret)
						{
							showError(ret.error);
						});
};

TituloService.prototype.guardarCambios = function(item ) {
	this.ajax("guardarCambiosPermanente", { 
		"titulo.idLista" 		: $("#idLista").val() 
	} , function (ret)
						{
							console.log(ret)
							showMessage("Los datos se guardaron de manera correcta");
						}, function (ret)
						{
							showError(ret.error);
						});
};

TituloService.prototype.descargarArchivo = function() {
	var url = contextPath +'/contrato/titulos/descarArchivoTituloDescarga.action?titulo.idLista=' + $("#idLista").val();
    window.open(url);
};

TituloService.prototype.descargarArchivoErrores = function() {
	var _url = contextPath +'/contrato/titulos/descarArchivoErroresTituloDescarga.action';
	
	$.ajax({
		url : _url,
		type : 'post',
		async : false,
		dataType  : 'html',
		success : function(ret) {
			window.open(_url);
		},
		'error' : function(jqXHR, textStatus, errorThrown) {
			showError("Ocurrio un error");
		}
	});
};

TituloService.prototype.buscarPresupuesto = function() {
	var p = {};
	this.ajax("buscarPresupuestoTituloAsync", { } , function (ret) { p= ret.presupuesto; }, function (ret) { showError(ret.error); });
	return p;
};


TituloService.prototype.buscaCategoriasDDAFechaTituloAsync = function() {
	var p;
	this.ajax("buscaCategoriasDDAFechaTituloAsync", { } , function (ret) { p= ret; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.buscaListasTituloAsync = function() {
	var p;
	this.ajax("buscaListasTituloAsync", { } , function (ret) { p= ret; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.buscaCategoriaContratoTituloAsync = function() {
	var p;
	this.ajax("buscaCategoriaContratoTituloAsync", { } , function (ret) { p= ret; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.buscaAumentosSapNum = function(item) {
	var p = {};
	this.ajax("busquedaAumentoSapTituloGrid", 
			  { "titulo.idTituloCnt" : item.idTituloCnt }, 
		      function (ret) {  p= ret.aumentos; }, 
		      function (ret) { console.log (ret); showError(ret.error); }
		      );
	return p;
};

TituloService.prototype.consultaContrato = function() {
	var p = {};
	this.ajax("consultaContratoTituloGrid", 
			  { }, 
		      function (ret) {  p= ret.contrato; }, 
		      function (ret) { console.log (ret); showError(ret.error); }
		      );
	return p;
};

TituloService.prototype.obtenTipoCargaDoc = function() {
	var p;
	this.ajax("obtenTipoCarga", { } , function (ret) { console.log(ret); p= ret.tiposCarga; }, function (ret) { showError(ret.error); });
	return p;
};

TituloService.prototype.ajax = function(action, data, success, error) {
	$.ajax({
		url : contextPath +'/contrato/titulos/'+action+'.action',
		type : "post",
		data : data,
		async : false,
		success : function (ret)
		{
			if(ret.error == '' || ret.error == null)
			{
				success(ret);
			}
			else{
				error(ret);
			}
		},
		error : function ( jqXHR,  textStatus,  errorThrown )
		{
			showError("Ocurrio un error");
		}
	});
};