function generaTablaDetalle(notaCreditoData, aprobada) {

	var detalleTamanio = 0;

	if (notaCreditoData.notaCredito !== null
			&& notaCreditoData.notaCredito.contratos !== null) {
		detalleTamanio = notaCreditoData.notaCredito.contratos.length;
		if (detalleTamanio > 0)
			$('#botonGuardar').attr('disabled', false);
		renderTablaDetalleNotaCredito(notaCreditoData.notaCredito.contratos);
		
		desactivaInputsAprobada($("input[name='notaCredito.approved']:checked").val());

		sumatoriaPorNota();
	}
}

function renderTablaDetalleNotaCredito(contratos) {
	var tabla = $("<table/>").attr("id", "tFacturaDetalle").addClass(
			"table factura");
	var encabezado = crearEncabezado();
	var cuerpo = $("<tbody/>");

	for (var i = 0; i < contratos.length; i++) {
		cuerpo.append(crearFilaContrato(contratos[i]));

		for (var j = 0; j < contratos[i].titulos.length; j++) 
			cuerpo.append(crearFilaMes(contratos[i], contratos[i].titulos[j]));
	}

	tabla.append(encabezado).append(cuerpo);
	$("#tablaFacturaDetalle").append(tabla);
	$("#tFacturaDetalle tr.accordion-body").collapse('toggle');
}

/*
 * function agregarValoresIniciales(idCto, mes, valor){ valorA = {id:
 * idCto+"-"+mes, valor : parseFloat(valor)}; montosIniciales.push(valorA); }
 */

function crearEncabezado() {
	var fila = $("<tr/>").addClass("encabezado").append(
			$("<th/>").text("Contrato")).append($("<th/>").text("Origen")).append($("<th/>").text("Titulo")).append(
			$("<th/>").text("Costo")).append($("<th/>").text("Monto"));
	return $("<thead/>").append(fila);
}

function crearFilaContrato(contrato) {

	var idContrato = contrato.idContrato;
	var descripcionContrato = contrato.numeroContrato;
	var costoTotalContrato = contrato.costo;
	var montoTotalContrato = contrato.monto;
	var idSapContrato = contrato.idSap;
	var claveIvaContrato = contrato.claveIva;

	var fila = $("<tr/>")
			.attr("id", "idC-" + idContrato)
			.attr("data-toggle", "collapse")
			.attr("data-target", ".packageDetails" + idContrato)
			.attr("idSap", idSapContrato)
			.attr("claveIva", claveIvaContrato)
			.addClass("trContrato accordion-toggle")
			.append($("<td/>").append("<ins>" + descripcionContrato + "</ins>"))
			.append($("<td/>"))
			.append($("<td/>"))
			.append(
					$("<td/>")
							.text(
									formatCurrency(
											Number(unformatCurrency(costoTotalContrato)),
											4)))
			.append(
					$("<td/>")
							.text(
									formatCurrency(
											Number(unformatCurrency(montoTotalContrato)),
											4)));
	return fila;
}

function crearFilaMes(contrato, titulo) {

	var idContrato = contrato.idContrato;
	var idContratoOrigen = contrato.idContrato;
	var idTitulo = titulo.idTituloCnt;
	var descripcionTitulo = titulo.descTitulo;
	var tipoTitulo = titulo.tipoTitulo;
	var esNuevo = titulo.nuevo;
	var costo = titulo.costo;
	var monto = titulo.monto;
	var descTipoTitulo = '';

	var input = $("<input type='text'/>").attr("idCto", idContrato).attr("mes",
			descripcionTitulo).attr("idOri", idContratoOrigen).attr("nuevo",
			esNuevo).attr("readonly", false).attr("idTto", idTitulo).attr("valido", true).val(
			formatCurrency(Number(unformatCurrency(monto)), 4)).change(
			function() {

				if ($(this).val() != "") {
					var resultado = validaMonto($(this).val());

					if (!resultado.valido) {
						showError(resultado.mensaje);
						$(this).attr("valido", false);
					} else {

						$(this).attr("valido", true);
						$(this).val(
								formatCurrency(Number(unformatCurrency($(this)
										.val())), 4));
						sumatoriaPorContrato(idContrato);
						$(this).attr("guardar", true);

					}
					formaValida = true;
				}

			});
	
	if (tipoTitulo == 0) 
		descTipoTitulo = 'BAJA';
	else descTipoTitulo = 'DISMINUCION';

	var fila = $("<tr/>")
			.attr("id", "idM" + "-" + idContrato + "-" + descripcionTitulo)
			.addClass(
					"trMes accordion-body packageDetails" + idContrato
							+ " collapse in")
			.append($("<td/>"))
			.append($("<td/>").append( descTipoTitulo ))
			.append($("<td/>").append("<ins>" + descripcionTitulo + "</ins>"))
			.append(
					$("<td/>").text(
							formatCurrency(Number(unformatCurrency(costo)), 4)))
			.append($("<td/>").append(input));
	return fila;
}

function sumatoriaPorContrato(idContrato){
	var totalContrato = 0.0;
	
	$("#tFacturaDetalle tr[id^=idM-"+ idContrato +"]").each(function(){ 
		var montoInput = $(this).find("input:last");
		totalContrato = totalContrato + Number(unformatCurrency(montoInput.val()));
	});
	
	$("#tFacturaDetalle tr[id^=idC-"+idContrato+"]").find("td:last-child").text(formatCurrency(Number(unformatCurrency(totalContrato)), 4));    		    	    		

	sumatoriaPorNota();
}

function sumatoriaPorNota(){
	var totalContrato = 0.0;
	
	$("#tFacturaDetalle tr[id^=idC]").each(function(){ 
		var montoInput = $(this).find("td:last-child");
		totalContrato = totalContrato + Number(unformatCurrency(montoInput.text()));
	});
	
	$("#montoNotaCredito").val(formatCurrency(Number(unformatCurrency(totalContrato)), 4));    		    	    		
}

/*
 * function moverPendienteaPagar(idCto, mes){ $("#tFacturaDetalle2
 * tr[id^=idM-"+idCto+"]").each(function(){
 * if($(this).find("input[type='checkbox']").prop( "checked" ) &&
 * !checkAtributo($(this).find("input[type='checkbox']").attr("asignado"))) {
 * var pendiente =
 * parseFloat(unformatCurrency($(this).find("td:nth-child(5)").text())); var
 * pagar =
 * parseFloat(unformatCurrency($(this).find("input[type='text']").val())); var
 * valor = formatCurrency(Number(unformatCurrency(pendiente+pagar)), 4);
 * $(this).find("input[type='text']").val(valor);
 * $(this).find("input[type='text']").attr("valido", "true");
 * $(this).find("td:nth-child(5)").text("0");
 * $(this).find("input[type='checkbox']").attr("asignado",true); } }); }
 */

/*
 * function actualizarFilaMes(idCto, mes, valor){ var total =
 * Number(unformatCurrency($("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(3)").text()), 4); var
 * pagado = Number(unformatCurrency($("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(4)").text()), 4); var
 * pagar;
 * 
 * for(var i=0; i< montosIniciales.length; i++) if(montosIniciales[i].id ==
 * (idCto+"-"+mes)) pagar = montosIniciales[i].valor;
 * 
 * var res = total - (pagado); var pendiente = res -
 * parseFloat(unformatCurrency(valor));
 * 
 * $("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(5)").text(formatCurrency(Number(unformatCurrency(pendiente)),
 * 4)); }
 */

/*
 * function validarFilaMes(idCto, mes, valor){ var total =
 * Number(unformatCurrency($("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(3)").text()), 4); var
 * pagado = Number(unformatCurrency($("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(4)").text()), 4); var
 * pendiente = Number(unformatCurrency($("#tFacturaDetalle2
 * tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(5)").text()), 4); var
 * valido = false; valor = parseFloat(unformatCurrency(valor));
 * 
 * for(var i=0; i< montosIniciales.length; i++) { if(montosIniciales[i].id ==
 * (idCto+"-"+mes)) { var resultado = total - (pagado -
 * montosIniciales[i].valor); if(valor >= 0 && valor <= resultado) valido =
 * true; } } return valido; }
 */

/*
 * function sumarFilas(clase, idCto, mes){ var valores = [0.0, 0.0, 0.0, 0.0];
 * var condicionOri = ""; var condicionDes = "";
 * 
 * if(clase == "trMes") { condicionOri = "tr[id^=idM-"+idCto+"]"; condicionDes =
 * "tr[id=idC-"+idCto+"]"; } else if(clase == "trContrato") { condicionOri =
 * "tr[id^=idC]"; condicionDes = "monto"; }
 * 
 * $("#tFacturaDetalle2 "+ condicionOri ).each(function(){ valores[0] =
 * valores[0] + Number(unformatCurrency($(this).find("td:nth-child(3)").text()),
 * 4); valores[1] = valores[1] +
 * Number(unformatCurrency($(this).find("td:nth-child(4)").text()), 4);
 * valores[2] = valores[2] +
 * Number(unformatCurrency($(this).find("td:nth-child(5)").text()), 4); if(clase ==
 * "trContrato") valores[3] = valores[3] +
 * Number(unformatCurrency($(this).find("td:nth-child(7)").text()), 4); else
 * valores[3] = valores[3] +
 * Number(unformatCurrency($(this).find("input:last").val()), 4); });
 * 
 * if(clase == "trMes") { $("#tFacturaDetalle2
 * "+condicionDes).find("td:nth-child(3)").text(formatCurrency(Number(unformatCurrency(valores[0])),
 * 4)); $("#tFacturaDetalle2
 * "+condicionDes).find("td:nth-child(4)").text(formatCurrency(Number(unformatCurrency(valores[1])),
 * 4)); $("#tFacturaDetalle2
 * "+condicionDes).find("td:nth-child(5)").text(formatCurrency(Number(unformatCurrency(valores[2])),
 * 4)); $("#tFacturaDetalle2
 * "+condicionDes).find("td:nth-child(7)").text(formatCurrency(Number(unformatCurrency(valores[3])),
 * 4)); } else if(clase == "trContrato") {
 * $("#"+condicionDes).val(formatCurrency(Number(unformatCurrency(valores[3])),
 * 4)); } }
 */

function validaMonto(valor) {
	var resultado = {
		valido : true,
		mensaje : ""
	};
	valor = unformatCurrency(valor);

	if (!validateCurrency(valor)) {
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado no es un numero.";
	} else if (parseFloat(valor) < 0) {
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado debe ser mayor o igual a 0.";
	}
	return resultado;
}

/*
 * function checkAtributo(attr){ if (typeof attr !== typeof undefined && attr
 * !== false) return true; else return false; }
 */