package com.mx.dla.dda.admin.presupuestos.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.admin.presupuestos.dtos.AmortApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.ApartadoPreBD;
import com.mx.dla.dda.admin.presupuestos.dtos.MontoTransferirDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoDTO;

public interface PresupuestoDAO {

	public List<PresupuestoDTO>         getPresupuestos(@Param("ids")List<Long> ids);	
	public List<AmortApartadoDTO> getApartadosAmortizacion(@Param("ids")List<Long> ids);			
	public List<PresupuestoApartadoDTO> getApartados();
	
	
	public void almacenaMonto(@Param("annio")Integer annio, @Param("monto")Double monto);
	
	public void guardarApartado(@Param("ap")PresupuestoApartadoDTO apartado, @Param("anio")Integer anio);
	public void actualizarApartado(@Param("ap")PresupuestoApartadoDTO apartado);
	
	public void guardarTransferencia(@Param("obj") MontoTransferirDTO obj);
	public List<AmortApartadoDTO> getAmortizables();
	
	//
	public List<ApartadoPreBD> obtenerApartadosAsignado(@Param("ids") List<PresupuestoApartadoDTO> ids, @Param("anio")Integer anio);
	
	//public List<ApartadoPreBD> obtenerApartadosComprometido(@Param("ids") List<PresupuestoApartadoDTO> ids, @Param("anio")Integer anio);
	public List<ApartadoPreBD> obtenerApartadosComprometido(@Param("tipo") String tipo,@Param("anio")Integer anio);
	
	public String getAmortizable(@Param("anio")Integer anio);
	public List<PresupuestoApartadoDTO> getApartadosXTipo(@Param("tipo") String tipo);
	
	public List<ApartadoPreBD> obtenerPresupuestoAsignado(@Param("ids") List<PresupuestoApartadoDTO> ids);
	
	//public List<ApartadoPreBD> obtenerPresupuestoComprometido(@Param("ids") List<PresupuestoApartadoDTO> ids);
	public List<ApartadoPreBD> obtenerPresupuestoComprometido(@Param("tipo") String tipo);

	public void eliminarPrepApartadoPrevio(@Param("idApartado")Long idapartado, @Param("anio")Integer anio);
}
