package com.mx.dla.dda.factura.general.bos;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;








import com.mx.dla.dda.factura.general.dtos.ContratoFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.FacturaGeneralDTO;
import com.mx.dla.dda.factura.ws.dtos.DTFactura;
import com.mx.dla.dda.factura.ws.dtos.DTFactura.Factura;
import com.mx.dla.dda.factura.ws.dtos.DTFactura.Factura.Posicion;
import com.mx.dla.dda.factura.ws.dtos.DTMovimientoFinalPO;
import com.mx.dla.dda.factura.ws.dtos.DTMovimientoFinalPO.Registro;
import com.mx.dla.dda.factura.ws.dtos.DTMovimientoFinalPO.Registro.Item;
import com.mx.dla.global.bos.BaseBO;

@Component
public class ConvertidordDto2Rest extends BaseBO{

	@Value("${factura.header.sociedad}")
	protected String sociedad;
	
	@Value("${factura.header.indicador}")
	protected String indicador;
	
	@Value("${factura.header.tipoDocumento}")
	protected String tipoDocumento;
	
	@Value("${factura.header.moneda}")
	protected String moneda;
		
	@Value("${factura.detalle.impuesto}")
	protected String impuesto;
	
	@Value("${factura.detalle.cantidad}")
	protected String cantidad;
			
	@Value("${envMov.indEntregaFinal}")
	protected String indEntregaFinal;
	
	@Value("${envMov.indFacturaFinal}")
	protected String indFacturaFinal;
	
	@Value("${envMov.noItem}")
	protected String noItem;
	
	public DTFactura generaFacturaWS(FacturaGeneralDTO facturaDTO, String estudio, String monedaEstudio, String iso) {
		DTFactura  message = new DTFactura();		
		Factura factura    = generaFactura(facturaDTO, estudio, monedaEstudio);				
		factura.setgetPosicion(generaPosiciones(facturaDTO.getContratos(), iso, facturaDTO.getIndicadorIva()));
		message.setFactura(factura);
		print(factura);
		return message;
	}
	
	public Factura generaFactura(FacturaGeneralDTO facturaDTO, String estudio, String monedaEstudio) {
		SimpleDateFormat ft  = new SimpleDateFormat("dd.MM.yyyy");		
		Factura      factura = new Factura();
		
		factura.setSociedad (sociedad);		
		factura.setIndicador(indicador);
		factura.setTipoDoc  (tipoDocumento);
		factura.setMoneda   (monedaEstudio);
		factura.setTexto    (estudio);
		factura.setMonto    (facturaDTO.getMonto());
		factura.setReferencia  (facturaDTO.getNumeroFactura());		
		factura.setFechaFactura(ft.format(facturaDTO.getFechaFactura()));
		factura.setFechaContabilizacion(ft.format(new Date()));				
		return factura;
	}
	
	public List<Posicion> generaPosiciones(List<ContratoFacturaDTO> facturaDetalles, String iso, String indicador) {		
		List<Posicion> pocisiones = new ArrayList<Posicion>();
		Integer       posicionNum = 10;							
				
		for(int i=0; i < facturaDetalles.size(); i++)
		{			
			String posicionStr = "000" + posicionNum;						
			Posicion posicion  = new Posicion();
			
			posicion.setCantidad   (cantidad);
			posicion.setIndImpuesto(indicador);
			posicion.setUnMedidaISO(iso);			
			posicion.setPosicion   (posicionStr);
			posicion.setPosicionPO ("00010");						
			posicion.setImporte    (facturaDetalles.get(i).getTotal().toString());						
			posicion.setPedido     (facturaDetalles.get(i).getIdSapCto());						
		
			pocisiones.add(posicion);			
			posicionNum = posicionNum + 10;
		}																			
		return pocisiones;
	}
	
	public DTMovimientoFinalPO generaRegistro(String idSap) {
		DTMovimientoFinalPO message = new DTMovimientoFinalPO();
		Registro registro = new Registro();
		Item         item = new Item();
				 							
		item.setIndEntregaFin  (indEntregaFinal);
		item.setIndFacturaFinal(indFacturaFinal);
		item.setNumItem        (noItem);
		
		registro.getItem().add(item);
		registro.setNumDoc(idSap);
		message.setRegistro(registro);
		print(registro);
		return message;
	}
	
	public void print(Registro registro) {
		logger.info("numdov: " + registro.getNumDoc());		
		if (registro.getItem() != null)
			for (Item reg : registro.getItem()) {
				logger.info("num: " + reg.getNumItem());				
			}
	}

	public void print(Factura factura) {
		logger.info("Sociedad: " + factura.getSociedad());
		logger.info("Referencia: " + factura.getReferencia());
		logger.info("Indicador: " + factura.getIndicador());
		logger.info("TipoDoc: " + factura.getTipoDoc());
		logger.info("FechaContabilizacion: "
				+ factura.getFechaContabilizacion());
		logger.info("FechaFactura: " + factura.getFechaFactura());
		logger.info("Moneda: " + factura.getMoneda());
		logger.info("Texto: " + factura.getTexto());
		logger.info("Monto: " + factura.getMonto());
		logger.info("**Posiciones**");
		if (factura.getPosicion() != null)
			for (Posicion posicion : factura.getPosicion()) {

				logger.info("Cantidad: " + posicion.getCantidad());
				logger.info("Importe: " + posicion.getImporte());
				logger.info("IndImpuesto: " + posicion.getIndImpuesto());
				logger.info("Pedido: " + posicion.getPedido());
				logger.info("Posicion: " + posicion.getPosicion());
				logger.info("PosicionPO: " + posicion.getPosicionPO());
				logger.info("UnMedidaISO: " + posicion.getUnMedidaISO());

			}
	}

}