package com.mx.dla.dda.contrato.listado.dtos;

public enum EstatusContrato {

	REGISTRO(1,  "En registro"), 
	REVISION(2,  "En revisin"), 
	AUTORIZACION( 3,  "En autorizacin"), 
	AUTORIZADO( 4,  "Autorizado"),
	VIGENTE( 5, "Vigente"), 
	TERMINADO(6,  "Terminado"), 
	NOTIFICACION(7,  "Notificacin con SAP"),
	SUSPENDIDO(   8,  "Suspendido");
		
	private String  desc;
	private Integer id;

	EstatusContrato(Integer id, String desc){
		this.desc = desc;
		this.id = id;
	}
	
	public static String getType(String typeFile){
		
		EstatusContrato [] items = EstatusContrato.values();
		String result = null;
		
		for(EstatusContrato c : items)
		{
			 if(c.desc.compareTo(typeFile) == 0)
			 {
				 result = c.desc;
				 break;
			 }
		}
		return result;		  
	}
	
	public static String getType(Integer id){
		
		EstatusContrato [] items = EstatusContrato.values();
		String result = null;
		
		for(EstatusContrato c : items)
		{
			 if(c.id.intValue() == id.intValue())
			 {
				 result = c.desc;
				 break;
			 }
		}
		return result;		  
	}

}
