package com.mx.dla.dda.reporte.pago.actions;

import java.io.InputStream;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReporteContingenciaBO;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ReporteContingenciaExcelAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private String idCon;
	private Long idEstudio;
	private Date fechaInicio;

	@Autowired
	private ReporteContingenciaBO reporteContingenciaBO;
	@Autowired
	private CargaTransaccionesBO bdsp;
	
	public String execute() {
		fileInputStream = reporteContingenciaBO.obtenerReporteEnExcel(idCon, idEstudio);
		setFileName( idCon != null ? idEstudio + "_" + idCon : idEstudio + "");
		return SUCCESS;
	}

}
