package com.mx.dla.dda.admin.catalogos.addons.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.RelacionAddOnDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.AddOnMenuDTO;

public interface CatalogoAddOnsDAO {

	public List<CatalogoAddOnDTO> catalogoAddOns();
	public List<AddOnMenuDTO> menuCatalogoAddOns();
	public CatalogoAddOnDTO catalogoAddOnsPorId(Integer idAddOn);
	public List<PaisAddOnsVDTO> obtenerPaisesAddOn();
	public List<PaisAddOnsVDTO> obtenerPaisesAddOnXEstudio(@Param("idEstudio")Long idEstudio);
	public Long obtenerIdRelacion(@Param("idEstudio")Long idEstudio, @Param("idPais")Long idPais);
	public void crearNuevaRelacion(RelacionAddOnDTO relacion);
	public void updateAddOn(CatalogoAddOnDTO catalogoAddOnDTO);
	public void guardarAddOn(CatalogoAddOnDTO catalogoAddOnDTO);
	public void actualizaAddOn(CatalogoAddOnDTO catalogoAddOnDTO);
	public void actualizaPreferidoAddOn(CatalogoAddOnDTO catalogoAddOnDTO);
	public void actualizaPreferidoAddOnPorBorrado(@Param("idRelacion")Integer idRelacion);
	public void eliminaPrecioAddon(@Param("idAddOn")Integer idAddOn);
	public Long findIdGrupoDefault();
	public Long numeroRelaciones(@Param("idRelacion")Integer idRelacion);
	public Long numeroRelacionesPreferidas(@Param("idRelacion")Integer idRelacion, @Param("preferido")String preferido);
	public List<String> obtenerPaisesAddOns();
	public Integer numContratosXEstuio(@Param("idAddOn")Long idAddOn);
}
