function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){

	         alert("Ocurri&oacute; un error.");
	     }
	 });
	
}

function validaNuloUndefinido(variable){
	
	if( (variable === null && typeof variable === "object") ||
	    (variable === undefined && typeof variable === "undefined") ||
	    (variable === "" && typeof variable === "string")
	  ){
		return 0;
	   }else {  
		return variable;
	   }
}

function validaParametrosEntrada(estudioEleccion, mesEleccion){
	
	var estudioNoValida = validaNuloUndefinido(estudioEleccion);
	var mesNoValida = validaNuloUndefinido(mesEleccion);
	var fechaValida = validaFechaMesAnio(mesEleccion);
	
	if (estudioNoValida == 0 || mesNoValida == 0 || fechaValida == 0)
		return 0;
   	 return 1;
}


$(document).ready(function(){
	
	var selectedDate = new Date(Date.now());
    var selectedMonth = selectedDate.getMonth();
    var selectedYear = selectedDate.getFullYear();
    
    var selectedByBD = new Date($('#anio').val(), $('#mes').val(), $('#dia').val());
    var selectedDayBD = selectedByBD.getDate();
    var selectedMonthBD = selectedByBD.getMonth();
    var selectedYearBD = selectedByBD.getFullYear();
    console.log(selectedByBD);
    console.log(selectedDayBD);
    console.log(selectedMonthBD);
    console.log(selectedYearBD);

    var lastDate = new Date(selectedYear, selectedMonth + 1, 0);	

	$('#fecha').datepicker({
		changeYear: false,
	    changeMonth: false,
	    minDate:0,
	    maxDate: new Date(selectedYear, selectedMonth + 1, 0),
	    dateFormat: "dd/mm/yy",
	});
	
	
	$('#fecha').datepicker( "setDate", new Date(selectedYearBD, selectedMonthBD - 1, selectedDayBD) );
	
	
    $('#consultaReporte').click(function() { 
    	
    	 var estudioEleccion = 'datComodin';
       	 var mesEleccion = $('#fecha').val();
    	    	
	 if (validaParametrosEntrada(estudioEleccion, mesEleccion) != 0){
		
	    	generaReporteAmortizacion( mesEleccion);
	    	showMessage(" Bloqueado de " + mesEleccion + " a fin de mes." );
	    	
	    	
	 }else {
		 showError("No se ha seleccionado un valor v\u00E1lido de fecha.");
		 }
    });
    
    

	
});


function validaFechaMesAnio(fecha){
	
	var fecha_valida = 0;
	
    

	try {
	    testdate = $.datepicker.parseDate('dd/mm/yy', fecha);
	    fecha_valida = 1;

	} catch (e)
	{
		fecha_valida = 0;
	}
	
    return fecha_valida;
}


function generaReporteAmortizacion(fecha){

	  
	  if (validaNuloUndefinido(fecha) == 0)
		  fecha = null;
	  	  
	  var jsonString = '{"fecha": "' + fecha + '"}';	  
	  var stringJson = JSON.parse(jsonString); 	  

	  callActionAjax( "/admin/bloqueoSAP/ejecuta", stringJson, procesaDatosReporte);
}


function procesaDatosReporte(datos){
	
	console.log(datos)
	
	
} 




