<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=iso-8859-1"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="/WEB-INF/struts-tags.tld" prefix="s"%>
<%@ taglib prefix="v" tagdir="/WEB-INF/tags"%>
<%@ taglib prefix="dfn" uri="http://dla.com/functions" %>
<%@ taglib uri="http://www.springframework.org/security/tags" prefix="sec"%>

<c:set var="contextPath" value="${pageContext.request.contextPath}" scope="request" />

<%@ page import="java.util.List, com.mx.dla.admin.dtos.MenuDTO"%>
<%
	List<MenuDTO> menus = (List<MenuDTO>) session.getAttribute("menus");
	int totalMenus		= menus.size();

	String pmn 			= (String) request.getParameter("pmn");
	
	MenuDTO menuPadre 	= null;
	MenuDTO menuHnos 	= null;
	MenuDTO menuActual 	= null;
	
	String actionMenu 	= "";
	String menuDestino	= "";
	String paramDestino	= "";
		
	String parametros	= "?pmn=" + pmn;
%>

<jsp:useBean id="usuario" type="com.mx.dla.admin.dtos.UsuarioDTO" scope="session"></jsp:useBean>

<html lang="es">
<head>
<title>DLA Derechos de Autor</title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="">

<!-- ===== FAVICON =====-->
<link rel="shortcut icon" href="${contextPath}/design/favicon.ico">

<!-- ===== CSS =====-->
<!-- General-->
<!-- Especificos del portal -->
<link rel="stylesheet" href="${contextPath}/css/styles.css">

<link rel="stylesheet" href="${contextPath}/design/css/basic.css">
<link rel="stylesheet" href="${contextPath}/design/css/general.css">
<link rel="stylesheet" href="${contextPath}/design/css/theme.css" class="style-theme">
 
<!-- Specific-->
<link rel="stylesheet" href="${contextPath}/design/css/addons/fonts/artill-clean-icons.css" />

<!-- BootStrap -->
<link rel="stylesheet" href="${contextPath}/design/pestanas/bootstrap.css" />
<link rel="stylesheet" href="${contextPath}/css/common/jquery-ui/jquery-ui.min.css" />

<!-- PAra subir archivos -->
<link rel="stylesheet" href="${contextPath}/css/common/jquery-upload/uploadfile.css" />



<!-- ===== JS =====-->
<!-- jQuery-->    
<script src="${contextPath}/design/js/basic/jquery.min.js"></script>
<script src="${contextPath}/design/js/basic/jquery-migrate.min.js"></script>

<script src="${contextPath}/js/common/jquery/jquery-ui/jquery-ui.min.js"></script>

<!-- Para el validador -->
<script src="${contextPath}/js/common/jquery/jquery-validation/jquery.validate.min.js"></script>
<script src="${contextPath}/js/common/jquery/jquery-validation/additional-methods.min.js"></script>
<script src="${contextPath}/js/common/jquery/jquery-validation/localization/messages_es.js"></script>
<script src="${contextPath}/js/common/jquery/jquery-upload/jquery.form.js"></script>
<script src="${contextPath}/js/common/jquery/jquery-upload/jquery.uploadfile.js"></script>
<script src="${contextPath}//js/common/jquery/dynTable/dynamicTable.js"></script>

<script>

var context = "${contextPath}";

//-- Calendario
$.datepicker.regional['es'] = {
		closeText: 'Cerrar',
		prevText: '&#x3c;Ant',
		nextText: 'Sig&#x3e;',
		currentText: 'Hoy',
		monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio',
		'Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
		monthNamesShort: ['Ene','Feb','Mar','Abr','May','Jun',
		'Jul','Ago','Sep','Oct','Nov','Dic'],
		dayNames: ['Domingo','Lunes','Martes','Mi&eacute;rcoles','Jueves','Viernes','S&aacute;bado'],
		dayNamesShort: ['Dom','Lun','Mar','Mi&eacute;','Juv','Vie','S&aacute;b'],
		dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','S&aacute;'],
		weekHeader: 'Sm',
		dateFormat: 'dd/mm/yy',
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''};
		
$.datepicker.setDefaults($.datepicker.regional['es']);	

//-- Validador

$.validator.setDefaults({
		errorClass: "text-danger" 
	});
	
$.validator.addMethod(
	    "date",
	    function(value, element) {
	    	if(value=="")
	    		{
	    			return true;
	    		}
	    	return value.match(/^\d\d?\/\d\d?\/\d\d\d\d$/);
	    },
	    "Proporcione una fecha en mm/dd/yyyy."
	);

$.validator.addClassRules({
	  required: {
		  required: true
	  },
	  datepicker: {
		  date : true
	  }
	});

$(function() {
  $( ".datepicker" ).datepicker();
});
	
function showError(msg)
{
	$("#divError").html("<div class='alert alert-dismissible alert-danger'> <button type='button' class='close' data-bs-dismiss='alert'></button> <h4>Error</h4>"+msg+"</div>")
}

function showMessage(msg)
{
	$("#divMessage").html("<div class='alert alert-dismissible alert-info'> <button type='button' class='close' data-bs-dismiss='alert'></button> <h4>Mensajes</h4>"+msg+"</div>")
}

function showWarn(msg)
{
	$("#divMessage").html("<div class='alert alert-dismissible alert-warning'> <button type='button' class='close' data-bs-dismiss='alert'></button> <h4>Advertencia</h4>"+msg+"</div>")
}

</script>

</head>

<body class="l-dashboard">

	<%
	if( usuario.getNombre() == null ){
	%>
		<script>
			alert('Su sesin ha expirado.');
			window.location ="${contextPath}/";
		</script>
	<%
	}
	%>

	<!--HEADER SLIDE-->
	<header id="header"
		class="l-header-slide l-header-slide-3 t-header-slide-3"> </header>

	<!--SECTION-->
	<section class="l-main-container">
		<!--Left Sidebar Content-->
		<aside id="sb-left" class="l-sidebar l-sidebar-1 t-sidebar-1">
			<!--Switcher-->
			<div class="l-side-box">
				<a href="#" data-ason-type="sidebar" data-ason-to-sm="sidebar"
					data-ason-target="#sb-left"
					class="sidebar-switcher switcher t-switcher-side ason-widget"><i
					class="fa fa-bars"></i></a>
			</div>
			<!-- Profile in sidebar-->
			<div class="widget-profile-2 profile-2-in-side-2 t-profile-2-3">
				<div class="profile-2-wrapper">
					<div class="profile-2-chart">
						<div class="hide rickshaw-visitors"></div>
						<div id="rickshawVisitors"></div>
						<div id="rickshawVisitorsLegend" class="visitors_rickshaw_legend"></div>
					</div>
				</div>
			</div>
			<!-- Logo in Sidebar-->
			<div class="l-side-box">
				<!--Logo-->
				<div class="widget-logo logo-in-side">
					<h1>
						<a href="inicio"><span
							class="logo-default visible-default-inline-block"><img
								src="${contextPath}/design/img/logo.png" alt="DLA"></span><span
							class="logo-medium visible-compact-inline-block"><img
								src="${contextPath}/design/img/logo_medium.png" alt="DLA"
								title="DLA"></span> <spanl
								class="logo-small visible-collapsed-inline-block">
							<img src="${contextPath}/design/img/logo_small.png" alt="DLA"
								title="DLA"></spanl></a>
					</h1>
				</div>
			</div>
			<!--Main Menu-->
			<div class="l-side-box">
				<!--MAIN NAVIGATION MENU-->
				<nav class="navigation">
					<ul data-ason-type="menu" class="ason-widget">					
						<%
							for (MenuDTO menu : menus){
								
								if( menuActual == null && menu != null)
									menuActual = menu.obtenerMenu( pmn );
								
								if( menuPadre == null && menuActual != null )
								{
									String idPadre = menuActual.getIdMenuPadre(); 
									menuPadre = menu.obtenerMenu( idPadre );									
								}
									

								if (!menu.getTipoMenu().equals("0")) {
						%>
						<li>
							<a href="${contextPath}/<%=menu.getScript() + "?pmn=" + menu.getIdMenu() + "&" + menu.getParametros()%>">
								<i class="<%=menu.getIconClass()%>"></i> 
							 	<span class="title">
							 		<%=menu.getNombre()%>
							 	</span>
						 		<span class="arrow">
						 			<i class="fa fa-angle-right"></i>
						 		</span>
							</a>												 
						<%
			 			List<MenuDTO> hijos = menu.getHijos();
			
			 			if (hijos != null)
			 				out.println("<ul>");
			
			 			for (MenuDTO hijo : hijos) {
			 				
			 				List<MenuDTO> nietos = hijo.getHijos();
			 				
			 				actionMenu 		= hijo.getScript();
			 				menuDestino		= hijo.getIdMenu();
			 				paramDestino	= hijo.getParametros();
			 				
			 				if( nietos != null && nietos.size() > 0) {
			 					actionMenu 		= nietos.get( 0 ).getScript();
			 					menuDestino 	= nietos.get( 0 ).getIdMenu();
			 					paramDestino 	= nietos.get( 0 ).getParametros();
			 					
			 					if( !paramDestino.isEmpty() )
			 						paramDestino = '&' + paramDestino;
			 				}
			 			%>
						<li>
							<a href="${contextPath}/<%=actionMenu + "?pmn=" + menuDestino + paramDestino%>">
								<span class="title">
									<%=hijo.getNombre()%>
								</span>
							</a>
						</li>
						<%
							}
									if (hijos != null)
										out.println("</ul>");

									out.println("</li>");
								}
							}
						%>
					</ul>
				</nav>
			</div>
		</aside>
		<!--Main Content-->
		<section class="l-container">
			<!--HEADER-->
			<header class="l-header l-header-1 t-header-1">
				<div class="navbar navbar-ason">
					<div class="container-fluid">
						<div class="navbar-header">
							<button type="button" data-bs-toggle="collapse"
								data-bs-target="#ason-navbar-collapse"
								class="navbar-toggle collapsed">
								<span class="sr-only">Toggle navigation</span><span
									class="icon-bar"></span><span class="icon-bar"></span><span
									class="icon-bar"></span>
							</button>
							<a href="inicio" class="navbar-brand widget-logo"><span
								class="logo-default-header"><img
									src="${contextPath}/design/img/logo_dark.png" alt="DLA"></span></a>
						</div>
						<div id="ason-navbar-collapse" class="collapse navbar-collapse">
							<ul class="nav navbar-nav navbar-right">
								<li>
									<!-- Profile Widget-->
									<div class="widget-profile profile-in-header">
										<button type="button" data-bs-toggle="dropdown"
											class="btn dropdown-toggle">
											<span class="name"> <jsp:getProperty name="usuario"
													property="nombre" /> <jsp:getProperty name="usuario"
													property="paterno" /> <jsp:getProperty name="usuario"
													property="materno" />
											</span>
										</button>

										<ul role="menu" class="dropdown-menu">
											<li><a href="#"><i
													class="fa fa-user"></i>Perfil</a></li>
											<li><a href="#"><i class="fa fa-cog"></i>Configuraci&oacute;n</a></li>
											<li class="power">
												<a href="<c:url value="/j_spring_security_logout"/>">
													<i class="fa fa-power-off"></i>Salir</a>
												</li>
										</ul>
									</div>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</header>

			<%
			if(menuActual != null)
			{
			%>
			<div class="l-page-header">
				<h2 class="l-page-title">
					<span><fmt:message key="<%= menuActual.getDescripcion()%>" /></span>
				</h2>
				<!--BREADCRUMB-->
				<ul class="breadcrumb t-breadcrumb-page">
					Home <%=menuActual.getRuta()%>
				</ul>
			</div>
			<%
			}
			%>	
			
			<div style="margin:10px;">
				<ul class="nav nav-tabs">
				    <%
						if( menuPadre != null && menuActual.getTipoMenu().equals("2")) {
							List<MenuDTO> hermanos = menuPadre.getHijos();
							
							if( hermanos != null && hermanos.size() > 1 ) 
							{
								for (MenuDTO pestana : hermanos) 
								{
									actionMenu 		= pestana.getScript();
				 					menuDestino 	= pestana.getIdMenu();
				 					paramDestino 	= pestana.getParametros();
				 					
									if( pestana.getIdMenu().equals(pmn) ) {
									%>
										<li class="active">
											<a href="#"><%=pestana.getNombre()%></a>
										</li>
									<%
									}
									else {
									%>
										<li>
											<a href="${contextPath}/<%=actionMenu + "?pmn=" + menuDestino + paramDestino%>">
											<%=pestana.getNombre()%>
											</a>
										</li>
									<%
									}
								}
							}
						}
					%>			    					    
				  </ul>	
			</div>
			  
			<div class="l-spaced">
				<div class="l-box l-spaced-bottom">	
					<div class="l-box-header">
						<h2 class="l-box-title">
						<%
						if(menuActual != null)
						{
						%>
							<span><%= menuActual.getDescripcion() %></span>
						<%
						}
						%>
						</h2>
						<ul class="l-box-options">
							<li><a href="#" data-ason-type="fullscreen"
								data-ason-target=".l-box" data-ason-content="true"
								class="ason-widget"></a></li>
								
							<li><a href="#" data-ason-type="toggle"
								data-ason-find=".l-box" data-ason-target=".l-box-body"
								data-ason-content="true" data-ason-duration="200"
								class="ason-widget"></a></li>
						</ul>
					</div>
					
					<div class="l-box-body l-spaced form-horizontal" style="height:100%">
					

					
			