function TituloController() {
	this.formManager = new FormManager();
	this.service = new TituloService();
	this.componentesGenerales();
	this.grid = new TituloGrid("tituloGird");
	this.uploader = new UploaderEX("cargaTitulosDiv", this.onUpload, this.grid);
	this.reloadGrid();

	$('div[id="divBotonesTitulo"] button').prop("disabled", true);
	$('#bExportarLista').prop("disabled", true);

	var perfil = new PerfilController();
	perfil.ejecutarPerfil(parseInt(pmn));
	this.ajustarAcciones();
};

TituloController.prototype.ajustarAcciones = function() {

	if (tipoMovimiento == 1 || tipoMovimiento == 2) {
		$("#operaciones > option").each(function() {
			if (this.value == "costo" || this.value == "anio" || this.value == "trasladar" || this.value == "nombre") {
				$(this).remove();
			}
		});
	}
	if (tipoMovimiento == 3) {
		$("#operaciones > option").each(function() {
			if (this.value == "categoria") {
				$(this).remove();
			}
		});
	}

}

TituloController.prototype.open = function(modal, obj) {
	$("#errPerCat").hide();
	$("#id" + modal + " [name=fechaFin]").datepicker("option", "minDate", null);
	$("#id" + modal + " [name=fechaInicio]").datepicker("option", "maxDate", null);

	$("#id" + modal + " [name=fechaInicio]").datepicker('option', 'onClose', function(selectedDate) {
		$("#id" + modal + " [name=fechaFin]").datepicker("option", "minDate", selectedDate);
	});

	$("#id" + modal + " [name=fechaFin]").datepicker('option', 'onClose', function(selectedDate) {
		$("#id" + modal + " [name=fechaInicio]").datepicker("option", "maxDate", selectedDate);
	});
	this.formManager.limpiarForma("id" + modal);
	if ((typeof obj != 'undefined' && obj != null)) {
		this.formManager.llenarForma(obj, "id" + modal, this.grid.getColumns());
	}
	$('#modal' + modal).modal('show');

};

TituloController.prototype.alta = function() {
	$("#errPerCat").hide();
	if ($("#idEditForm").valid()) {
		var me = this;
		var titulo = this.formManager.leerForma('idEditForm', this.grid.getColumns());

		if ((titulo.pagoCateg != null && titulo.precioAnual != null) || (titulo.anioContrato != null && titulo.precioAnual != null)) //se valida u que no exista categoria fees y pago al mismo tiempo		
			$("#errPerCat").text("El t\u00EDtulo no debe tener Precio y Categor\u00EDa Estudio - A\u00F1o contrato.").show();
		else if (titulo.pagoCateg == null && titulo.precioAnual == null && titulo.anioContrato == null)
			$("#errPerCat").text("El t\u00EDtulo no debe tener Precio y Categor\u00EDa Estudio - A\u00F1o contrato.").show();
		else if ((titulo.anioContrato != null && titulo.pagoCateg == null && titulo.precioAnual == null) || (titulo.anioContrato == null && titulo.pagoCateg != null && titulo.precioAnual == null))
			$("#errPerCat").text("El t\u00EDtulo no debe tener Precio y Categor\u00EDa Estudio - A\u00F1o contrato.").show();
		else {
			var fechaCambioValido = moment(titulo.fechaInicio, 'MM/DD/YYYY').year() == $("#idLista option:selected").text();

			if (!fechaCambioValido)
				$("#errPerCat").text("La fecha de inicio del t\u00EDtulo no esta dentro de la fecha de la lista seleccionada").show();
			else {
				$("#errPerCat").hide();
				this.service.guardarTitulos("EDITAR", titulo, null, function(ret) {

					if (ret.mensaje != null) {
						me.service.titulo = titulo;
						$('#divAddSeries').modal('show');
					}
					else {
						showMessage("Datos guardados correctamente");
						me.reloadGrid();
						me.cargaSugerencias();
						$('#modalEditForm').modal('hide');
					}
				});
			}
		}
	}
};

TituloController.prototype.altaSeriesAutomatico = function() {
	$("#errPerCat").hide();
	var me = this;
	this.service.guardarSeriesAuto(this.service.titulo, function(ret) {
		me.reloadGrid();
		me.cargaSugerencias();
		$('#divAddSeries').modal('hide');
		$('#modalEditForm').modal('hide');
		showMessage("Datos guardados correctamente");
	});
};

TituloController.prototype.openCambio = function() {
	var titulo = this.grid.itemsSelected();
	if (titulo.length == 1) {
		if (tipoMovimiento == 3 && titulo[0].idSap == null)  //el contrato es enmienda
			this.open("EditForm", titulo[0]);
		if (tipoMovimiento == 3 && titulo[0].idSap != null)
			showError("No se puede editar, ya ha sido notificado a SAP.");
		if (tipoMovimiento != 3)
			this.open("EditForm", titulo[0]);
	}
	else {
		showError("Debe seleccionar un registro");
	}
};

TituloController.prototype.openBaja = function() {
	var titulo = this.grid.itemsSelected();
	if (titulo.length == 1) {
		var a = titulo[0];
		$(".descTituloElim").html(a.descTitulo);

		if (a.idSap == '' || a.idSap == null || typeof a.idSap == 'undefined')
			this.open("Eliminar", titulo[0]);
		else if (a.idSap != null && a.fechaNotifsap == null)
			this.open("EliminarSAP", titulo[0]);
		else if (a.idSap != null && a.fechaNotifsap != null)
			this.open("EliminarFechaSAP", titulo[0]);
	}
	else {
		showError("Debe seleccionar un registro");
	}
	
};

TituloController.prototype.baja = function(modal) {
	if ($("#id" + modal).valid()) {
		var me = this;
		var a = this.formManager.leerForma("id" + modal, this.grid.getColumns());

		if (a.bajaPerdida != undefined)
			a.bajaPerdida = a.bajaPerdida.value;
		var valido = true;

		if (modal == "EliminarSAP") {
			if ($("#modalEliminarSAP input[name='fechaContabilizacion']").val() == "") {
				valido = false;
				$("#errEli").text("La fecha de contabilizaci\u00F3n debee ser obligatoria.").show();
			}
		}
		if (modal == "EliminarFechaSAP") {
			if ($("#modalEliminarFechaSAP input[name='fechaContabilizacion']").val() == "" || $("#modalEliminarFechaSAP select").val() == "") {
				valido = false;
				$("#errEliFecha").text("La fecha de contabilizaci\u00F3n debeee ser obligatoria.").show();
			}

			if ($("#bajaPerdida").val() == "") {
				valido = false;
				$("#errEliFecha").text("El tipo de perdida es obligatorio.").show();
			}
		}

		if (valido) {
			$("#errEli").hide();
			$("#errFechaEli").hide();
			this.service.eliminarTitulos(a, function() {
				showMessage("Datos guardados correctamente");
				me.reloadGrid();
				me.cargaSugerencias();
			});
			$('#modal' + modal).modal('hide');
		}
	}
};

TituloController.prototype.openCambioMultiple = function(modal, accion) {
	
	var titulo = this.grid.itemsSelected();

	if (titulo.length != 0) {
		if (tipoMovimiento == 3) {
			if (titulo.length > 1)
				showError("Solamente se permite editar un elemento a la vez.");
			else {
				if (accion == "ventana" || (accion == "costo" && titulo[0].idSap != null))
					this.open(modal, titulo[0]);
				else
					showError("Esta operaci\u00F3n no se puede ejecutar.");
			}
		}
		else
			this.open(modal, titulo[0]);
	}
	else
		showError("Debe seleccionar al menos un registro");
};

TituloController.prototype.cambioMultiple = function(cambio, modal) {
	if ($("#id" + modal).valid()) {
		var me = this;
		var titulo = this.formManager.leerForma("id" + modal, this.grid.getColumns());
		var v = this.grid.itemsSelected();

		if (v.length != 0 && v[0] == null)
			v.shift();   //Se remueve el primer elemento que es la informacion del total

		var indx = "";
		for (var i = 0; i < v.length; i++) {
			indx += v[i].idTituloCnt + ",";
		}

		this.service.guardarTitulos(cambio, titulo, indx, function() {

			showMessage("Datos guardados correctamente");
			me.reloadGrid();
			me.cargaSugerencias();
		});
		$('#modal' + modal).modal('hide');
	}
};

TituloController.prototype.guardarCambios = function() {
	this.service.guardarCambios();
};


TituloController.prototype.exportarBusqueda = function() {
	this.service.descargarArchivo();
};

TituloController.prototype.buscarPresupuesto = function() {
	var p = this.service.buscarPresupuesto();
	var columns = [
		{ name: "amortizable" },
		{ name: "comprometido" },
		{ name: "disponible" },
		{ name: "contratoActual" },
		{ name: "amortizableEstudio" },
		{ name: "comprometidoEstudiod" },
		{ name: "disponibleEstudio" }
	];
	this.formManager.llenarForma(p, "idFormPresupuesto", columns);
	$("#presupuestoDiv").show();
	if (p.errores != null) {
		if (p.errores.length != 0) { showError(p.errores); }
	}
	if (p.mensajes != null) {
		if (p.mensajes.length != 0) { showMessage(p.mensajes); }
	}

};

TituloController.prototype.reloadGrid = function() {
	this.grid.reload();
}

TituloController.prototype.descargarArchivoErrores = function() {
	this.service.descargarArchivoErrores();
};

TituloController.prototype.componentesGenerales = function() {
	this.formManager.initForm("idEditForm", {
		rules: {
			"mesesExclusivo": {
				required: function() {
					return $("#pjeExclusivo") != null && $("#pjeExclusivo").val() != '';
				},
				digits: true

			},
			"pjeExclusivo": {
				required: function() {
					return $("#mesesExclusivo") != null && $("#mesesExclusivo").val() != '';
				},
				digits: true,
				range: [0, 100]

			},
			"descTitulo": {
				required: true,
				maxlength: 200
			},
			"nombreUnico": {
				required: true,
				maxlength: 200
			},
			"temporada": {
				maxlength: 10
			},
			"episodio": {
				maxlength: 10
			},
			"idBv": {
				maxlength: 12
			},
			"anioContrato": {
				digits: true,
				range: [1, 99]
			},
		}
	});

	this.formManager.initForm("idCambioForm", {
		rules: {
			"mesesExclusivo": {
				required: function() {
					return $("#pjeExclusivo") != null && $("#pjeExclusivo").val() != '';
				},
				digits: true

			},
			"pjeExclusivo": {
				required: function() {
					return $("#mesesExclusivo") != null && $("#mesesExclusivo").val() != '';
				},
				digits: true,
				range: [0, 100]

			},
			"descTitulo": {
				required: true,
				maxlength: 200
			},
			"nombreUnico": {
				required: true,
				maxlength: 200
			},
			"temporada": {
				maxlength: 10
			},
			"episodio": {
				maxlength: 10
			},
			"idBv": {
				maxlength: 12
			},
			"anioContrato": {
				digits: true,
				range: [1, 99]
			},
		}
	});

	this.formManager.initForm("idEliminar");
	this.formManager.initForm("idEliminarSAP");
	this.formManager.initForm("idCategoriaForm");
	this.formManager.initForm("idVentanaForm");

	$("#idFormaBusqueda [name=idLista]").select({
		url: contextPath + '/contrato/titulos/buscaListasTituloAsync.action',
		root: 'listas',
		displayZero: true,
		async: false,
		fields: {
			value: 'value',
			text: 'desc'
		}
	});

	var catalogos = this.service.buscaCategoriasDDAFechaTituloAsync();
	var categoriaContrato = this.service.buscaCategoriaContratoTituloAsync();

	var tiposCarga = this.service.obtenTipoCargaDoc();
	inicializarRadioButtons("radioTipoCarga", tiposCarga);


	this.inicializarSelect("idCategoriaForm [name=pagoCateg]", catalogos.categoriasDDAFecha);
	this.inicializarSelect("idEditForm [name=pagoCateg]", catalogos.categoriasDDAFecha);
	this.inicializarSelect("idCambioForm [name=pagoCateg]", catalogos.categoriasDDAFecha);
	this.inicializarSelect("idCostoForm [name=pagoCateg]", catalogos.categoriasDDAFecha);

	this.inicializarSelect("idEditForm [name=categoriaTit]", categoriaContrato.categoriaContrato);
	this.inicializarSelect("idCambioForm [name=categoriaTit]", categoriaContrato.categoriaContrato);
};

TituloController.prototype.inicializarSelect = function(nombre, elementos) {

	$("#" + nombre).append($('<option>', { value: "", text: "Seleccione" }));

	for (var i = 0; i < elementos.length; i++)
		$("#" + nombre).append($('<option>', {
			value: elementos[i].value,
			text: elementos[i].desc
		}));
};

TituloController.prototype.inicializarSelectVal = function(nombre, elementos) {

	$("#" + nombre).append($('<option>', { value: "0", text: "Selecciona" }));

	for (var i = 0; i < elementos.length; i++)
		$("#" + nombre).append($('<option>', {
			value: elementos[i].value,
			text: elementos[i].desc
		}));
};

TituloController.prototype.cargaSugerencias = function() {
	
};

TituloController.prototype.openCargarDocumento = function() {
	if ($("#idListaActual").val() == $("#idLista").val()) {
		this.uploader.opentUploader();
	}
	else {
		showError("No es posible efectuar la accion");
	}
};

TituloController.prototype.onUpload = function(data, grid) {

	if (data.error == '' || data.error == null) {
		if (data.tipoCarga == 'N') {
			$("#idFormaBusqueda [name=idLista]").select({
				url: contextPath + '/contrato/titulos/buscaListasTituloAsync.action',
				root: 'listas',
				displayZero: true,
				async: false,
				fields: {
					value: 'value',
					text: 'desc'
				}
			});
		}

		inicializarRadioButtons("radioTipoCarga", data.tiposCarga);

		var resp = data.respuestaExcel;
		$("#idListaActual").val(resp.lista.idLista);


		grid.reload();

		$('#modalCarga').modal('hide');


		$("#totalResultFile").html(resp.response.datosCarga.TOTAL_REGISTROS);
		$("#cargadoResultFile").html(resp.response.datosCarga.TOTAL_CARGADOS);
		$("#rechazatoResultFile").html(resp.response.datosCarga.TOTAL_ERROR);
		$("#montoResultFile").html("$ " + parseFloat(resp.monto).formatDLA());
		$('#modalResultadosCarga').modal('show');

		if (data.tipoCarga != 'C') {
			$("#cargadosLine").show();
			$("#montoLine").show();
			if (resp.response.datosCarga.TOTAL_ERROR != 0) {
				$("#errorFile").show();
			}
			else {
				$("#errorFile").hide();
			}
		} else {
			$("#errorFile").hide();
			$("#cargadosLine").hide();
			$("#montoLine").hide();
		}


	}
	else {
		showError(data.error);
		$('#modalCarga').modal('hide');
	}
};


function inicializarRadioButtons(nombreDiv, elementos) {
	$('#' + nombreDiv).empty();
	for (var i = 0; i < elementos.length; i++)
		$('#' + nombreDiv).append('<label><input name="tipoCargaDocumento" type="radio" value="' + elementos[i].value + '" />' + elementos[i].desc + '</label>');
};

TituloController.prototype.startUpload = function(item) {
	var nameModal = "modalCarga";
	this.uploader.startUpload(nameModal);
};

TituloController.prototype.openDialogAmortizacion = function(value) {
	var gridAmort = new AmortizacionGrid("amortizacionGrid");

	gridAmort.obtenerPintarDatos(value);
};

TituloController.prototype.cargaDetalle = function(val) {
	this.grid.reloadDetails(val);
};

TituloController.prototype.actualizaAmortizacion = function(val) {
	var me = this;
	$.ajax({
		url: contextPath + '/contrato/titulos/calculaAmortizacionTituloGrid.action',
		type: "post",
		success: function(ret) {
			me.reloadGrid();
		},
		error: function(jqXHR, textStatus, errorThrown) {
			showError("Ocurri\u00F3 un error");
		}
	});
};

TituloController.prototype.ejecutarAcciones = function() {
	var accion = $("#operaciones").val();

	if (accion == "categoria")
		tituloController.open('CategoriaForm');

	if (accion == "agregar")
		tituloController.open('EditForm');

	if (accion == "editar")
		tituloController.openCambio();

	if (accion == "ventana") {
		$("#errVentana").hide();

		var titulo = this.grid.itemsSelected();

		if (titulo) {
			var idSap = titulo[0].idSap;
			var fechaInicioDisabled = true;

			if (idSap == null)
				fechaInicioDisabled = false;

			$("#idVentanaForm input[name='fechaInicio']").prop("disabled", fechaInicioDisabled);
		}

		tituloController.openCambioMultiple('VentanaForm', accion);
	}

	if (accion == "costo") {
		$("#errCosto").hide();
		tituloController.openCambioMultiple('CostoForm', accion);
	}

	if (accion == "trasladar") {
		var titulo = this.grid.itemsSelected();

		if (titulo.length != 0) {
			if (tipoMovimiento == 3) {
				if (titulo.length > 1)
					showError("Solamente se permite editar un elemento a la vez.");
				else {
					var aumentos = this.service.buscaAumentosSapNum(titulo[0]);

					if (aumentos.length > 1)
						showError("Solamente se permite trasladar t\u00EDtulos sin movimientos de aumento previos.");
					else {
						if (titulo[0].idSap != null) {
							$("#errTraslado").hide();
							var nom = (titulo[0].idBv == null ? "" : titulo[0].idBv) + ":" + titulo[0].descTitulo;
							this.open('CambioForm');
							$("#tTrasladar").val(nom);
							$("#idTitAntTras").val(titulo[0].idTituloCnt);
						}
						else
							showError("Esta operaci\u00F3n no se puede ejecutar.");
					}
				}
			}
		}
		else
			showError("No se ha seleccionado un elemento a trasladar.");
	}
	if (accion == "eliminar") {
		tituloController.openBaja();
	}
};

TituloController.prototype.validarTrasladarCambio = function() {

	if ($("#idCambioForm").valid()) {
		var me = this;
		var titulo = this.formManager.leerForma('idCambioForm', this.grid.getColumns());

		if (titulo.pagoCateg != null && titulo.precioAnual != null) //se valida u que no exista categoria fees y pago al mismo tiempo
		{
			$("#errTraslado").show();
		}
		else if (titulo.pagoCateg == null && titulo.precioAnual == null) {
			$("#errTraslado").text("Se debe seleccionar categor\u00EDa estudio o proporcionar el precio.").show();
		}
		else if ($("#modalCambioForm input[name='fechaContabilizacion']").val() == "") {
			$("#errTraslado").text("Se debe registrar la fecha de contabilizaci\u00F3n").show();
		}
		else {
			var fechaCambioValido = moment(titulo.fechaInicio, 'MM/DD/YYYY').year() == $("#idLista option:selected").text();
			if (!fechaCambioValido)
				$("#errTraslado").text("La fecha de inicio del t\u00EDtulo no esta dentro de la fecha de la lista seleccionada").show();
			else {
				$("#errTraslado").hide();

				var indx = $("#idTitAntTras").val() + ",";
				titulo.idTituloCntant = $("#idTitAntTras").val();

				this.service.guardarTitulos('TRASLADAR', titulo, indx, function() {
					showMessage("Datos guardados correctamente");
					me.reloadGrid();
				});

				$('#modalCambioForm').modal('hide');
			}
		}
	}
}

TituloController.prototype.validarCostoCambio = function() {
	if ($("#modalCostoForm input[name='fechaContabilizacion']").val() == "") {
		$("#errCosto").text("Se debe registrar la fecha de contabilizaci\u00F3n").show();
	}
	else if (($("#modalCostoForm input[name='anioContrato']").val() != "" && $("#modalCostoForm input[name='precioAnual']").val() != "") ||
		($("#modalCostoForm select").val() != "" && $("#modalCostoForm input[name='precioAnual']").val() != "")) {
		$("#errCosto").text("Si se registra categor\u00eda y a\u00f1o contrato no se debe registrar precio. Si se registra precio no se debe registrar categor\u00eda y a\u00f1o contrato.").show();
	}
	else if (($("#modalCostoForm input[name='anioContrato']").val() != "" && $("#modalCostoForm select").val() == "") ||
		($("#modalCostoForm input[name='anioContrato']").val() == "" && $("#modalCostoForm select").val() != "")) {
		$("#errCosto").text("Si se registra categor\u00eda se debe registrar a\u00f1o contrato. Si se registra a\u00f1o contrato se debe registrar categor\u00eda .").show();
	}
	else {
		$("#errCosto").hide();
		tituloController.cambioMultiple('COSTO', 'CostoForm');
	}
}

TituloController.prototype.validarVentanaCambio = function() {

	var fechaInicioTitulo = $("#idVentanaForm input[name='fechaInicio']").val();
	var fechaFinTitulo = $("#idVentanaForm input[name='fechaFin']").val();
	var contrato = this.service.consultaContrato();
	var fechaInicioContrato = contrato.fechaInicio;

	if (!fechaInicioTitulo || !fechaFinTitulo) {
		$("#errVentana").text("No se selecciono una fecha valida").show();;
	}
	else {
		var timeFechaInicioTitulo = $.datepicker.parseDate('mm/dd/yy', fechaInicioTitulo).getTime();
		var timeFechaFinTitulo = $.datepicker.parseDate('mm/dd/yy', fechaFinTitulo).getTime();
		var timeFechaInicioContrato = new Date(fechaInicioContrato).getTime();

		if (timeFechaInicioTitulo < timeFechaInicioContrato)
			$("#errVentana").text("La fecha de inicio seleccionada del t\u00EDtulo no esta dentro de la vigencia del contrato").show();
		else if (!(timeFechaFinTitulo >= new Date().getTime()))
			$("#errVentana").text("La fecha fin seleccionada debe ser mayor al d\u00EDa actual").show();
		else {
			var fechaCambioValido = moment(fechaInicioTitulo, 'MM/DD/YYYY').year() == $("#idLista option:selected").text();

			if (!fechaCambioValido)
				$("#errVentana").text("La fecha de inicio del t\u00EDtulo no esta dentro de la fecha de la lista seleccionada").show();
			else {
				tituloController.cambioMultiple('VENTANA', 'VentanaForm');
				$("#errVentana").hide();
			}
		}

	}

};

TituloController.prototype.validarFechaMismoMesActual = function(fecha) {

	var dateObj = new Date();
	var month = dateObj.getUTCMonth() + 1;

	var mes = fecha.split("/")[0];
	mes = parseInt(mes);

	if (mes != month)
		return false;
	else
		return true;
}

TituloController.prototype.habilitaAcciones = function() {

	console.log($("#idLista").children('option:first-child').is(':selected'));

	if ($("#idLista option").length > 0 && $("#idLista").children('option:first-child').is(':selected')) {
		$('#operaciones').attr('disabled', false);
		$('.guardar').attr('disabled', false);
	}
	else {
		$('#operaciones').attr('disabled', true);
		$('.guardar').attr('disabled', true);
	}

}





var tituloController;

$().ready(function() {

	//*****Se necesita para quitar bug boostraop jquery dialog****
	var bootstrapButton = $.fn.button.noConflict();
	$.fn.bootstrapBtn = bootstrapButton;
	//***************************************************

	tituloController = new TituloController();
});

