package com.mx.dla.dda.admin.catalogos.estudios.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.estudios.bos.EstudioBO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.bos.GrupoEstudioBO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.dtos.GrupoEstudioDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;

public class CatalogoEstudiosAction extends BaseAction {

	private static final long serialVersionUID = 1L;

	private List<CatalogoEstudioDTO> catalogoEstudios;
	private CatalogoEstudioDTO estudio;
	private String nombreEstudio;

	private boolean estudioActualizado;
	private boolean regresoAction;
	private Long campoGrupo;
	private List<GrupoEstudioDTO> grupos;
	private Long idEstudio;
	private String sigla;
	private String nombreAddOn;
	private boolean seRepiteSigla;
	private String esAddOn;

	@Autowired
	private EstudioBO estudioBO;

	@Autowired
	private GrupoEstudioBO GrupoEstudioBO;

	@Override
	public String execute() {
		setPmns();
		return SUCCESS;
	}

	public String listadoEstudios() throws TransaccionException {
		try {
			catalogoEstudios = new ArrayList<CatalogoEstudioDTO>();
			catalogoEstudios = estudioBO.catalogoEstudios();

		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return Action.SUCCESS;
	}

	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 42);
		this.getSession().put("pmnReturn", 42);
		this.setPmn("42");
		this.setPmnReturn("42");
	}

	public String dirigirAgregar() {
		setPmns();
		return SUCCESS;
	}

	public String guardaEstudio() throws TransaccionException {

		try {

			this.estudio = estudioBO.guardarEstudio(nombreEstudio);
			this.estudioActualizado = true;

		} catch (ResultMapException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		return Action.SUCCESS;
	}

	public String actualizaEstudio() throws TransaccionException {

		try {

			estudio.setIdGrupo(campoGrupo);
			logger.debug("[{}]", estudio);
			estudioBO.updateEstudio(estudio);
			int idEstudio = this.estudio.getIdEstudio();
			this.estudio = estudioBO.catalogoEstudiosPorId(idEstudio);
			this.estudioActualizado = true;
			setIdEstudio(estudio.getIdEstudio().longValue());

		} catch (ResultMapException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();

		return "estudioActualizado";
	}

	public String buscaEstudio() throws TransaccionException {
		try {
			setGrupos(GrupoEstudioBO.obtenerGrupoEstudio(null));
			this.estudio = estudioBO.catalogoEstudiosPorId(idEstudio.intValue());

		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return "estudioConsultado";
	}

	public String obtneEstudio() throws TransaccionException {
		try {
			setEstudio(estudioBO.catalogoEstudiosPorId(idEstudio.intValue()));
			setGrupos(GrupoEstudioBO.obtenerGrupoEstudio(idEstudio));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String actualizaEstudioMod() throws TransaccionException {
		setSeRepiteSigla(estudioBO.seRepiteSigla(idEstudio, sigla));
		try {
			if (!getSeRepiteSigla()) {
				estudioBO.actulizaCatalogoEstudio(idEstudio, sigla, campoGrupo, Integer.valueOf(esAddOn), nombreAddOn);
				this.estudio = estudioBO.catalogoEstudiosPorId(idEstudio.intValue());
				this.estudioActualizado = true;
			}
		} catch (ResultMapException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			this.estudioActualizado = false;
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public List<CatalogoEstudioDTO> getCatalogoEstudios() {
		return catalogoEstudios;
	}

	public void setCatalogoEstudios(List<CatalogoEstudioDTO> catalogoEstudios) {
		this.catalogoEstudios = catalogoEstudios;
	}

	public CatalogoEstudioDTO getEstudio() {
		return estudio;
	}

	public void setEstudio(CatalogoEstudioDTO estudio) {
		this.estudio = estudio;
	}

	public boolean isEstudioActualizado() {
		return estudioActualizado;
	}

	public void setEstudioActualizado(boolean estudioActualizado) {
		this.estudioActualizado = estudioActualizado;
	}

	public void setNombreEstudio(String nombreEstudio) {
		this.nombreEstudio = nombreEstudio;
	}

	public boolean isRegresoAction() {
		return regresoAction;
	}

	public void setCampoGrupo(Long campoGrupo) {
		this.campoGrupo = campoGrupo;
	}

	public Long getCampoGrupo() {
		return campoGrupo;
	}

	public void setGrupos(List<GrupoEstudioDTO> grupos) {
		this.grupos = grupos;
	}

	public List<GrupoEstudioDTO> getGrupos() {
		return grupos;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setSigla(String sigla) {
		this.sigla = sigla;
	}

	public String getSigla() {
		return sigla;
	}

	public boolean getSeRepiteSigla() {
		return seRepiteSigla;
	}

	public void setSeRepiteSigla(boolean seRepiteSigla) {
		this.seRepiteSigla = seRepiteSigla;
	}

	public String getEsAddOn() {
		return esAddOn;
	}

	public void setEsAddOn(String esAddOn) {
		this.esAddOn = esAddOn;
	}

	public String getNombreAddOn() {
		return nombreAddOn;
	}

	public void setNombreAddOn(String nombreAddOn) {
		this.nombreAddOn = nombreAddOn;
	}

}
