package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Controller
@Scope("request")
public class CambiarAddendumAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idContrato;
	private String numeroContrato;

	@Autowired
	private GeneralesBO generalesBO;

	@Override
	public String execute() throws TransaccionException {
		try {
			logger.info("idContrato a cambiar : [{}]", idContrato);
			generalesBO.cambiarAddendum(idContrato, numeroContrato);
			logger.info("Contrato virtual No. " + idContrato + " actualizado a addendum.");
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

}
