var idAddOn;

$(document).ready(
	function() {
		inicial();
		
		$('#inpPais').on('change', function() {
		      if( $( "#inpPais option:selected" ).text() == 'ARGENTINA'){
		    	  $('#divArgentinaVat').show();
		    	  $('#divArgentinaPrecio').show();
		    	  $('#lblVat').text('Vat Movil:');
		    	  $('#lblPrecio').text('Precio Neto Movil:');
		      } else {
		    	  $('#divArgentinaVat').hide();
		    	  $('#divArgentinaPrecio').hide();
		    	  $('#lblVat').text('Vat:');
		    	  $('#lblPrecio').text('Precio Neto:');
		      }
		    });
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataAddOn");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/preciosAddons/";
    var rowId=null;
    var oTable=null;
     oTable=$('#cataAddOn').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "listadoAddOns",
		"sAjaxDataProp":"", 
	    "aoColumns": [
	    				// {"sTitle":"ID"						,"mDataProp":"idAddOn"				,"bSearchable":true, 	sWidth:"500px"},
	    				{"sTitle":"Estudio"					,"mDataProp":"estudio"				,"bSearchable":true, 	sWidth:"30px"},
						{"sTitle":"Pais"					,"mDataProp":"pais"					,"bSearchable":true, 	sWidth:"30px"},
						{"sTitle":"Revenue Share"			,"mDataProp":"revenueShare"			,"bSearchable":true, 	sWidth:"30px"},
						{"sTitle":"Precio"					,"mDataProp":"precio"				,"bSearchable":true, 	sWidth:"20px"},
						{"sTitle":"Vat"						,"mDataProp":"vat"					,"bSearchable":true,	sWidth:"20px"},
	          			{"sTitle":"Precio Neto"				,"mDataProp":"precioNeto"			,"bSearchable":true,	sWidth:"20px"},
						{"sTitle":"Tipo de Cambio"			,"mDataProp":"tipoDeCambio"			,"bSearchable":true,	sWidth:"40px"},
						//{"sTitle":"Calculo Monto Por Pais"	,"mDataProp":"calculoMontoXPais"	,"bSearchable":true,	sWidth:"60px"},
						//{"sTitle":"Calculo Revenue Share"	,"mDataProp":"calculoRevenueShare"	,"bSearchable":true,	sWidth:"60px"},
						{"sTitle":"Tarifa Minima"			,"mDataProp":"tarifaMinima"			,"bSearchable":true,	sWidth:"30px"},
						{"sTitle":"Preferido"				,"mDataProp":"preferido"			,"bSearchable":true,	sWidth:"30px"},
						{"sTitle":"Accion"					,"mDataProp":"preferido"			,"bSearchable":true,	sWidth:"30px"}
	          		],
    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
    		        
    		        	var link = '<a onClick="guardaIdAddOn(' + aData["idAddOn"] + ')" data-bs-toggle="modal" data-bs-target="#modalAgregaActualizaAddOn"> ' + aData["estudio"] +'</a>';
    		        	var button = '<button class="btn btn-danger" type="button" onclick="eliminarPrecio(' + aData["idAddOn"] + ',\'' + aData["preferido"] + '\',' + aData["idRelacion"] + ')">Eliminar</button> ';
    		        	$(nRow).attr("id", aData["idAddOn"]);
    		        	$('td:eq(0)', nRow).html(link);
    		        	$('td:eq(1)', nRow).html(aData["pais"]);
    		        	$('td:eq(2)', nRow).html(aData["revenueShare"] + " %").addClass('text-align-right');
	          			$('td:eq(3)', nRow).html("$	" + aData["precio"]);
    		        	$('td:eq(4)', nRow).html(aData["vat"] + " %");
	          			$('td:eq(5)', nRow).html("$	" + aData["precioNeto"]);
	          			$('td:eq(6)', nRow).html(aData["tipoDeCambio"]);
	          			//$('td:eq(7)', nRow).html(aData["calculoMontoXPais"]);
	          			//$('td:eq(8)', nRow).html(aData["calculoRevenueShare"]);
	          			$('td:eq(7)', nRow).html("$	" + aData["tarifaMinima"]);
	          			$('td:eq(8)', nRow).html(aData["preferido"]);
	          			$('td:eq(9)', nRow).html(button);
   		       		}
		});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	pais: 
		          {
		            required: true,
		            maxlength: 150,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	pais: 
		          {
		            required: "Nombre del Pais es obligatorio.",
		            maxlength: "Nombre no debe exceder 150 caracteres",
		            regex: "Nombre debe ser con caracteres alfanum\u00E9ricos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{
		window.location.href = contextPath + "/catalogos/preciosAddons/dirigirAgregarAddOn.action?pmn=205&pmnReturn=205";				
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == null || menu == undefined || menu == '')
		menu = 205;
	window.location.href = contextPath + "/catalogos/preciosAddons/index.action?pmn=" + 205;
}

function guardaIdAddOn(id) {	
	idAddOn = id;
	llamaObtenAddOn(idAddOn);
}

function llamaObtenAddOn(id) {
	var jsonString = '{"idAddOn" : "'+ id +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/preciosAddons/llamaObtenAddOn", stringJson, procesaRespuestaObtenAddOn);
}

function procesaRespuestaObtenAddOn(jsonData) {
	var addon = jsonData.addOn;
	var stdios = jsonData.estudios;
	var stdio;
	var paisesList = jsonData.paises;
	var paisTemp;
	//debugger
	$('#inpEstudio')			.val(addon.idEstudio);
	$('#inpPais')				.val(addon.idPaisAddOn);
	$('#inpRevenueShare')		.val(addon.revenueShare);
	$('#inpPrecio')				.val(addon.precio);
	$('#inpVat')				.val(addon.vat);
	$('#inpPrecioNeto')			.val(addon.precioNeto);
	$('#inpVatFijo')				.val(addon.vatFijo);
	$('#inpPrecioNetoFijo')			.val(addon.precioNetoFijo);
	$('#inpTipoDeCambio')		.val(addon.tipoDeCambio);
	$('#inpCalculoMontoXPais')	.val(addon.calculoMontoXPais);
	$('#inpCalculoRevenueShare').val(addon.calculoRevenueShare);
	$('#inpTarifaMinima')		.val(addon.tarifaMinima);
	
	$('#inpEstudio').children().remove();
	
	var option;
	for(var i = 0; i < stdios.length; i++){
		stdio = stdios[i];
					
		if(addon.idEstudio == stdio.idEstudio) {
			$('#inpEstudio').append('<option value="'+ stdio.idEstudio +'" selected> '+ stdio.nombre +' </option>');
		}else {
			$('#inpEstudio').append('<option value="'+ stdio.idEstudio +'"> '+ stdio.nombre +' </option>');
		}						
	}
	
	for(var i = 0; i < paisesList.length; i++){
		paisTemp = paisesList[i];
					
		if(addon.idPaisAddOn == paisTemp.idPaisAddOn) {
			$('#inpPais').append('<option value="'+ paisTemp.idPaisAddOn +'" selected> '+ paisTemp.nombre +' </option>');
			if( paisTemp.nombre == 'ARGENTINA'){
				$('#divArgentinaVat').show();
				$('#divArgentinaPrecio').show();
				$('#lblVat').text('Vat Movil:');
				$('#lblPrecio').text('Precio Neto Movil:');
			} else {
				$('#divArgentinaVat').hide();
				$('#divArgentinaPrecio').hide();
				$('#lblVat').text('Vat:');
				$('#lblPrecio').text('Precio Neto:');
			}
		}else {
			$('#inpPais').append('<option value="'+ paisTemp.idPaisAddOn +'"> '+ paisTemp.nombre +' </option>');
		}						
	}
	if(addon.preferido == 'SI') {
		$( "#inpPreferido" ).val(1);
		$( "#inpPreferido" ).prop('checked', true);
	}else {
		$( "#inpPreferido" ).val(0);
		$( "#inpPreferido" ).prop('checked', false);
	}
}

function showErrorModal(msg)
{
	$("html, body").animate({ scrollTop: 0 }, "slow");
	$("#divErrorModal").html("<div class='alert alert-dismissible alert-danger'> <button type='button' class='close' data-dismiss='alert'>×</button> <h4>Error</h4>"+parseMessage(msg)+"</div>");
	closeDialog("divErrorModal");
};

function closeDialogModal(id)
{
	$("#"+id).show();
	setTimeout(function() {
		$("#"+id).slideUp("slow");
		}, 5000);
};

function llamaActualizaAddOn(){
	
	if (validaCampos()){
	
	var jsonString = '{"idAddOn" : "' + idAddOn + '", "idEstudio" : "' + $('#inpEstudio').val() + 
	'", "pais" : "' + $('#inpPais').val() + '", "revenueShare" : "' + $('#inpRevenueShare').val() + 
	'", "precio" : "' + $('#inpPrecio').val() + '", "vat" : "' + $('#inpVat').val() + '", "precioNeto" : "' + $('#inpPrecioNeto').val() + 
	'", "vatFijo" : "' + $('#inpVatFijo').val() + '", "precioNetoFijo" : "' + $('#inpPrecioNetoFijo').val() + 
	'", "tipoDeCambio" : "' + $('#inpTipoDeCambio').val() + '", "calculoMontoXPais" : "' + $('#inpCalculoMontoXPais').val() + 
	'", "calculoRevenueShare" : "' + $('#inpCalculoRevenueShare').val() + '", "tarifaMinima" : "' + $('#inpTarifaMinima').val() + '", "preferido" : "' + $("#inpPreferido").val() + '"}';
	var stringJson = JSON.parse(jsonString);
	
	callActionAjax("/catalogos/preciosAddons/llamaActualizarAddOn", stringJson, procesaRespuestaActualiza);
	}
}

function guardarAddOn(){
	if (validaCampos()){
	var jsonString = '{"idEstudio" : "' + $('#inpEstudio').val() + '", "pais" : "' + $('#inpPais').val() + '", "revenueShare" : "' + $('#inpRevenueShare').val() + 
	'", "precio" : "' + $('#inpPrecio').val() + '", "vat" : "' + $('#inpVat').val() + '", "precioNeto" : "' + $('#inpPrecioNeto').val() + 
	'", "vatFijo" : "' + $('#inpVatFijo').val() + '", "precioNetoFijo" : "' + $('#inpPrecioNetoFijo').val() + 
	'", "tipoDeCambio" : "' + $('#inpTipoDeCambio').val() + '", "calculoMontoXPais" : "' + $('#inpCalculoMontoXPais').val() + 
	'", "calculoRevenueShare" : "' + $('#inpCalculoRevenueShare').val() + '", "tarifaMinima" : "' + $('#inpTarifaMinima').val() + '", "preferido" : "' + $("#inpPreferido").val() + '"}';	
	var stringJson = JSON.parse(jsonString);
	
	callActionAjax("/catalogos/preciosAddons/agregarAddOn", stringJson, procesaRespuestaActualiza);
	
	return true;
	
	}else{return false;}
}

function eliminarPrecio(id, pref, idRelacion){
	if(confirm('¿Esta seguro de borrar este precio?')){
		var jsonString = '{"idAddOn" : "' + id + '", "preferido" : "' + pref + '", "idRelacion" : "' + idRelacion + '"}';
		var stringJson = JSON.parse(jsonString);
		callActionAjax("/catalogos/preciosAddons/eliminaprecioAddOn", stringJson, procesaRespuestaActualiza);
	}
}


function esPorcentaje(valor){
	var isValid =  valor.match(/^((100(\.0{1,2})?)|(\d{1,2}(\.\d{1,2})?))$/) == null ? false:true;
	return isValid;
}

function esNumero(valor){
	if(isNaN(valor)){
		return false;
	 }else{
		 return true;
	 }
}

function validaCampos(){
	
	//validamos que sean porcentajes y numericos
	
	var strRev = $("#inpRevenueShare").val();
	var strPre = $("#inpPrecio").val();
	var inpVat = $("#inpVat").val();
	var strPreNeto = $("#inpPrecioNeto").val();
	var strTarMin = $("#inpTarifaMinima").val();
		
	if(!esPorcentaje(strRev)){
		showError("Revenue Share inv\u00E1lido, formato de porcentaje");
		showErrorModal("Revenue Share inv\u00E1lido, formato de porcentaje");
		return false;
	}
	
	if(!esNumero(strPre)){
		showError("Precio inv\u00E1lido, formato num\u00E9rico");
		showErrorModal("Precio inv\u00E1lido, formato num\u00E9rico");
		return false;
	}
	
	if(!esPorcentaje(inpVat)){
		showError("Vat inv\u00E1lido, formato de porcentaje");
		showErrorModal("Vat inv\u00E1lido, formato de porcentaje");
		return false
	}
	
	if(!esNumero(strPreNeto)){
		showError("Precio Neto inv\u00E1lido, formato num\u00E9rico");
		showErrorModal("Precio Neto inv\u00E1lido, formato num\u00E9rico");
		return false;
	}
	
	if(!esNumero(strTarMin)){
		showError("Tarifa minima inv\u00E1lido, formato num\u00E9rico");
		showErrorModal("Tarifa minima inv\u00E1lido, formato num\u00E9rico");
		return false;
	}
	
	return true;
}


function procesaRespuestaActualiza(jsonData){
	var seRepite = jsonData.addOnActualizado;
	
	$('#modalAgregaActualizaAddOn').modal('hide');
	if(seRepite){
		showMessage("Actualizado con exito");
	}else{
		showError("El Add On ya existe.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}

function cambiaValorCheck(){
	if($( "#inpPreferido" ).val() == 1) {
		$( "#inpPreferido" ).val(0);
	}else {
		$( "#inpPreferido" ).val(1);
	}
}

function calculaImpuestoMovil(){
	if( $('#inpPrecio').val() != '' && $('#inpVat').val() != '' ){
		var imp = $('#inpVat').val();
		var precio = $('#inpPrecio').val();
		$('#inpPrecioNetoFijo').val(precio - precio * (imp/100));
	}
}

function calculaImpuestoFijo(){
	if( $('#inpPrecio').val() != '' && $('#inpVatFijo').val() != '' ){
		var imp = $('#inpVatFijo').val();
		var precio = $('#inpPrecio').val();
		$('#inpPrecioNetoFijo').val(precio - precio * (imp/100));
	}
}

