function PagosTxGrid() {
	this.columnsInicio = [
		            {header:"",name:"idContrato",visible:false,width:'250'},
					{header:"",name:"idLista",visible:false,width:'50'},
					{header:"",name:"idCalculoCosto",visible:false,width:'230'},
					{header:"",name:"idTituloCnt",visible:false,width:'230'},
					{header:"Titulo",name:"descTitulo",visible:true,width:'300'},
					{header:"Categoria",name:"categoria",visible:true,width:'80'},
					{header:"Estudio",name:"descEstudio",visible:false,width:'230'},
					{header:"Tipo Titulo",name:"tipoTitulo",visible:false,width:'230'},
					{header:"Inicio de Exivici&oacute;n",name:"inicioVentana",visible:false,width:'230'},
					{header:"MG",name:"minimo",visible:true,width:'100'}
					];
	
	this.columnsFin = [
					{header:"Total",name:"acumulado",visible:true,width:'100'},
					{header:"OVERAGE",name:"overage",visible:true,width:'100'}
				];
	this.init();
};

PagosTxGrid.prototype.paint = function(items , meses) {
	this.grid.setItems(items);
	
	var columnMeses = [];
	for(var _i=0; _i <meses.length ;_i++)
	{
		var aux = {header:meses[_i],name:meses[_i],visible:true,width:'100', customRender : function(item, model,index){
			var r = item.detallesMesCosto[model.name];
			return (r != null && typeof r != 'undefined') ? r : "";
		}};
		columnMeses.push(aux);
	}
	
	var clmns = this.columnsInicio.concat(columnMeses);
	this.grid.settings.colModel = clmns.concat(this.columnsFin);
	this.grid.init();
};

PagosTxGrid.prototype.init = function() {
	var me = this;
	var columns = this.columnsInicio.concat(this.columnsFin);
	this.grid = $("#dyn1").dynTable({
		lazyInit : true,
		local : true,
		prefix : 'pagos',
		root : 'pagos',
		colModel : columns,
        edit : false,
        dateFormatIn:"yy-mm-dd",
        dateFormatOut:"mm/dd/yy"
	});
	this.grid.init();
};