package com.mx.dla.global.bos;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.constants.ExcelMapperDataType;
import com.mx.dla.dda.excelMapper.dtos.ExcelEntityResult;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.dtos.FilaExcelDTO;

@Service
public class ReadExcelBO extends BaseBO{
	
	@Autowired 
	private ExcelMapperTransform excelMapperTransform; 
	
	public List<FilaExcelDTO> obtenerDatosExcel(String nombreArchivo) throws ExcelMapperException{
		   List<FilaExcelDTO> filas = new ArrayList<FilaExcelDTO>();

		   ExcelMapper mapper = new ExcelMapper();
		   mapper.setClassName("com.mx.dla.global.dtos.FilaExcelDTO");
		   mapper.setFirstRow(1);
			
		   List<ExcelRule> rules = new ArrayList<ExcelRule>();
		   ExcelRule er = new ExcelRule();
		   
		   er.setType(ExcelMapperDataType.string);			
		   er.setAttribute("fila");
		   rules.add(er);
		   
		   mapper.setRules(rules);			
						
		   ExcelEntityResult<Object> res = excelMapperTransform.readExcelToObject(nombreArchivo, mapper);
			
		   for(int i=0; i<res.getResult().size(); i++)
		   {
			  FilaExcelDTO fila = (FilaExcelDTO)res.getResult().get(i);
			  filas.add(fila);
		   }
		   
		   return filas;
	}
	
	public List<FilaExcelDTO> obtenerDatosExcel(String uriCarga, File fileUpload, String fileName) throws IOException, ExcelMapperException {
		return obtenerDatosExcel(uriCarga, fileUpload, fileName , null, null);
	}
	
	public List<FilaExcelDTO> obtenerDatosExcel(String uriCarga, File fileUpload, String fileName, String expediente, Long idContrato ) throws IOException, ExcelMapperException {
		
		String nombreArchivo = (expediente == null && idContrato == null) ? uriCarga + fileName : uriCarga + idContrato + expediente + fileName;
		
		byte [] f = FileUtils.readFileToByteArray(fileUpload);
		File d = new File(nombreArchivo);
		
		d.setExecutable(true, false);
	    d.setReadable(true, false);
	    d.setWritable(true, false);
	    
	    logger.debug("Absolute path [{}]  -  [{}]",d.getCanonicalPath() , d.getPath());
		FileUtils.writeByteArrayToFile(d, f);		
		
		List<FilaExcelDTO> datos = this.obtenerDatosExcel(nombreArchivo);
		return datos;	
	}

}
