/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.addons.bos;

import com.mx.dla.dda.admin.catalogos.addons.daos.CatalogoAddOnsDAO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.RelacionAddOnDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class AddOnBO
extends BaseBO {
    @Autowired
    private CatalogoAddOnsDAO catalogoAddOnsDAO;

    public List<CatalogoAddOnDTO> catalogoAddOns() {
        return this.catalogoAddOnsDAO.catalogoAddOns();
    }

    public void updateAddOn(CatalogoAddOnDTO addOn) {
        this.catalogoAddOnsDAO.updateAddOn(addOn);
    }

    public CatalogoAddOnDTO guardarAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare, Double precio, Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio, String calculoMontoXPais, String calculoRevenueShare, Double tarifaMinima, String preferido) {
        Long idRelacion = null;
        idRelacion = this.catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
        if (idRelacion == null) {
            RelacionAddOnDTO relacion = new RelacionAddOnDTO();
            relacion.setIdEstudio(Long.valueOf(String.valueOf(idEstudio)));
            relacion.setIdPaisAddOn(Long.valueOf(pais));
            relacion.setEstatus(Long.valueOf(1L));
            this.catalogoAddOnsDAO.crearNuevaRelacion(relacion);
            idRelacion = this.catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
        }
        CatalogoAddOnDTO addOnNuevo = new CatalogoAddOnDTO();
        addOnNuevo.setIdAddOn(idAddOn);
        addOnNuevo.setIdRelacion(idRelacion);
        addOnNuevo.setRevenueShare(revenueShare);
        addOnNuevo.setPrecio(precio);
        addOnNuevo.setVat(vat);
        addOnNuevo.setPrecioNeto(precioNeto);
        addOnNuevo.setTipoDeCambio(tipoCambio);
        addOnNuevo.setCalculoMontoXPais(calculoMontoXPais);
        addOnNuevo.setCalculoRevenueShare(calculoRevenueShare);
        addOnNuevo.setTarifaMinima(tarifaMinima);
        addOnNuevo.setPreferido(preferido);
        addOnNuevo.setVatFijo(vatFijo);
        addOnNuevo.setPrecioNetoFijo(precioNetoFijo);
        if (preferido.equals("1")) {
            this.catalogoAddOnsDAO.actualizaPreferidoAddOn(addOnNuevo);
        } else {
            Long num = this.catalogoAddOnsDAO.numeroRelaciones(Integer.valueOf(idRelacion.intValue()));
            if (num == 0L) {
                addOnNuevo.setPreferido("1");
            }
        }
        try {
            this.catalogoAddOnsDAO.guardarAddOn(addOnNuevo);
        }
        catch (DuplicateKeyException ex) {
            System.out.println(ex.getMessage());
            throw new DuplicateKeyException("PK");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return addOnNuevo;
    }

    public CatalogoAddOnDTO catalogoAddOnsPorId(Integer idAddOn) {
        CatalogoAddOnDTO addOn = this.catalogoAddOnsDAO.catalogoAddOnsPorId(idAddOn);
        this.logger.debug("Busca addOn");
        return addOn;
    }

    public List<PaisAddOnsVDTO> obtenerPaisesAddOn() {
        return this.catalogoAddOnsDAO.obtenerPaisesAddOn();
    }

    public void actulizaCatalogoAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare, Double precio, Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio, String calculoMontoXPais, String calculoRevenueShare, Double tarifaMinima, String preferido) {
        Long num;
        this.logger.debug("[{}]", (Object)idAddOn);
        Long idRelacion = this.catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
        CatalogoAddOnDTO addOn = new CatalogoAddOnDTO();
        addOn.setIdAddOn(idAddOn);
        addOn.setIdRelacion(idRelacion);
        addOn.setRevenueShare(revenueShare);
        addOn.setPrecio(precio);
        addOn.setVat(vat);
        addOn.setPrecioNeto(precioNeto);
        addOn.setTipoDeCambio(tipoCambio);
        addOn.setCalculoMontoXPais(calculoMontoXPais);
        addOn.setCalculoRevenueShare(calculoRevenueShare);
        addOn.setTarifaMinima(tarifaMinima);
        addOn.setPreferido(preferido);
        addOn.setVatFijo(vatFijo);
        addOn.setPrecioNetoFijo(precioNetoFijo);
        if (preferido.equals("1")) {
            this.catalogoAddOnsDAO.actualizaPreferidoAddOn(addOn);
        }
        this.catalogoAddOnsDAO.actualizaAddOn(addOn);
        if (preferido.equals("0") && (num = this.catalogoAddOnsDAO.numeroRelacionesPreferidas(revenueShare, "1")) == 0L) {
            addOn.setPreferido("1");
            this.catalogoAddOnsDAO.actualizaAddOn(addOn);
        }
    }

    public boolean seRepitePais(String pais) {
        boolean ret = false;
        List paises = null;
        try {
            paises = this.catalogoAddOnsDAO.obtenerPaisesAddOns();
            for (String sig : paises) {
                if (!pais.equals(sig)) continue;
                ret = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
            ret = true;
        }
        return ret;
    }

    public void eliminaprecioAddOn(Integer idAddOn, String preferido, Integer idRelacion) {
        this.catalogoAddOnsDAO.eliminaPrecioAddon(idAddOn);
        if (preferido.equals("SI")) {
            this.catalogoAddOnsDAO.actualizaPreferidoAddOnPorBorrado(idRelacion);
        }
    }
}

