/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.deal.bos;

import com.mx.dla.dda.contrato.deal.daos.DealDAO;
import com.mx.dla.dda.contrato.deal.dtos.ContratoFilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.ContratoTypeDTO;
import com.mx.dla.dda.contrato.deal.dtos.DealDTO;
import com.mx.dla.dda.contrato.deal.dtos.FilialDTO;
import com.mx.dla.dda.contrato.deal.dtos.TypeDTO;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DealBO
extends BaseBO {
    @Autowired
    private DealDAO dealDAO;
    @Autowired
    private TerminosDAO feesDAO;

    public DealDTO cargaInformacionDeal(DealDTO dealParam) {
        DealDTO deal = new DealDTO();
        if (dealParam != null) {
            Long idContrato = dealParam.getIdContrato();
            DealDTO dealDTO = new DealDTO();
            ContratoFilialDTO contratoFilialDTO = new ContratoFilialDTO();
            ContratoTypeDTO contratoTypeDTO = new ContratoTypeDTO();
            dealDTO.setIdContrato(idContrato);
            contratoFilialDTO.setIdContrato(idContrato);
            contratoTypeDTO.setIdContrato(idContrato);
            ContratoConsultaDTO request = new ContratoConsultaDTO();
            request.setIdContrato(idContrato);
            ContratoConsultaDTO contrato = this.feesDAO.consultaContrato(request);
            deal.setIdContrato(idContrato);
            deal.setLimitesLicencia(contrato.getLimitesLicencia());
            List filialesTotales = new ArrayList();
            filialesTotales = this.dealDAO.consultaDealFiliales();
            List filialesElegidas = new ArrayList();
            filialesElegidas = this.dealDAO.consultaDealFilialesByContrato(contratoFilialDTO);
            ArrayList<FilialDTO> filialesDisponibles = new ArrayList<FilialDTO>();
            Boolean fElegida = false;
            for (FilialDTO filial : DealBO.safeList(filialesTotales)) {
                if (filial == null) continue;
                for (FilialDTO filialElegida : DealBO.safeList(filialesElegidas)) {
                    if (filialElegida == null || filial.getIdFilial().longValue() != filialElegida.getIdFilial().longValue()) continue;
                    fElegida = true;
                }
                if (!fElegida.booleanValue()) {
                    filialesDisponibles.add(filial);
                }
                fElegida = false;
            }
            List typesTotales = new ArrayList();
            typesTotales = this.dealDAO.consultaDealTypes();
            List typesElegidas = new ArrayList();
            typesElegidas = this.dealDAO.consultaDealTypesByContrato(contratoTypeDTO);
            ArrayList<TypeDTO> typesDisponibles = new ArrayList<TypeDTO>();
            Boolean tElegida = false;
            for (TypeDTO type : DealBO.safeList(typesTotales)) {
                if (type == null) continue;
                for (TypeDTO typeElegida : DealBO.safeList(typesElegidas)) {
                    if (typeElegida == null || type.getIdType().longValue() != typeElegida.getIdType().longValue()) continue;
                    tElegida = true;
                }
                if (!tElegida.booleanValue()) {
                    typesDisponibles.add(type);
                }
                tElegida = false;
            }
            deal.setFilialesDisponibles(filialesDisponibles);
            deal.setFilialesElegidos(filialesElegidas);
            deal.setTypesDisponibles(typesDisponibles);
            deal.setTypesElegidos(typesElegidas);
        }
        return deal;
    }

    public void actualizaInformacionDeal(DealDTO dealParam) {
        if (dealParam != null) {
            ContratoConsultaDTO request = new ContratoConsultaDTO();
            request.setIdContrato(dealParam.getIdContrato());
            request.setLimitesLicencia(dealParam.getLimitesLicencia());
            this.feesDAO.actualizaContratoLimitesLicencia(request);
            ContratoFilialDTO contratoFilialDTO = new ContratoFilialDTO();
            contratoFilialDTO.setIdContrato(dealParam.getIdContrato());
            ContratoTypeDTO contratoTypeDTO = new ContratoTypeDTO();
            contratoTypeDTO.setIdContrato(dealParam.getIdContrato());
            List filialesActuales = new ArrayList();
            filialesActuales = this.dealDAO.consultaDealFilialesByContrato(contratoFilialDTO);
            List filialesElegidas = new ArrayList();
            filialesElegidas = dealParam.getFilialesElegidos();
            for (FilialDTO filial : DealBO.safeList(filialesActuales)) {
                if (filial == null) continue;
                contratoFilialDTO.setIdFilial(filial.getIdFilial());
                this.dealDAO.eliminaContratoFilialRelacion(contratoFilialDTO);
            }
            for (FilialDTO filial : DealBO.safeList(filialesElegidas)) {
                if (filial == null) continue;
                contratoFilialDTO.setIdFilial(filial.getIdFilial());
                this.dealDAO.creaContratoFilialRelacion(contratoFilialDTO);
            }
            List typesActuales = new ArrayList();
            typesActuales = this.dealDAO.consultaDealTypesByContrato(contratoTypeDTO);
            List typesElegidas = new ArrayList();
            typesElegidas = dealParam.getTypesElegidos();
            for (TypeDTO type : DealBO.safeList(typesActuales)) {
                if (type == null) continue;
                contratoTypeDTO.setIdType(type.getIdType());
                this.dealDAO.eliminaContratoTypeRelacion(contratoTypeDTO);
            }
            for (TypeDTO type : DealBO.safeList(typesElegidas)) {
                if (type == null) continue;
                contratoTypeDTO.setIdType(type.getIdType());
                this.dealDAO.creaContratoTypeRelacion(contratoTypeDTO);
            }
        }
    }

    public static <T> List<T> safeList(List<T> other) {
        return other == null ? Collections.EMPTY_LIST : other;
    }
}

