/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.fees.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesTransaccionUtileria;
import com.mx.dla.dda.contrato.transaccion.fees.daos.FeesTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTImpuestoDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinValoresDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinimoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeesGuardarTransaccioBO
extends BaseBO {
    @Autowired
    private FeesTransaccionDAO dao;

    public void guardarDatosMinimos(String[][] datos, String[] anios, Long[] idCat, Boolean isCategoria, Boolean isAnnio, Long idContrato, String seccion) throws TransaccionException {
        try {
            ArrayList<FeesTMinValoresDTO> valoresMinimos = new ArrayList<FeesTMinValoresDTO>();
            if (isCategoria != null && isCategoria.booleanValue()) {
                if (idCat != null) {
                    this.dao.eliminarValorAnnioMinTrans(idContrato, seccion);
                    for (int j = 0; j < idCat.length; ++j) {
                        FeesTMinimoDTO catMin = null;
                        if (idCat[j] == 0L) {
                            catMin = FeesTransaccionUtileria.generearMinimoDTO(datos[j][0], datos[j][1], datos[j][2], seccion, 0, null);
                            catMin.setRevenue("0");
                            this.dao.guardarCatMinTrans(catMin, idContrato);
                        } else {
                            catMin = FeesTransaccionUtileria.generearMinimoDTO(datos[j][0], datos[j][1], datos[j][2], seccion, 0, idCat[j]);
                            catMin.setRevenue("0");
                            this.dao.editarCatMinTrans(catMin);
                        }
                        for (int i = 3; i < datos[0].length; ++i) {
                            FeesTMinValoresDTO valor = FeesTransaccionUtileria.generearValorMinimoDTO(anios[i - 3], catMin.getIdCategoria(), datos[j][i], null);
                            valoresMinimos.add(valor);
                        }
                    }
                    this.dao.eliminarValorCatMinTrans(idContrato, seccion);
                    this.dao.guardarValoresCatMin(valoresMinimos);
                }
            } else if (isAnnio != null && isAnnio.booleanValue()) {
                this.dao.eliminarValorCatMinTrans(idContrato, seccion);
                this.dao.eliminarCatMinTrans(idContrato, seccion);
                for (int i = 0; i < datos[0].length; ++i) {
                    FeesTMinValoresDTO valor = FeesTransaccionUtileria.generearValorMinimoDTO(anios[i], null, datos[0][i], seccion);
                    valoresMinimos.add(valor);
                }
                this.dao.eliminarValorAnnioMinTrans(idContrato, seccion);
                this.dao.guardarValoresAnnioMin(valoresMinimos, idContrato);
            }
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }

    public void guardarDatosImpuesto(String[][] datos, Long idContrato, String seccion, List<FeesTImpuestoDTO> paises) throws TransaccionException {
        try {
            this.dao.eliminarValoresImpuesto(idContrato, seccion);
            ArrayList<FeesTImpuestoDTO> impuestos = new ArrayList<FeesTImpuestoDTO>();
            for (int i = 1; i <= paises.size(); ++i) {
                FeesTImpuestoDTO impuesto = null;
                impuesto = FeesTransaccionUtileria.generearFeesTImpuestoDTO(paises.get(i - 1).getIdPais(), datos[1][i], datos[2][i], seccion);
                impuestos.add(impuesto);
            }
            this.dao.guardarValoresImpuesto(impuestos, idContrato);
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }

    public Integer obtenerNumAnios(String fechaInicio, String fechaFin) {
        Integer num = null;
        int anioI = Integer.parseInt(fechaInicio.split("/")[2]);
        int anioF = Integer.parseInt(fechaFin.split("/")[2]);
        num = anioF - anioI + 1;
        return num;
    }
}

