/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsCategoriaMGDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoCatDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoTipos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoMinimoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminosMinimos
extends BaseBO {
    @Autowired
    private TerminosTransaccionDAO dao;
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    private String[] anios;
    private String[][] revenue;
    private List<FsCategoriaMGDTO> categoriasMg;
    private Long idSeccion;

    public MinimoGarantizadoDTO obtenerMinimos(Long idContrato, String seccion) {
        MinimoGarantizadoDTO minimo = new MinimoGarantizadoDTO();
        String[][] periodos = null;
        String[][] categorias = null;
        String tipoMin = "";
        String fechaInicio = this.feesContratoDAO.fechaInicio(idContrato);
        String fechaFin = this.feesContratoDAO.fechaFin(idContrato);
        boolean na = this.obtenerMinimosNA(idContrato, seccion);
        if (!na && (periodos = this.obtenerMinimosPeriodo(idContrato, seccion)) == null) {
            categorias = this.obtenerMinimosCategoria(idContrato, seccion);
        }
        if (!na && periodos == null && categorias != null) {
            periodos = new String[1][3];
            periodos[0][0] = null;
            periodos[0][1] = null;
            periodos[0][2] = null;
            tipoMin = "categoria";
        } else if (!na && periodos != null && categorias == null) {
            categorias = new String[1][4];
            categorias[0][0] = null;
            categorias[0][1] = null;
            categorias[0][2] = "MFTV/MFV";
            categorias[0][3] = null;
            this.anios = new String[1];
            this.anios[0] = fechaInicio + "-" + fechaFin;
            tipoMin = "anio";
        }
        if (periodos == null && categorias == null) {
            this.logger.debug("inicio");
            na = true;
            tipoMin = "na";
            periodos = new String[1][3];
            periodos[0][0] = null;
            periodos[0][1] = null;
            periodos[0][2] = null;
            categorias = new String[1][4];
            categorias[0][0] = null;
            categorias[0][1] = null;
            categorias[0][2] = "MFTV/MFV";
            categorias[0][3] = null;
            this.anios = new String[1];
            this.anios[0] = fechaInicio + "-" + fechaFin;
        }
        minimo.setAnios(this.anios);
        minimo.setMinimosCateg(categorias);
        minimo.setMinimosAnio(periodos);
        minimo.setNa(Boolean.valueOf(na));
        minimo.setTipoMin(tipoMin);
        this.logger.debug("" + minimo.toString());
        return minimo;
    }

    public boolean obtenerMinimosNA(Long idContrato, String seccion) {
        Integer result = this.dao.obtenerMinimosNA(idContrato, seccion);
        return result != null && result > 0;
    }

    public String[][] obtenerMinimosPeriodo(Long idContrato, String seccion) {
        List minimos = this.dao.obtenerMinimosPeriodo(idContrato, seccion);
        String[][] datos = null;
        if (minimos != null && !minimos.isEmpty()) {
            datos = new String[minimos.size()][3];
            int fila = 0;
            for (TerminoMinimoDTO m : minimos) {
                datos[fila][0] = m.getFechaInicio() + "-" + m.getFechaFin();
                datos[fila][1] = String.valueOf(m.getMinimo());
                datos[fila][2] = String.valueOf(m.getAplicaMG());
                ++fila;
            }
        }
        return datos;
    }

    public String[][] obtenerMinimosCategoria(Long idContrato, String seccion) {
        List minimos = this.dao.obtenerMinimosCategoria(idContrato, seccion);
        List periodos = this.dao.obtenerMinPeriodosCategoria(idContrato, seccion);
        List<String> categorias = this.dao.obtenerMinCatsCategoria(idContrato, seccion);
        String[][] datos = null;
        if (minimos != null && !minimos.isEmpty()) {
            categorias = this.removeRepetidas(categorias);
            datos = new String[categorias.size()][periodos.size() + 3];
            this.anios = new String[periodos.size()];
            int fila = 0;
            for (String categoria : categorias) {
                List<TerminoMinimoDTO> minCat = this.obtenerCategoria(categoria, minimos);
                for (TerminoMinimoDTO m : minCat) {
                    datos[fila][0] = String.valueOf(m.getDesde());
                    datos[fila][1] = String.valueOf(m.getHasta());
                    datos[fila][2] = String.valueOf(m.getCategoria());
                    int columna = 0;
                    for (int i = 0; i < periodos.size(); ++i) {
                        if (!((String)periodos.get(i)).equals(m.getFechaInicio())) continue;
                        columna = i + 3;
                        if (fila != 0) continue;
                        this.anios[i] = m.getFechaInicio() + "-" + m.getFechaFin();
                    }
                    datos[fila][columna] = String.valueOf(m.getMinimo());
                }
                ++fila;
            }
        }
        return datos;
    }

    public List<String> removeRepetidas(List<String> categorias) {
        ArrayList<String> cats = new ArrayList<String>();
        cats.add(categorias.get(0));
        for (int i = 1; i < categorias.size(); ++i) {
            boolean encontrado = false;
            for (int j = 0; j < cats.size(); ++j) {
                if (!((String)cats.get(j)).equals(categorias.get(i))) continue;
                encontrado = true;
            }
            if (encontrado) continue;
            cats.add(categorias.get(i));
        }
        return cats;
    }

    public List<TerminoMinimoDTO> obtenerCategoria(String Categoria, List<TerminoMinimoDTO> minimos) {
        ArrayList<TerminoMinimoDTO> cats = new ArrayList<TerminoMinimoDTO>();
        for (TerminoMinimoDTO m : minimos) {
            if (m.getCategoria().compareTo(Categoria) != 0) continue;
            cats.add(m);
        }
        return cats;
    }

    public void guardarMinimos(String[][] minimosCat, String[][] minimosAnio, String[] anios, String tipo, String seccion, Long idContrato) {
        block5: {
            FsSeccionDTO seccionTab;
            block6: {
                int i;
                block4: {
                    seccionTab = new FsSeccionDTO();
                    seccionTab.setSeccion(seccion);
                    seccionTab.setIdContrato(idContrato);
                    this.eliminarMinimos(idContrato, seccion);
                    if (tipo.compareTo("na") != 0) break block4;
                    seccionTab.setTipoMinimo("NA");
                    this.dao.guardarSeccionMinimo(seccionTab);
                    this.idSeccion = seccionTab.getIdSeccion();
                    break block5;
                }
                if (tipo.compareTo("categoria") != 0) break block6;
                this.categoriasMg = new ArrayList<FsCategoriaMGDTO>();
                ArrayList<FsPeriodoDTO> periodos = new ArrayList<FsPeriodoDTO>();
                seccionTab.setTipoMinimo("CATEGORIA");
                this.dao.guardarSeccionMinimo(seccionTab);
                this.idSeccion = seccionTab.getIdSeccion();
                for (i = 0; i < anios.length; ++i) {
                    String[] splitRes = anios[i].split("-");
                    this.logger.debug("" + splitRes.length);
                    FsPeriodoDTO periodo = new FsPeriodoDTO();
                    periodo.setIdContrato(idContrato);
                    periodo.setIdSeccion(seccionTab.getIdSeccion());
                    periodo.setFechaInicio(splitRes[0]);
                    periodo.setFechaFin(splitRes[1]);
                    periodo.setTipo("MINIMO");
                    this.dao.guardarPeridoMinimos(periodo);
                    periodos.add(periodo);
                }
                for (i = 0; i < minimosCat.length; ++i) {
                    FsCategoriaMGDTO categoria = new FsCategoriaMGDTO();
                    categoria.setDesde(Double.valueOf(minimosCat[i][0] != null ? Double.parseDouble(minimosCat[i][0]) : 0.0));
                    categoria.setHasta(Double.valueOf(minimosCat[i][1] != null ? Double.parseDouble(minimosCat[i][1]) : 0.0));
                    categoria.setCategoriaMg(minimosCat[i][2]);
                    categoria.setIdContrato(idContrato);
                    categoria.setIdSeccion(seccionTab.getIdSeccion());
                    this.dao.guardarCategoriaMinimos(categoria);
                    this.categoriasMg.add(categoria);
                    FsPeriodoCatDTO perCat = new FsPeriodoCatDTO();
                    for (int j = 0; j < anios.length; ++j) {
                        perCat.setIdFsCategoriaMG(categoria.getIdFsCategoriaMG());
                        perCat.setIdPeriodo(((FsPeriodoDTO)periodos.get(j)).getIdPeriodo());
                        perCat.setMinimo(Double.valueOf(Double.parseDouble(minimosCat[i][j + 3])));
                        this.dao.guardarPerCategaMinimos(perCat);
                    }
                }
                break block5;
            }
            if (tipo.compareTo("anio") != 0) break block5;
            seccionTab.setTipoMinimo("PERIODO");
            this.dao.guardarSeccionMinimo(seccionTab);
            this.idSeccion = seccionTab.getIdSeccion();
            for (int i = 0; i < minimosAnio.length; ++i) {
                FsPeriodoDTO periodo = new FsPeriodoDTO();
                periodo.setIdContrato(idContrato);
                periodo.setIdSeccion(seccionTab.getIdSeccion());
                periodo.setFechaInicio(minimosAnio[i][0].split("-")[0]);
                periodo.setFechaFin(minimosAnio[i][0].split("-")[1]);
                periodo.setAplicaMG(minimosAnio[i][2]);
                periodo.setMinimo(Double.valueOf(Double.parseDouble(minimosAnio[i][1])));
                periodo.setTipo("MINIMO");
                this.dao.guardarPeridoMinimos(periodo);
            }
        }
    }

    public void eliminarMinimos(Long idContrato, String seccion) {
        this.dao.eliminarRelease(idContrato, seccion);
        this.dao.eliminarPerCategaMinimos(idContrato, seccion);
        this.dao.eliminarPeridoMinimos(idContrato, seccion);
        this.dao.eliminarCategoriaMinimos(idContrato, seccion);
        this.dao.eliminarSeccionMinimo(idContrato, seccion);
    }

    public String obtenerTipoMinimo(Long idContrato, String seccion) {
        String tipo = this.dao.obtenerTipoMinimo(idContrato, seccion);
        return tipo == null ? MinimoTipos.NA.getDesc() : tipo;
    }

    public String[] getAnios() {
        return this.anios;
    }

    public String[][] getRevenue() {
        return this.revenue;
    }

    public List<FsCategoriaMGDTO> getCategorias() {
        return this.categoriasMg;
    }

    public Long getIdSeccion() {
        return this.idSeccion;
    }
}

