/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoMinimoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminosRelease
extends BaseBO {
    @Autowired
    private TerminosTransaccionDAO dao;
    private List<Long> ids;

    public String[][] obtenerRelease(Long idContrato, String seccion) {
        List valores = this.dao.obtenerRelease(idContrato, seccion);
        String[][] datos = new String[][]{{null, null, null}};
        if (valores != null && !valores.isEmpty()) {
            datos = new String[valores.size()][3];
            for (int i = 0; i < valores.size(); ++i) {
                datos[i][0] = String.valueOf(((TerminoMinimoDTO)valores.get(i)).getDesde());
                datos[i][1] = String.valueOf(((TerminoMinimoDTO)valores.get(i)).getHasta());
                datos[i][2] = String.valueOf(((TerminoMinimoDTO)valores.get(i)).getCategoria());
            }
        }
        return datos;
    }

    public void guardarRelease(String[][] datos, Long idContrato, String seccion) throws TransaccionException {
        try {
            this.logger.debug("release");
            this.ids = new ArrayList<Long>();
            long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
            this.logger.debug("" + idSeccion);
            for (int i = 0; i < datos.length; ++i) {
                TerminoMinimoDTO release = this.generearMinimoDTO(datos[i][0], datos[i][1], datos[i][2]);
                this.dao.guardarValoresRelease(release, idContrato, Long.valueOf(idSeccion));
                this.ids.add(release.getId());
            }
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }

    public TerminoMinimoDTO generearMinimoDTO(String desde, String hasta, String categoria) {
        TerminoMinimoDTO min = new TerminoMinimoDTO();
        if (desde != null) {
            min.setDesde(Double.valueOf(Double.parseDouble(desde)));
        }
        if (hasta != null) {
            min.setHasta(Double.valueOf(Double.parseDouble(hasta)));
        }
        min.setCategoria(categoria);
        return min;
    }

    public Long[] getIds() {
        Long[] idsA = new Long[this.ids.size()];
        if (this.ids != null) {
            for (int i = 0; i < this.ids.size(); ++i) {
                idsA[i] = (long)this.ids.get(i);
            }
        }
        return idsA;
    }
}

