/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.ncredito.listado.bos;

import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.ncredito.general.daos.NotaCreditoDAO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.general.dtos.NotaCredito;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotaCreditoListadoBO
extends BaseBO {
    @Autowired
    private NotaCreditoDAO notaCreditoDAO;
    @Autowired
    private CatalogoEstudiosDAO estudiosDAO;

    public List<ContratoNotaCreditoGeneralDTO> getListadoNotasCredito(List<Long> estudios, String numeroFactura) {
        ArrayList<ContratoNotaCreditoGeneralDTO> listado = new ArrayList<ContratoNotaCreditoGeneralDTO>();
        if (numeroFactura != null) {
            numeroFactura = numeroFactura + "%";
        }
        this.logger.debug("num:" + numeroFactura);
        List listadoBd = this.notaCreditoDAO.consultaNotaCreditoGeneral(null, estudios, numeroFactura);
        for (NotaCredito item : listadoBd) {
            CatalogoEstudioDTO estudio = new CatalogoEstudioDTO();
            estudio = this.estudiosDAO.catalogoEstudiosPorId(item.getIdEstudio().intValue());
            ContratoNotaCreditoGeneralDTO pantalla = new ContratoNotaCreditoGeneralDTO();
            pantalla.setApproved(item.getApproved());
            pantalla.setComentario(item.getComentario());
            pantalla.setDescEstudio(estudio.getDescripcionEstudio());
            pantalla.setFechaFactura(item.getFecha());
            pantalla.setIdEstudio(item.getIdEstudio());
            pantalla.setIdNota(item.getIdNota());
            pantalla.setIdSapRegistro(item.getIdSapRegistro());
            pantalla.setNumeroFactura(item.getNoFactura());
            listado.add(pantalla);
        }
        return listado;
    }

    public void eliminarNotaCredito(Long idNota) {
        NotaCredito nota = new NotaCredito();
        nota.setIdNota(idNota);
        this.notaCreditoDAO.eliminarNotaCreditoDetalle(nota);
        this.notaCreditoDAO.eliminarNotaCredito(nota);
    }
}

