/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.oyp.bos;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.general.constants.MesesAnio;
import com.mx.dla.dda.general.utilerias.FechaUtilerias;
import com.mx.dla.dda.reporte.acumulateBuys.dao.ReporteAcumulateBuysDAO;
import com.mx.dla.dda.reporte.acumulateBuys.dto.acumulateBuysEstudiosDTO;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;
import com.mx.dla.dda.reporte.general.dtos.CeldaBaseDTO;
import com.mx.dla.dda.reporte.general.dtos.ExcelEstilosConfDTO;
import com.mx.dla.dda.reporte.general.dtos.RangoExcelEstiloDTO;
import com.mx.dla.dda.reporte.oyp.daos.ReporteOveragesYPaymentsDAO;
import com.mx.dla.dda.reporte.oyp.dtos.ReporteOveragesYPaymentsVistaDTO;
import com.mx.dla.dda.reporte.reportecfg.daos.ReporteConfiguracionDAO;
import com.mx.dla.dda.reportes.ExcelGeneratorProcess.bos.ExcelGeneratorProcessBO;
import com.mx.dla.dda.reportes.generaxml.ExcelXmlConfiguracionWriter;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteOveragesYPaymentsBO
extends BaseBO {
    @Autowired
    private ReporteOveragesYPaymentsDAO reporteOveragesYPaymentsDAO;
    @Autowired
    private ReporteConfiguracionDAO reporteConfiguracionDAO;
    @Autowired
    private ReporteAcumulateBuysDAO reporteAcumulateBuysDAO;
    @Autowired
    private ExcelGeneratorProcessBO excelGeneratorProcessBO;
    @Autowired
    private ExcelXmlConfiguracionWriter excelXmlConfiguracionWriter;

    public List<LinkedHashMap<String, Object>> obtenReporteTabla(Long mesInicial, Long anioInicial, Long mesFinal, Long anioFinal, Long idEstudio, String tipoPago, String validaEstatusCarga) throws ParseException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.logger.info("obtenReporteTabla");
        String sumatorias_mensuales = "";
        String meses_seleccionados = "";
        String meses_pivote = "";
        ArrayList<String> columnas = new ArrayList<String>();
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        beginCalendar.setTime(formater.parse(mesInicial + "/" + anioInicial));
        finishCalendar.setTime(formater.parse(mesFinal + "/" + anioFinal));
        Integer index = 1;
        while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
            String month = StringUtils.leftPad((String)String.valueOf(beginCalendar.get(2) + 1), (int)2, (String)"0");
            String year = String.valueOf(beginCalendar.get(1));
            sumatorias_mensuales = sumatorias_mensuales + "NVL(SUM(MES_" + index + "), 0) as M" + index + ",";
            meses_seleccionados = meses_seleccionados + "NVL( MES_" + index + ", 0 ) as MES_" + index + ",";
            meses_pivote = meses_pivote + "'" + month + year + "' as MES_" + index + ",";
            columnas.add("M" + index);
            beginCalendar.add(2, 1);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        List tabla = this.reporteOveragesYPaymentsDAO.obtenerOveragesYPayments(mesInicial, anioInicial, mesFinal, anioFinal, idEstudio, tipoPago, sumatorias_mensuales = sumatorias_mensuales.substring(0, sumatorias_mensuales.length() - 1), meses_seleccionados = meses_seleccionados.substring(0, meses_seleccionados.length() - 1), meses_pivote = meses_pivote.substring(0, meses_pivote.length() - 1), validaEstatusCarga);
        if (tabla != null && !tabla.isEmpty()) {
            columnas.addAll(Arrays.asList("SPLIT", "MAX", "OVERAGE"));
            LinkedList tmp = new LinkedList(tabla);
            LinkedHashMap template = (LinkedHashMap)tmp.getFirst();
            LinkedHashMap total = new LinkedHashMap();
            for (Map.Entry item : template.entrySet()) {
                if (item.getValue() instanceof String) {
                    total.put(item.getKey(), new String());
                    continue;
                }
                total.put(item.getKey(), null);
            }
            for (String columna : columnas) {
                Double valor = new Double(0.0);
                for (LinkedHashMap item : tabla) {
                    if (((BigDecimal)item.get("ORDEN")).intValue() >= 2) continue;
                    valor = valor + ((BigDecimal)item.get(columna)).doubleValue();
                }
                total.put(columna, new BigDecimal(valor.toString()));
            }
            total.put("ASSET_NAME", "Total general");
            tabla.add(total);
        }
        return tabla == null || tabla.isEmpty() ? null : tabla;
    }

    public ReporteOveragesYPaymentsVistaDTO obtenerReporteOveragesYPaymentsVista(String fechaInicial, String fechaFinal, String tipoPago, String claveReporte, Long idEstudio, String validaEstatusCarga) throws ParseException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ReporteOveragesYPaymentsVistaDTO reporte = new ReporteOveragesYPaymentsVistaDTO();
        HashMap fechaInicialSplit = FechaUtilerias.getFechaValores((String)fechaInicial, (String)"MM/yyyy");
        Long mesInicial = (Long)fechaInicialSplit.get("Month");
        Long anioInicial = (Long)fechaInicialSplit.get("Year");
        HashMap fechaFinalSplit = FechaUtilerias.getFechaValores((String)fechaFinal, (String)"MM/yyyy");
        Long mesFinal = (Long)fechaFinalSplit.get("Month");
        Long anioFinal = (Long)fechaFinalSplit.get("Year");
        List<LinkedHashMap<String, Object>> tabla = this.obtenReporteTabla(mesInicial, anioInicial, mesFinal, anioFinal, idEstudio, tipoPago, validaEstatusCarga);
        this.logger.info("{}", tabla);
        if (tabla != null) {
            reporte.setTabla(this.transform(tabla));
        }
        List columnCfg = this.reporteConfiguracionDAO.obtenerReporteConfiguracion(claveReporte, idEstudio);
        ArrayList<String> output = new ArrayList<String>();
        for (LinkedHashMap item : columnCfg) {
            output.add(item.get("COLUMNA").toString());
        }
        reporte.setColumnCfg(output);
        reporte.setHeader(this.transform(this.obtenReporteHeaders(mesInicial, anioInicial, mesFinal, anioFinal)));
        this.logger.info("{}", (Object)reporte.getHeader());
        return reporte;
    }

    public List<LinkedHashMap<String, Object>> obtenReporteHeaders(Long mesInicial, Long anioInicial, Long mesFinal, Long anioFinal) throws ParseException {
        ArrayList<LinkedHashMap<String, Object>> headers = new ArrayList<LinkedHashMap<String, Object>>();
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("ORDEN", "Orden");
        header.put("TYPE_PAGO", "Tipo Pago");
        header.put("NUMERO_CONTRATO", "Numero Contrato");
        header.put("ASSET_NAME", "Asset Name");
        header.put("MG", "MG");
        header.put("CLASS", "Class");
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        beginCalendar.setTime(formater.parse(mesInicial + "/" + anioInicial));
        finishCalendar.setTime(formater.parse(mesFinal + "/" + anioFinal));
        Integer index = 0;
        while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
            String month = MesesAnio.parse((String)("" + (beginCalendar.get(2) + 1))).getShortDesc();
            String year = String.valueOf(beginCalendar.get(1));
            header.put("M" + (index + 1), month + " - " + year);
            beginCalendar.add(2, 1);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        header.put("SPLIT", "SPLIT");
        header.put("MAX", "MAX");
        header.put("OVERAGE", "OVERAGE");
        this.logger.info("{}", header);
        headers.add(header);
        return headers;
    }

    public ArrayList<ArrayList<CeldaBaseDTO>> transform(List<LinkedHashMap<String, Object>> input) {
        ArrayList<ArrayList<CeldaBaseDTO>> output = new ArrayList<ArrayList<CeldaBaseDTO>>();
        for (LinkedHashMap<String, Object> item : input) {
            output.add(this.transform(item));
        }
        return output;
    }

    public ArrayList<CeldaBaseDTO> transform(LinkedHashMap<String, Object> input) {
        ArrayList<CeldaBaseDTO> output = new ArrayList<CeldaBaseDTO>();
        Iterator<Map.Entry<String, Object>> iterator = input.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            CeldaBaseDTO item = new CeldaBaseDTO(entry.getKey(), null, (entry = iterator.next()).getValue() == null ? null : entry.getValue().toString());
            output.add(item);
        }
        return output;
    }

    public List<EstudioDTO> obtenerEstudios() {
        ArrayList<EstudioDTO> estudios = new ArrayList<EstudioDTO>();
        List estudiosOrigen = this.reporteAcumulateBuysDAO.obtenerEstudios();
        for (acumulateBuysEstudiosDTO item : estudiosOrigen) {
            EstudioDTO estudio = new EstudioDTO();
            estudio.setIdEstudio(item.getId_estudio() == null ? null : new Long(item.getId_estudio()));
            estudio.setDescripcionEstudio(item.getDesc_estudio());
            estudios.add(estudio);
        }
        return estudios;
    }

    public InputStream obtenerStreamReporte(String fechaInicial, String fechaFinal, String tipoPago, String claveReporte, Long idEstudio, String usuario, String validaEstatusCarga) throws IllegalArgumentException, IllegalAccessException, ParseException, ExcelMapperException, IOException, ReportCostPerViewException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException, XMLStreamException {
        HashMap fechaInicialSplit = FechaUtilerias.getFechaValores((String)fechaInicial, (String)"MM/yyyy");
        Long mesInicial = (Long)fechaInicialSplit.get("Month");
        Long anioInicial = (Long)fechaInicialSplit.get("Year");
        HashMap fechaFinalSplit = FechaUtilerias.getFechaValores((String)fechaFinal, (String)"MM/yyyy");
        Long mesFinal = (Long)fechaFinalSplit.get("Month");
        Long anioFinal = (Long)fechaFinalSplit.get("Year");
        List<LinkedHashMap<String, Object>> header = this.obtenReporteHeaders(mesInicial, anioInicial, mesFinal, anioFinal);
        List<LinkedHashMap<String, Object>> tabla = this.obtenReporteTabla(mesInicial, anioInicial, mesFinal, anioFinal, idEstudio, tipoPago, validaEstatusCarga);
        String fileFileName = usuario + "-" + mesInicial + anioInicial + mesFinal + anioFinal + "-reporteCYP";
        this.logger.info("{}", (Object)fileFileName);
        String[] rcolumnasnew = new String[]{"ORDEN", "TYPE_PAGO", "NUMERO_CONTRATO"};
        header = this.remove(header, rcolumnasnew);
        tabla = this.remove(tabla, rcolumnasnew);
        List<ExcelEstilosConfDTO> estilos = this.obtenExcelEstilos(header, tabla);
        this.excelXmlConfiguracionWriter.writeToXml(fileFileName + ".xml", header, tabla, estilos, "Reporte Overages y Payments");
        this.logger.info("generaXML");
        return this.excelGeneratorProcessBO.generaExcelProceso(fileFileName + ".xml", fileFileName + ".xlxs");
    }

    public List<LinkedHashMap<String, Object>> remove(List<LinkedHashMap<String, Object>> input, String[] columnsToRemove) {
        for (LinkedHashMap<String, Object> item : input) {
            for (String columna : columnsToRemove) {
                item.remove(columna);
            }
        }
        return input;
    }

    private List<ExcelEstilosConfDTO> obtenExcelEstilos(List<LinkedHashMap<String, Object>> header, List<LinkedHashMap<String, Object>> tabla) {
        ArrayList<RangoExcelEstiloDTO> rheader = new ArrayList<RangoExcelEstiloDTO>();
        rheader.add(new RangoExcelEstiloDTO(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(0L), Long.valueOf(new Integer(tabla.get(0).keySet().size() + 1).longValue())));
        ArrayList<RangoExcelEstiloDTO> rCifras = new ArrayList<RangoExcelEstiloDTO>();
        rCifras.add(new RangoExcelEstiloDTO(Long.valueOf(1L), Long.valueOf(new Integer(tabla.size() + 1).longValue()), Long.valueOf(3L), Long.valueOf(new Integer(tabla.get(0).keySet().size() + 1).longValue())));
        rCifras.add(new RangoExcelEstiloDTO(Long.valueOf(1L), Long.valueOf(new Integer(tabla.size() + 1).longValue()), Long.valueOf(1L), Long.valueOf(2L)));
        ArrayList<RangoExcelEstiloDTO> rTextos = new ArrayList<RangoExcelEstiloDTO>();
        rTextos.add(new RangoExcelEstiloDTO(Long.valueOf(1L), Long.valueOf(new Integer(tabla.size() + 1).longValue()), Long.valueOf(0L), Long.valueOf(1L)));
        ArrayList<RangoExcelEstiloDTO> rNormal = new ArrayList<RangoExcelEstiloDTO>();
        rNormal.add(new RangoExcelEstiloDTO(Long.valueOf(1L), Long.valueOf(new Integer(tabla.size() + 1).longValue()), Long.valueOf(2L), Long.valueOf(3L)));
        ArrayList<ExcelEstilosConfDTO> estilos = new ArrayList<ExcelEstilosConfDTO>();
        estilos.add(new ExcelEstilosConfDTO(String.valueOf(0), String.valueOf(0), String.valueOf(1), String.valueOf(1), "left", null, "celda_encabezado_general", null, null, "string", rheader));
        estilos.add(new ExcelEstilosConfDTO(String.valueOf(0), String.valueOf(0), String.valueOf(1), String.valueOf(1), "right", null, "celda_normal", null, null, "decimal2", rCifras));
        estilos.add(new ExcelEstilosConfDTO(String.valueOf(150), String.valueOf(0), String.valueOf(1), String.valueOf(1), "left", null, "celda_normal", null, null, "string", rTextos));
        estilos.add(new ExcelEstilosConfDTO(String.valueOf(0), String.valueOf(0), String.valueOf(1), String.valueOf(1), "left", null, "celda_normal", null, null, "string", rNormal));
        return estilos;
    }
}

