/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.admin.usuarios.perfil.bos;

import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.admin.usuarios.perfil.daos.UsuarioPerfilDAO;
import com.mx.dla.global.bos.BaseBO;
import java.security.MessageDigest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuarioPerfilBO
extends BaseBO {
    @Autowired
    private UsuarioDAO usuarioDAO;
    @Autowired
    private UsuarioPerfilDAO usuarioPerfilDAO;

    public UsuarioDTO obtenerUsuario(String expediente) {
        UsuarioDTO usuario = null;
        try {
            usuario = this.usuarioDAO.obtenerUsuario(expediente);
        }
        catch (Exception ex) {
            this.logger.debug("Exception : [{}]", (Throwable)ex);
        }
        return usuario;
    }

    public boolean actulizaPropiedadUsuario(String expediente, String correo, String contrasena, String operacion) {
        if (operacion.equals("correo")) {
            return this.actualizaCorreo(expediente, correo);
        }
        return this.actualizaContrasena(expediente, contrasena);
    }

    public boolean actualizaCorreo(String expediente, String correo) {
        boolean exito = false;
        try {
            this.logger.debug("correo : [{}], expediente: [{}]", (Object)correo, (Object)expediente);
            this.usuarioPerfilDAO.actualizaCorreo(expediente, correo);
            exito = true;
        }
        catch (Exception ex) {
            this.logger.debug("Exception : [{}]", (Throwable)ex);
        }
        return exito;
    }

    public boolean actualizaContrasena(String expediente, String contrasena) {
        boolean exito = false;
        String hexaRepre = null;
        try {
            hexaRepre = this.md5Hashing(contrasena);
            this.logger.debug("contrasena hexa : [{}]", (Object)hexaRepre);
            this.usuarioPerfilDAO.actualizaContrasena(expediente, hexaRepre);
            exito = true;
        }
        catch (Exception ex) {
            this.logger.debug("Exception : [{}]", (Throwable)ex);
        }
        return exito;
    }

    public String md5Hashing(String password) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(password.getBytes());
        byte[] dataBytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dataBytes.length; ++i) {
            sb.append(Integer.toString((dataBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

