/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.ncredito.general.bos;

import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoDetalleDTO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NCreditoConvertidordDto2Rest
extends BaseBO {
    @Value(value="${factura.header.sociedad}")
    protected String sociedad;
    @Value(value="${factura.header.indicador}")
    protected String indicador;
    @Value(value="${notaCredito.header.tipoDocumento}")
    protected String tipoDocumento;
    @Value(value="${factura.header.moneda}")
    protected String moneda;
    @Value(value="${factura.detalle.impuesto}")
    protected String impuesto;
    @Value(value="${factura.detalle.cantidad}")
    protected String cantidad;
    @Value(value="${envMov.indEntregaFinal}")
    protected String indEntregaFinal;
    @Value(value="${envMov.indFacturaFinal}")
    protected String indFacturaFinal;
    @Value(value="${envMov.noItem}")
    protected String noItem;
    @Value(value="${notaCredito.detalle.isoMedida}")
    protected String isoMedida;

    public DTNotaCredito generaFacturaWS(ContratoNotaCreditoGeneralDTO facturaDTO) {
        DTNotaCredito message = new DTNotaCredito();
        DTNotaCredito.Registro factura = this.generaRegistro(facturaDTO);
        Double totalMonto = 0.0;
        List<DTNotaCredito.Registro.Item> items = this.generaItems(facturaDTO.getContratos());
        for (DTNotaCredito.Registro.Item item : items) {
            totalMonto = totalMonto + new Double(item.getImporte());
        }
        factura.setMonto(totalMonto.toString());
        factura.setItem(items);
        message.setRegistro(factura);
        this.print(factura);
        return message;
    }

    public DTNotaCredito.Registro generaRegistro(ContratoNotaCreditoGeneralDTO facturaDTO) {
        SimpleDateFormat ft = new SimpleDateFormat("dd.MM.yyyy");
        DTNotaCredito.Registro factura = new DTNotaCredito.Registro();
        factura.setSociedad(this.sociedad);
        factura.setIndFactura("");
        factura.setTipoDoc(this.tipoDocumento);
        factura.setMoneda(this.moneda);
        factura.setTexto(facturaDTO.getComentario());
        factura.setMonto(facturaDTO.getMonto());
        factura.setReferencia(facturaDTO.getNumeroFactura());
        factura.setFechaNotaCred(ft.format(facturaDTO.getFechaFactura()));
        factura.setFechaContab(ft.format(new Date()));
        return factura;
    }

    public List<DTNotaCredito.Registro.Item> generaItems(List<ContratoNotaCreditoDetalleDTO> facturaDetalles) {
        ArrayList<DTNotaCredito.Registro.Item> pocisiones = new ArrayList<DTNotaCredito.Registro.Item>();
        Integer posicionNum = 10;
        for (ContratoNotaCreditoDetalleDTO item : facturaDetalles) {
            String posicionStr = "000" + posicionNum;
            DTNotaCredito.Registro.Item posicion = new DTNotaCredito.Registro.Item();
            posicion.setCantidad(this.cantidad);
            posicion.setImporte(item.getMonto());
            posicion.setIndImpuesto(item.getClaveIva());
            posicion.setPedido(item.getIdSap());
            posicion.setPosicionDoc(posicionStr);
            posicion.setPosicionPO(this.noItem);
            posicion.setUnidMedISO(this.isoMedida);
            pocisiones.add(posicion);
            posicionNum = posicionNum + 10;
        }
        return pocisiones;
    }

    public void print(DTNotaCredito.Registro registro) {
        this.logger.info("getSociedad: " + registro.getSociedad());
        this.logger.info("getFechaContab: " + registro.getFechaContab());
        this.logger.info("getFechaNotaCred: " + registro.getFechaNotaCred());
        this.logger.info("getIndFactura: " + registro.getIndFactura());
        this.logger.info("getMoneda: " + registro.getMoneda());
        this.logger.info("getMonto: " + registro.getMonto());
        this.logger.info("getReferencia: " + registro.getReferencia());
        this.logger.info("getTexto: " + registro.getTexto());
        this.logger.info("getTipoDoc: " + registro.getTipoDoc());
        this.logger.info("getItem: " + registro.getItem());
        this.logger.info("**Posiciones**");
        if (registro.getItem() != null) {
            for (DTNotaCredito.Registro.Item posicion : registro.getItem()) {
                this.logger.info("getCantidad: " + posicion.getCantidad());
                this.logger.info("getImporte: " + posicion.getImporte());
                this.logger.info("getIndImpuesto: " + posicion.getIndImpuesto());
                this.logger.info("getPedido: " + posicion.getPedido());
                this.logger.info("getPosicionPO: " + posicion.getPosicionPO());
                this.logger.info("getPosicionDoc: " + posicion.getPosicionDoc());
                this.logger.info("getUnidMedISO: " + posicion.getUnidMedISO());
            }
        }
    }
}

