/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.amortizacion.bos;

import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.reporte.amortizacion.daos.ReporteAmortizacionDAO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RegistroMontoDTO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RegistroRubroDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteAmortizacionBO
extends BaseBO {
    @Autowired
    private ReporteAmortizacionDAO reporteAmortizacionDAO;
    @Autowired
    private CatalogoEstudiosDAO catalogoEstudiosDAO;

    public List<RegistroRubroDTO> obtenListaMontosTotalesContratoPorEstudio(Long idEstudio, String fecha, Long mesesSearch) throws ParseException {
        ArrayList<RegistroRubroDTO> totalesPorContrato = new ArrayList<RegistroRubroDTO>();
        List montosContrato = this.reporteAmortizacionDAO.obtenMontosTotalesContrato(idEstudio, fecha, mesesSearch);
        HashMap contratosMonto = new HashMap();
        for (RegistroMontoDTO monto : montosContrato) {
            if (Objects.isNull(contratosMonto.get(monto.getIdContrato()))) {
                contratosMonto.put(monto.getIdContrato(), new ArrayList());
            }
            ((List)contratosMonto.get(monto.getIdContrato())).add(monto);
        }
        List<String> meses = this.getFechasAConsultar(fecha);
        for (Map.Entry contrato : contratosMonto.entrySet()) {
            List montos = (List)contrato.getValue();
            List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
            if (montos == null || montos.isEmpty()) continue;
            for (RegistroMontoDTO item : montos) {
                this.buscaRegistroMontoMes(list, item);
            }
            RegistroRubroDTO totalContrato = new RegistroRubroDTO();
            totalContrato.setId((Long)contrato.getKey());
            totalContrato.setDescripcion(((RegistroMontoDTO)montos.get(0)).getNumContrato());
            totalContrato.setMontoMes(list);
            totalContrato.setFechaFin(((RegistroMontoDTO)montos.get(0)).getFechaFin());
            totalContrato.setFechainicio(((RegistroMontoDTO)montos.get(0)).getFechaInicio());
            totalContrato.setCodigoSAP("-");
            totalContrato.setSistema("DDA");
            totalContrato.setIdBroadview("-");
            totalesPorContrato.add(totalContrato);
        }
        return totalesPorContrato;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudio(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudio(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        return totalesEstudio;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudioDLASAP(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudio(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        return totalesEstudio;
    }

    private void addMontoEstudio(RegistroRubroDTO princ, Map<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA, int place, Long idEstudio, String fecha, String sistema, Integer month) throws ParseException {
        if (Objects.nonNull(princ)) {
            RegistroRubroDTO ant = this.obtenMontosTotalesPorEstudio(idEstudio, fecha);
            RegistroRubroDTO sig = this.obtenMontosTotalesPorEstudioSAP(idEstudio, fecha);
            princ.setSistema(sistema);
            princ.setAcumuladoAnterior(Double.valueOf(0.0));
            princ.setAcumuladoPosterior(Double.valueOf(0.0));
            princ.setId(Long.valueOf(-1L));
            if (Objects.nonNull(ant)) {
                princ.setAcumuladoAnterior(((RegistroMontoDTO)ant.getMontoMes().get(12)).getMonto());
            }
            if (Objects.nonNull(sig)) {
                princ.setAcumuladoPosterior(((RegistroMontoDTO)sig.getMontoMes().get(12)).getMonto());
            }
            Double r1 = princ.getAcumuladoAnterior();
            Double r2 = princ.getAcumuladoPosterior();
            int mon = 1;
            for (RegistroMontoDTO mnt : princ.getMontoMes()) {
                if (mon <= month) {
                    r1 = r1 + mnt.getMonto();
                }
                if (mon > month && mon <= 12) {
                    r2 = r2 + mnt.getMonto();
                }
                ++mon;
            }
            princ.setRemanente(Double.valueOf(r1 - r2));
            princ.setIdBroadview("-");
            princ.setCodigoSAP("-");
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(place, princ);
        } else {
            RegistroRubroDTO emptyValue = new RegistroRubroDTO();
            List<String> meses = this.getFechasAConsultar(fecha);
            emptyValue.setMontoMes(this.obtenMontosMesesVacios(meses));
            emptyValue.setSistema(sistema);
            emptyValue.setCodigoSAP("-");
            emptyValue.setIdBroadview("-");
            emptyValue.setAcumuladoAnterior(Double.valueOf(0.0));
            emptyValue.setAcumuladoPosterior(Double.valueOf(0.0));
            emptyValue.setRemanente(Double.valueOf(0.0));
            totalesPorContratoSAPDLA.get(idEstudio.toString()).add(emptyValue);
        }
    }

    public Map<String, List<RegistroRubroDTO>> obtenListaMontosTotalesContratoPorEstudioDLASAP(Long idEstudio, String fecha, Integer year, Integer month) throws ParseException {
        RegistroRubroDTO totalesMontosEstudio = this.obtenMontosTotalesPorEstudio(idEstudio, fecha);
        RegistroRubroDTO totalesMontosEstudioSAP = this.obtenMontosTotalesPorEstudioSAP(idEstudio, fecha);
        LinkedHashMap<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA = new LinkedHashMap<String, List<RegistroRubroDTO>>();
        totalesPorContratoSAPDLA.put(idEstudio.toString(), new ArrayList());
        this.addMontoEstudio(totalesMontosEstudio, totalesPorContratoSAPDLA, 0, idEstudio, "01/" + (year - 1), "DDA", month);
        this.addMontoEstudio(totalesMontosEstudioSAP, totalesPorContratoSAPDLA, 0, idEstudio, "01/" + (year + 1), "SAP", month);
        totalesPorContratoSAPDLA.putAll(this.getListResult(idEstudio, fecha));
        Map<String, List<RegistroRubroDTO>> totalesPorContratoAnioAnterior = this.getListResult(idEstudio, "01/" + (year - 1));
        Map<String, List<RegistroRubroDTO>> totalesPorContratoAnioSiguiente = this.getListResult(idEstudio, "01/" + (year + 1));
        for (Map.Entry total : totalesPorContratoSAPDLA.entrySet()) {
            if (((List)total.getValue()).size() < 2) {
                RegistroRubroDTO emptyValue = new RegistroRubroDTO();
                List<String> meses = this.getFechasAConsultar(fecha);
                emptyValue.setMontoMes(this.obtenMontosMesesVacios(meses));
                emptyValue.setSistema(((RegistroRubroDTO)((List)total.getValue()).get(0)).getSistema().equals("DDA") ? "SAP" : "DDA");
                emptyValue.setFechainicio(((RegistroRubroDTO)((List)total.getValue()).get(0)).getFechainicio());
                emptyValue.setFechaFin(((RegistroRubroDTO)((List)total.getValue()).get(0)).getFechaFin());
                emptyValue.setCodigoSAP(((RegistroRubroDTO)((List)total.getValue()).get(0)).getCodigoSAP());
                emptyValue.setIdBroadview(((RegistroRubroDTO)((List)total.getValue()).get(0)).getIdBroadview());
                ((List)total.getValue()).add(emptyValue);
            }
            for (int i = 0; ((List)total.getValue()).size() > i; ++i) {
                if (((String)total.getKey()).equals(idEstudio.toString())) continue;
                if (Objects.nonNull(totalesPorContratoAnioAnterior.get(total.getKey())) && totalesPorContratoAnioAnterior.get(total.getKey()).size() > i) {
                    if (Objects.nonNull(totalesPorContratoAnioAnterior.get(total.getKey()))) {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(((RegistroMontoDTO)totalesPorContratoAnioAnterior.get(total.getKey()).get(i).getMontoMes().get(12)).getMonto());
                    } else {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(Double.valueOf(0.0));
                    }
                    if (Objects.nonNull(totalesPorContratoAnioSiguiente.get(total.getKey()))) {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(((RegistroMontoDTO)totalesPorContratoAnioSiguiente.get(total.getKey()).get(i).getMontoMes().get(12)).getMonto());
                    } else {
                        ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(Double.valueOf(0.0));
                    }
                    Double r1 = ((RegistroRubroDTO)((List)total.getValue()).get(i)).getAcumuladoAnterior();
                    Double r2 = ((RegistroRubroDTO)((List)total.getValue()).get(i)).getAcumuladoPosterior();
                    int mon = 1;
                    for (RegistroMontoDTO mnt : ((RegistroRubroDTO)((List)total.getValue()).get(i)).getMontoMes()) {
                        if (mon <= month) {
                            r1 = r1 + mnt.getMonto();
                        }
                        if (mon > month && mon <= 12) {
                            r2 = r2 + mnt.getMonto();
                        }
                        ++mon;
                    }
                    ((RegistroRubroDTO)((List)total.getValue()).get(i)).setRemanente(Double.valueOf(r1 - r2));
                    continue;
                }
                ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoAnterior(Double.valueOf(0.0));
                ((RegistroRubroDTO)((List)total.getValue()).get(i)).setAcumuladoPosterior(Double.valueOf(0.0));
                ((RegistroRubroDTO)((List)total.getValue()).get(i)).setRemanente(Double.valueOf(0.0));
            }
        }
        return totalesPorContratoSAPDLA;
    }

    public Map<String, List<RegistroRubroDTO>> getListResult(Long idEstudio, String fecha) throws ParseException {
        List<RegistroRubroDTO> totalesPorContrato = this.obtenListaMontosTotalesContratoPorEstudio(idEstudio, fecha, 11L);
        List<RegistroRubroDTO> totalesPorContratoSAP = this.obtenListaMontosTotalesContratoPorEstudioSAP(idEstudio, fecha, 11L);
        LinkedHashMap<String, List<RegistroRubroDTO>> totalesPorContratoSAPDLA = new LinkedHashMap<String, List<RegistroRubroDTO>>();
        totalesPorContrato.addAll(totalesPorContratoSAP);
        for (RegistroRubroDTO total : totalesPorContrato) {
            if (!totalesPorContratoSAPDLA.containsKey(total.getDescripcion())) {
                totalesPorContratoSAPDLA.put(total.getDescripcion(), new ArrayList());
            }
            ((List)totalesPorContratoSAPDLA.get(total.getDescripcion())).add(total);
        }
        return totalesPorContratoSAPDLA;
    }

    public List<String> getFechasAConsultar(String fechaIni) throws ParseException {
        ArrayList<String> fechas = new ArrayList<String>();
        SimpleDateFormat formato = new SimpleDateFormat("MM/yyyy");
        Date date = formato.parse(fechaIni);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String fecha = formato.format(cal.getTime());
        fechas.add(fecha);
        for (int i = 1; i < 12; ++i) {
            cal.add(2, 1);
            fecha = formato.format(cal.getTime());
            fechas.add(fecha);
        }
        return fechas;
    }

    public List<RegistroMontoDTO> obtenMontosMesesVacios(List<String> meses) throws ParseException {
        ArrayList<RegistroMontoDTO> response = new ArrayList<RegistroMontoDTO>();
        SimpleDateFormat formato = new SimpleDateFormat("MM/yyyy");
        for (String mes : meses) {
            RegistroMontoDTO newItem = new RegistroMontoDTO();
            Date fecha = formato.parse(mes);
            newItem.setFecha(fecha);
            newItem.setMonto(Double.valueOf(0.0));
            response.add(newItem);
        }
        RegistroMontoDTO newItem = new RegistroMontoDTO();
        newItem.setFecha(null);
        newItem.setMonto(Double.valueOf(0.0));
        response.add(newItem);
        return response;
    }

    private void buscaRegistroMontoMes(List<RegistroMontoDTO> montos, RegistroMontoDTO actualizaMonto) throws ParseException {
        Double parcial = 0.0;
        RegistroMontoDTO total = null;
        for (RegistroMontoDTO monto : montos) {
            if (monto == null) continue;
            if (monto.getFecha() != null) {
                if (!monto.getFecha().equals(actualizaMonto.getFecha())) continue;
                parcial = actualizaMonto.getMonto();
                monto.setMonto(parcial);
                continue;
            }
            total = monto;
        }
        if (total != null) {
            total.setMonto(Double.valueOf(ReporteAmortizacionBO.truncateTo(total.getMonto() + parcial, 2)));
        }
    }

    static double truncateTo(double unroundedNumber, int decimalPlaces) {
        int truncatedNumberInt = (int)(unroundedNumber * Math.pow(10.0, decimalPlaces));
        double truncatedNumber = (double)truncatedNumberInt / Math.pow(10.0, decimalPlaces);
        return truncatedNumber;
    }

    public List<RegistroRubroDTO> obtenListaMontoTitulosPorContrato(Long idContrato, String fecha) throws ParseException {
        List montosTitulosContrato = this.reporteAmortizacionDAO.obtenMontosTitulosContrato(idContrato, fecha);
        ArrayList<RegistroRubroDTO> montosTitulos = new ArrayList();
        montosTitulos = this.separaMensualmente(montosTitulosContrato, fecha);
        return montosTitulos;
    }

    private List<RegistroRubroDTO> separaMensualmente(List<RegistroMontoDTO> titulosMontos, String fecha) throws ParseException {
        ArrayList<RegistroRubroDTO> montoTitulos = new ArrayList<RegistroRubroDTO>();
        HashMap<String, List<RegistroMontoDTO>> map = new HashMap<String, List<RegistroMontoDTO>>();
        List<String> meses = this.getFechasAConsultar(fecha);
        for (RegistroMontoDTO item : titulosMontos) {
            String season = Objects.isNull(item.getTemporada()) ? "" : " Season " + StringUtils.leftPad((String)item.getTemporada(), (int)2, (String)"0");
            List<RegistroMontoDTO> list = (List<RegistroMontoDTO>)map.get(item.getDescripcion() + season);
            if (list == null) {
                list = this.obtenMontosMesesVacios(meses);
                map.put(item.getDescripcion() + season, list);
                RegistroRubroDTO montoTituloRegistro = new RegistroRubroDTO();
                montoTituloRegistro.setTemporada(item.getTemporada());
                montoTituloRegistro.setDescripcion(item.getDescripcion() + season);
                montoTituloRegistro.setNombreUnico(item.getDescripcion());
                montoTituloRegistro.setMontoMes(list);
                montoTituloRegistro.setSistema(item.getSistema());
                montoTituloRegistro.setCodigoSAP(item.getIdSap());
                montoTituloRegistro.setIdBroadview(item.getIdBroadView());
                montoTitulos.add(montoTituloRegistro);
                this.logger.debug("id cto:" + item.getId() + " no tit:" + montoTitulos.size());
            }
            this.buscaRegistroMontoMes(list, item);
        }
        return montoTitulos;
    }

    public List<RegistroRubroDTO> obtenListaMontosTotalesContratoPorEstudioSAP(Long idEstudio, String fecha, Long mesesSearch) throws ParseException {
        ArrayList<RegistroRubroDTO> totalesPorContrato = new ArrayList<RegistroRubroDTO>();
        List montosContrato = this.reporteAmortizacionDAO.obtenMontosTotalesContratoSAP(idEstudio, fecha, mesesSearch);
        HashMap contratosMonto = new HashMap();
        for (RegistroMontoDTO monto : montosContrato) {
            if (Objects.isNull(contratosMonto.get(monto.getIdContrato()))) {
                contratosMonto.put(monto.getIdContrato(), new ArrayList());
            }
            ((List)contratosMonto.get(monto.getIdContrato())).add(monto);
        }
        List<String> meses = this.getFechasAConsultar(fecha);
        for (Map.Entry contrato : contratosMonto.entrySet()) {
            List montos = (List)contrato.getValue();
            List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
            if (montos == null || montos.isEmpty()) continue;
            for (RegistroMontoDTO item : montos) {
                this.buscaRegistroMontoMes(list, item);
            }
            RegistroRubroDTO totalContrato = new RegistroRubroDTO();
            totalContrato.setId(((RegistroMontoDTO)montos.get(0)).getIdContrato());
            totalContrato.setDescripcion(((RegistroMontoDTO)montos.get(0)).getNumContrato());
            totalContrato.setMontoMes(list);
            totalContrato.setFechaFin(((RegistroMontoDTO)montos.get(0)).getFechaFin());
            totalContrato.setFechainicio(((RegistroMontoDTO)montos.get(0)).getFechaInicio());
            totalContrato.setCodigoSAP("-");
            totalContrato.setSistema("SAP");
            totalContrato.setIdBroadview("-");
            totalesPorContrato.add(totalContrato);
        }
        return totalesPorContrato;
    }

    public RegistroRubroDTO obtenMontosTotalesPorEstudioSAP(Long idEstudio, String fecha) throws ParseException {
        List montosTotalesEstudio = this.reporteAmortizacionDAO.obtenMontosTotalesEstudioSAP(idEstudio, fecha);
        CatalogoEstudioDTO nombreEstudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(idEstudio.intValue());
        List<String> meses = this.getFechasAConsultar(fecha);
        List<RegistroMontoDTO> list = this.obtenMontosMesesVacios(meses);
        for (RegistroMontoDTO item : montosTotalesEstudio) {
            this.buscaRegistroMontoMes(list, item);
        }
        RegistroRubroDTO totalesEstudio = new RegistroRubroDTO();
        totalesEstudio.setId(idEstudio);
        totalesEstudio.setDescripcion(nombreEstudio.getDescripcionEstudio());
        totalesEstudio.setMontoMes(list);
        return totalesEstudio;
    }

    public List<RegistroRubroDTO> obtenListaMontoTitulosPorContratoSAP(Long idContrato, String fecha) throws ParseException {
        List montosTitulosContrato = this.reporteAmortizacionDAO.obtenMontosTitulosContratoSAP(idContrato, fecha);
        ArrayList<RegistroRubroDTO> montosTitulos = new ArrayList();
        montosTitulos = this.separaMensualmente(montosTitulosContrato, fecha);
        return montosTitulos;
    }
}

