package com.mx.dla.dda.carga.suscriptor.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.exceptions.PersistenceException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.suscriptor.bos.CargaSuscriptorBO;
import com.mx.dla.dda.carga.suscriptor.dtos.CargaSuscripcionDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.opensymphony.xwork2.Action;

public class CargaSuscriptoresAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
		
	private List<CargaSuscripcionDTO> listado = new ArrayList<CargaSuscripcionDTO>();
	private Integer mes;
	private Integer annio;
	private String  request;
	private String  msgError;
	private String  msgExito;
	private Map<String, String> informacionExcel;
	private File fileUpload;
	private String fileUploadContentType;
	private String fileUploadFileName;
	private String errores;
	
	@Autowired
	private CargaSuscriptorBO cargaSuscriptorBO;
		
	public String execute() {
		   
		   try{
			  
			   listado = cargaSuscriptorBO.getDatosSuscripcion(mes, annio);			      		   
			  			   
		   }catch(PersistenceException  ibe){
			   this.msgError = "Ocurrió un error al obtener los datos.";
			   logger.error("Error en [" +this.getClass() +"]", ibe);			   
			   
		   }catch(Exception e){
			   this.msgError = "Ocurrió un error al obtener los datos.";
			   logger.error("Error en [" +this.getClass() +"]", e);			   
		   }
		
		   return Action.SUCCESS;
	}

	public String actualizarDatos() {
		   
		   ObjectMapper mapper = new ObjectMapper();
			
			try {
				
				logger.debug("Actualizacion Carga:" + request);
												
				listado = mapper.readValue(request, new TypeReference<List<CargaSuscripcionDTO>>(){});								
			
				cargaSuscriptorBO.actualizarSuscriptores(listado);
				logger.debug("Se actulizaron valores carga");
				
				msgExito = "Los datos fueron guardados con Exito";
				
			} catch (JsonParseException | JsonGenerationException | JsonMappingException je) {
				this.msgError = "Ocurrió un error al guardar los datos.";
				 logger.error("Error en [" +this.getClass() +"]", je);				 	
				 
			} catch (IOException ioe) {
				 this.msgError = "Ocurrió un error al guardar los datos.";
				 logger.error("Error en [" +this.getClass() +"]", ioe);
				 
			}catch(PersistenceException  ibe){
				 this.msgError = "Ocurrió un error al guardar los datos.";
				 logger.error("Error en [" +this.getClass() +"]", ibe);
				 return Action.ERROR;
				 
			}catch(Exception e){
				 this.msgError = "Ocurrió un error al guardar los datos.";
				 logger.error("Error en [" +this.getClass() +"]", e);				 
			}		
		
		   return Action.SUCCESS;
	}
	
	public String cargaExcel() {
		
		try{
			setInformacionExcel(cargaSuscriptorBO.obtenInformacionExcel(fileUpload, fileUploadFileName));
			logger.debug("Se leyo la informacion.");
		}catch(Exception ex) {
			setErrores("Fallo la carga de excel.");
		}
		
		logger.debug("Se termino el action");
		
		return Action.SUCCESS;
	}
	
	public void setMes(Integer mes) {
		this.mes = mes;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public List<CargaSuscripcionDTO> getListado() {
		return listado;
	}

	public void setListado(List<CargaSuscripcionDTO> listado) {
		this.listado = listado;
	}

	public void setRequest(String request) {
		this.request = request;
	}

	public String getMsgError() {
		return msgError;
	}

	public String getMsgExito() {
		return msgExito;
	}
	
	public void setInformacionExcel(Map<String, String> informacionExcel) {
		this.informacionExcel = informacionExcel;
	}
	
	public Map<String, String> getInformacionExcel() {
		return informacionExcel;
	}
	
	public void setFileUpload(File fileUpload) {
		this.fileUpload = fileUpload;
	}
	
	public File getFileUpload() {
		return fileUpload;
	}
	
	public void setFileUploadFileName(String fileUploadFileName) {
		this.fileUploadFileName = fileUploadFileName;
	}
	
	public String getFileUploadFileName() {
		return fileUploadFileName;
	}
	
	public void setFileUploadContentType(String fileUploadContentType) {
		this.fileUploadContentType = fileUploadContentType;
	}
	
	public String getFileUploadContentType() {
		return fileUploadContentType;
	}
	
	public void setErrores(String errores) {
		this.errores = errores;
	}
	
	public String getErrores() {
		return errores;
	}
		
}
