package com.mx.dla.dda.contrato.condicionesTransaccion.bos;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.condicionesTransaccion.daos.CatalogosTransaccionDAO;
import com.mx.dla.dda.contrato.condicionesTransaccion.daos.CondicionesTransaccionDAO;
import com.mx.dla.dda.contrato.condicionesTransaccion.daos.DeleteCondicionesTransaccionDAO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.CategoriaMgDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.CondicionesTransaccionDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoCategoriasDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtAnnioDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtCmgDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtransDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtrsPrecioDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtrsRdDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ReleaseDateDTO;

@Service
public class CondicionesTransaccionBO {

	private Logger log = Logger.getLogger(this.getClass());

	@Autowired
	private CatalogosTransaccionDAO catalogoTransaccionDAO;
	@Autowired
	private CondicionesTransaccionDAO condicionesTransaccionDAO;
	@Autowired
	private DeleteCondicionesTransaccionDAO eliminarTransaccionDAO;

	public int guardar(CondicionesTransaccionDTO transaccionDTO) {

		List<Integer> idContratoPtrans = new ArrayList<Integer>();
		List<String> tipoTitulo = new ArrayList<String>();
		List<String> tipoTrans = new ArrayList<String>();
		tipoTitulo.add("PREMIERE");
		tipoTitulo.add("LIBRERIA");
		//tipoTitulo.add("AMBOS");

		tipoTrans.add("RENTA");
		tipoTrans.add("RENTA");
		//tipoTrans.add("VENTA");
		
		//PRIMERO VERIFICA SI YA HAY CONTRATOS CON EL ID EXISTENTE
		List<ContratoPtransDTO> pTransAux = new ArrayList<ContratoPtransDTO>();
		pTransAux=verificaTransaccion(transaccionDTO.getIdContrato());
		if(pTransAux.size()>0){
			//MUERAN TODOS
			for(int kAux=0;kAux<pTransAux.size();kAux++){
				log.debug("idContrato: "+pTransAux.get(kAux).getIdContrato()+" idPtrans: "+pTransAux.get(kAux).getIdContratoPtrans());
				eliminaContratoPtrsRd(Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
				eliminaContratoPtrsCat(Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
				eliminaContratoPtrsCmg(Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
				eliminaContratoPtrsAnnio(Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
				eliminaContratoPtrsPrecio(Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
				eliminaContratoPtrs(Long.parseLong(pTransAux.get(kAux).getIdContrato()+""),Long.parseLong(pTransAux.get(kAux).getIdContratoPtrans()+""));
			}
			
		}
		//TERMINA SECCION DE ELIMINAR REGISTROS

		//SECCION PARA GUARDAR CONTRATOS PTRS
		for (int index = 0; index < transaccionDTO.getOptionsLista().size(); index++) {

			ContratoPtransDTO pTrans = new ContratoPtransDTO();
			
			idContratoPtrans.add(condicionesTransaccionDAO.getIdContratoPtrans());
			pTrans.setIdContratoPtrans(idContratoPtrans.get(index));
			pTrans.setIdContrato(transaccionDTO.getIdContrato().intValue());
			pTrans.setTipoTrans(tipoTrans.get(index));
			pTrans.setTipoTitulo(tipoTitulo.get(index));
			pTrans.setTipoAnnio(transaccionDTO.getCombosLista().get(index));
			pTrans.setTipoMinimo(transaccionDTO.getOptionsLista().get(index));		
			agregarContratoPtrans(pTrans);
		}
		
		//SECCION PARA GUARDAR PRECIOS DE CATEGORIAS
		for(int kSeccion=0;kSeccion<idContratoPtrans.size();kSeccion++){
			ContratoPtrsPrecioDTO ptPrecio = new ContratoPtrsPrecioDTO();
			for(int kPrecio=0;kPrecio<transaccionDTO.getSeccionPtPrecio().get(kSeccion).size();kPrecio++){
				ptPrecio.setIdContratoPtrans(Long.parseLong(idContratoPtrans.get(kSeccion)+""));
				ptPrecio.setIdCategoria(transaccionDTO.getSeccionPtPrecio().get(kSeccion).get(kPrecio).getIdCategoria());
				ptPrecio.setPrecio(transaccionDTO.getSeccionPtPrecio().get(kSeccion).get(kPrecio).getPrecio());
				agregarContratoPtrsPrecio(ptPrecio);
			}
		}
		

		
		//SECCION PRA GUARDAR PTRS ANNIO
		for (int index = 0; index < transaccionDTO.getSeccionPtAnnio().size(); index++) {
			for (int kIndex = 0; kIndex < transaccionDTO.getSeccionPtAnnio().get(index).size(); kIndex++) {
				if (transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex).getSeccion().equals("PREMIER")) {
					transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex).setIdContratoPtrans(idContratoPtrans.get(0));
					agregarContratoPtAnnio(transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex));
				}
				if (transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex).getSeccion().equals("LIBRERIA")) {
					transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex)
							.setIdContratoPtrans(idContratoPtrans.get(1));
					agregarContratoPtAnnio(transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex));
				}
				if (transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex).getSeccion().equals("PREMIERELIBRERIA")) {
					transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex)
							.setIdContratoPtrans(idContratoPtrans.get(2));
					agregarContratoPtAnnio(transaccionDTO.getSeccionPtAnnio().get(index).get(kIndex));
				}

			}
		}

		
		//SECCION PARA GUARDAR PT CMG
		for (int index = 0; index < transaccionDTO.getSeccionMinimo().size(); index++) {
			for (int kIndex = 0; kIndex < transaccionDTO.getSeccionMinimo().get(index).size(); kIndex++) {

				if (transaccionDTO.getSeccionMinimo().get(index).get(kIndex).getSeccion().equals("PREMIER")) {

					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdPtcmg(condicionesTransaccionDAO.getIdContratoCMG());
					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdContratoPtrans(idContratoPtrans.get(0));
					agregarContratoPtCmg(transaccionDTO.getSeccionMinimo().get(index).get(kIndex));
				}

				if (transaccionDTO.getSeccionMinimo().get(index).get(kIndex).getSeccion().equals("LIBRERIA")) {
					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdPtcmg(condicionesTransaccionDAO.getIdContratoCMG());
					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdContratoPtrans(idContratoPtrans.get(1));
					agregarContratoPtCmg(transaccionDTO.getSeccionMinimo().get(index).get(kIndex));
				}
				if (transaccionDTO.getSeccionMinimo().get(index).get(kIndex).getSeccion().equals("PREMIERELIBRERIA")) {
					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdPtcmg(condicionesTransaccionDAO.getIdContratoCMG());
					transaccionDTO.getSeccionMinimo().get(index).get(kIndex)
							.setIdContratoPtrans(idContratoPtrans.get(2));
					agregarContratoPtCmg(transaccionDTO.getSeccionMinimo().get(index).get(kIndex));
				}
			}
		}

		
		//SECCION PARA GUARDAR RELEASE DATE
		for (int index = 0; index < transaccionDTO.getSecciontablaCatalogos().size(); index++) {
			for (int kindex = 0; kindex < transaccionDTO.getSecciontablaCatalogos().get(index).size(); kindex++) {

				if (index == 0) {
					try {
						// guarda la primer tabla secundaria de release SECCION
						// PREMIERE
						ContratoPtrsRdDTO release = new ContratoPtrsRdDTO();
						release.setIdRelease(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getIdCatalogo());
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getTipo().equals("dla")) {
							release.setRsDLA(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getValor());

						}
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex + 1).getTipo().equals("estudio")) {
							release.setRsEstudio(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex+1).getValor());
						}
						release.setIdContratoPtrans(idContratoPtrans.get(0));
						log.debug(release.toString());
						if (release.getRsDLA() != null && release.getRsEstudio() != null) {
							agregarContratoPtrsRd(release);
						}
					} catch (IndexOutOfBoundsException e) {
						log.debug("TODO NORMAL PREMIERE");
					}

				}
				if (index == 1) {

					try {
						// guarda la segunda tabla secundaria SECCION LIBRERIA
						ContratoCategoriasDTO categoria = new ContratoCategoriasDTO();
						categoria.setIdContratoPtrans(idContratoPtrans.get(1));
						categoria.setIdCategoria(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getIdCatalogo());
						categoria.setTipoTitlo("OTRO");
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getTipo().equals("dla")) {
							categoria.setRsDLA(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getValor());
						}
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex+1).getTipo()
								.equals("estudio")) {
							categoria.setRsEstudio(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex+1).getValor());
						}
						categoria.setIdContratoPtrans(idContratoPtrans.get(1));
						log.debug(categoria.toString());
						if (categoria.getRsDLA() != null && categoria.getRsEstudio() != null) {
							log.debug("AGREGANDO DDA_T_CONTRATO_PTRS_CAT");
							agregarContratoCategorias(categoria);
						}
					} catch (IndexOutOfBoundsException e) {
						log.debug("TODO NORMAL LIBRERIA");
					}

				}
				if (index == 2) {
					try {
						// guarda la tercer tabla secundaria SECCION
						// PREMIERELIBRERIA
						// como la ultima seccion se divide en 2 tablas se hacen
						// 2
						// guardados
						ContratoCategoriasDTO categoria = new ContratoCategoriasDTO();
						categoria.setIdContratoPtrans(idContratoPtrans.get(2));
						categoria.setIdCategoria(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getIdCatalogo());
						categoria.setTipoTitlo("PELICULA");
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getTipo().equals("dla")) {
							categoria.setRsDLA(	transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getValor());
						}
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex + 1).getTipo().equals("estudio")) {
							categoria.setRsEstudio(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex+1).getValor());
						}
						categoria.setIdContratoPtrans(idContratoPtrans.get(2));
						log.debug(categoria.toString());
						if (categoria.getRsDLA() != null && categoria.getRsEstudio() != null) {
							log.debug("AGREGANDO DDA_T_CONTRATO_PTRS_CAT");
							agregarContratoCategorias(categoria);
						}

						ContratoCategoriasDTO categoriaOtro = new ContratoCategoriasDTO();
						categoriaOtro.setIdContratoPtrans(idContratoPtrans.get(2));
						categoriaOtro.setIdCategoria(
								transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getIdCatalogo());
						categoriaOtro.setTipoTitlo("OTRO");
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getTipo().equals("dla")) {
							categoriaOtro.setRsDLA(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex).getValor());
						}
						if (transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex + 1).getTipo().equals("estudio")) {
							categoriaOtro.setRsEstudio(transaccionDTO.getSecciontablaCatalogos().get(index).get(kindex+1).getValor());
						}
						categoriaOtro.setIdContratoPtrans(idContratoPtrans.get(2));
						log.debug(categoriaOtro.toString());
						if (categoriaOtro.getRsDLA() != null && categoriaOtro.getRsEstudio() != null) {
							log.debug("AGREGANDO DDA_T_CONTRATO_PTRS_CAT");
							agregarContratoCategorias(categoriaOtro);
						}
					} catch (IndexOutOfBoundsException e) {
						log.debug("TODO NORMAL PREMIERE/LIBRERIA");
					}

				}

			}
		}

		return 0;
	}

	/**
	 * @see catalogo de tipo suscriptor
	 * @return List<TipoSuscriptorDTO>
	 */
	public List<CategoriaMgDTO> obtenerCategoriaMG() {
		List<CategoriaMgDTO> categoriaMgLista = new ArrayList<CategoriaMgDTO>();
		try {
			log.debug("obtenerCategoriaMG");
			categoriaMgLista = catalogoTransaccionDAO.obtenerCategoriaMG();
		} catch (Exception e) {
			log.error("ERROR: no se pudo cargar el catalogo: ", e);
		}
		return categoriaMgLista;
	}

	public List<ReleaseDateDTO> obtenerReleaseDate() {
		List<ReleaseDateDTO> releaseDateLista = new ArrayList<ReleaseDateDTO>();
		try {
			log.debug("obtenerReleaseDate");
			releaseDateLista = catalogoTransaccionDAO.obtenerReleaseDate();
		} catch (Exception e) {
			log.error("ERROR: no se pudo cargar el catalogo: ", e);
			log.error("Causa " + e.getCause());
		}
		return releaseDateLista;
	}

	public int agregarContratoPtrans(ContratoPtransDTO ptrans) {
		int idptranso = 0;
		try {

			log.debug("agregarContratoPtrans");
			idptranso = condicionesTransaccionDAO.agregarContratoPtrans(ptrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtrans: ", e);
		}

		return idptranso;
	}

	public int agregarContratoPtAnnio(ContratoPtAnnioDTO ptAnio) {
		int idptAnio = 0;
		try {

			log.debug("agregarContratoPtAnnio");
			idptAnio = condicionesTransaccionDAO.agregarContratoPtAnnio(ptAnio);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtAnnio: ", e);
		}

		return idptAnio;
	}

	public int agregarContratoPtCmg(ContratoPtCmgDTO ptCmg) {
		int idptCmg = 0;
		try {

			log.debug("agregarContratoPtCmg");
			idptCmg = condicionesTransaccionDAO.agregarContratoPtCmg(ptCmg);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtCmg: ", e);
		}

		return idptCmg;
	}
/*
	public int agregarContratoPtrsCat(ContratoPtrsCatDTO cat) {
		int idptranso = 0;
		try {

			log.debug("agregarContratoPtrsCat");
			idptranso = condicionesTransaccionDAO.agregarContratoPtrsCat(cat);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtrsCat: ", e);
		}

		return idptranso;
	}
	*/

	public int agregarContratoPtrsRd(ContratoPtrsRdDTO release) {
		int idrelease = 0;
		try {

			log.debug("agregarContratoPtrsRd");
			idrelease = condicionesTransaccionDAO.agregarContratoPtrsRd(release);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtrsRd: ", e);
		}

		return idrelease;
	}

	public int agregarContratoCategorias(ContratoCategoriasDTO cat) {
		int idptranso = 0;
		try {
			
			log.debug("agregarContratoCategorias");
			idptranso = condicionesTransaccionDAO.agregarContratoCategorias(cat);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return idptranso;
	}
	
	public int agregarContratoPtrsPrecio(ContratoPtrsPrecioDTO precio){
		int idPtPrecio=0;
		try {
			
			log.debug("agregarContratoPtrsPrecio");
			idPtPrecio=condicionesTransaccionDAO.agregarContratoPtrsPrecio(precio);
		} catch (Exception e) {
			log.error("ERROR agregarContratoPtrsPrecio: ",e);
		}
		
		return idPtPrecio;
	}
	
	
	public int eliminaContratoPtrsRd(Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrsRd(idPtrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return resultado;
	}
	public int eliminaContratoPtrsCat(Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrsCat(idPtrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return resultado;
	}
	public int eliminaContratoPtrsCmg(Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrsCmg(idPtrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return resultado;
	}
	public int eliminaContratoPtrsAnnio(Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrsAnnio(idPtrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return resultado;
	}
	
	public int eliminaContratoPtrsPrecio(Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrsPrecio(idPtrans);
		} catch (Exception e) {
			log.error("ERROR eliminaContratoPtrsPrecio: ", e);
		}

		return resultado;
	}
	public int eliminaContratoPtrs(Long idContrato,Long idPtrans){
		int resultado = 0;
		try {
			
			log.debug("eliminando registros");
			resultado = eliminarTransaccionDAO.eliminaContratoPtrs(idContrato,idPtrans);
		} catch (Exception e) {
			log.error("ERROR agregarContratoCategorias: ", e);
		}

		return resultado;
	}
	
	
	
	public List<ContratoPtransDTO> verificaTransaccion(Long idContrato){
		List<ContratoPtransDTO> ptrans = new ArrayList<ContratoPtransDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.verificaTransaccion(idContrato);
		} catch (Exception e) {
			log.error("ERROR verificaTransaccion: ", e);
		}

		return ptrans;
	}
	

	
	public List<ContratoPtAnnioDTO> cargaContratoPagoAnnio(Long idContratoPago){
		List<ContratoPtAnnioDTO> ptrans = new ArrayList<ContratoPtAnnioDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.cargaContratoPagoAnnio(idContratoPago);
		} catch (Exception e) {
			log.error("ERROR cargaContratoPagoAnnio: ", e);
		}

		return ptrans;
	}
	public List<ContratoPtCmgDTO> cargaContratoPagoCmg(Long idContratoPago){
		List<ContratoPtCmgDTO> ptrans = new ArrayList<ContratoPtCmgDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.cargaContratoPagoCmg(idContratoPago);
		} catch (Exception e) {
			log.error("ERROR cargaContratoPagoCmg: ", e);
		}

		return ptrans;
	}
	public List<ContratoCategoriasDTO> cargaContratoPagoCategorias(Long idContratoPago){
		List<ContratoCategoriasDTO> ptrans = new ArrayList<ContratoCategoriasDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.cargaContratoPagoCategorias(idContratoPago);
		} catch (Exception e) {
			log.error("ERROR cargaContratoPagoCategorias: ", e);
		}

		return ptrans;
	}
	public List<ContratoPtrsRdDTO> cargaContratoPagoRD(Long idContratoPago){
		List<ContratoPtrsRdDTO> ptrans = new ArrayList<ContratoPtrsRdDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.cargaContratoPagoRD(idContratoPago);
		} catch (Exception e) {
			log.error("ERROR cargaContratoPagoRD: ", e);
		}

		return ptrans;
	}
	public List<ContratoPtrsPrecioDTO> cargaContratoPagoPrecio(Long idContratoPago){
		List<ContratoPtrsPrecioDTO> ptrans = new ArrayList<ContratoPtrsPrecioDTO>();
		try {
			
			log.debug("verificando registros");
			ptrans = catalogoTransaccionDAO.cargaContratoPagoPrecio(idContratoPago);
		} catch (Exception e) {
			log.error("ERROR cargaContratoPagoPrecio: ", e);
		}

		return ptrans;
	}

}
