
function getDataAction() {

	var eleccionEstudio = $('#estudioEleccion').val();
	var eleccionTipoPago = $('#tipoPagoEleccion').val();
	var eleccionMes = $('#fecha').val();


	if (validaNuloUndefinido(eleccionEstudio) == 0) {
		eleccionEstudio = null;
	}

	if (validaNuloUndefinido(eleccionTipoPago) == 0) {
		eleccionTipoPago = "";
	}

	if (validaNuloUndefinido(eleccionMes) == 0) {
		eleccionMes = null;
	}

	var jsonString = '{"idEstudio" : ' + eleccionEstudio + ', "tipoPago" : "' + eleccionTipoPago + '", "mes" : "' + eleccionMes + '"}';

	var stringJson = JSON.parse(jsonString);

	$.ajax({
		url: contextPath + "/reporte/suscriptores/reportePagoSuscriptoresConsulta",
		type: 'POST',
		data: stringJson,
		dataType: "json",
		success: function(response) {
			generaTabla(response);
		},
		error: function(jqXhr, textStatus, errorThrown) {
		}
	});
}

function generaTabla(data) {

	var facturaDetalleTamanio = data.reporteDetalle.length;

	var nombreTabla = "reportePagoSuscriptor";
	var nombreTablaContenedor = "facturaDetalleContainerContainer";
	var nombreAppender = "tablaPagoSuscriptores";


	var headerTablaRow = tituloReporte(nombreTabla, nombreTablaContenedor);

	$('#' + nombreAppender).append(headerTablaRow);

	for (var i = 0; i < facturaDetalleTamanio; i++) {
		var fila = detalleReporte(data.reporteDetalle[i]);
		$('#' + nombreTabla + ' > tbody:last').append(fila);

	}


	var excel = $("#reportePagoSuscriptor").excelMapper({
		action: contextPath + '/excelTableReport/export.action',
		actionAttribute: "elements",
		rootRows: "rootElement"
	});

	$('#botonExporta').click(function() {
		excel.send();
	});

}

function tituloReporte(idNombreTabla, idNombreTablaContainer) {

	$('#' + idNombreTablaContainer).remove();

	var header = '<div id="' + idNombreTablaContainer + '" >' +
		'<table id="' + idNombreTabla + '" class="table table-striped table-hover">' +
		'<thead>' +
		'<tr class="encabezado">' +
		'<th>Titulo</th>' +
		'<th>Inicio</th>' +
		'<th>Fin</th>' +
		'<th>Categoria</th>' +
		'<th>Precio</th>' +
		'<th>Suscriptores</th>' +
		'</tr>' +
		'</thead>' +
		'<tbody>' +
		'</tbody>' +
		'</table>' +
		'</div>';

	return header;
}


function detalleReporte(objetoDetalle) {

	var precio = formateo(objetoDetalle.precio, true);
	var susc = formatMiles(objetoDetalle.suscriptores);



	var fila = '<tr>' +
		'<td>' +
		'<div>' +
		objetoDetalle.descTitulo +
		'</div>' +
		'</td>' +
		'<td>' +
		'<div>' +
		objetoDetalle.fechaInicio +
		'</div>' +
		'</td>' +
		'<td>' +
		'<div>' +
		objetoDetalle.fechaFin +
		'</div>' +
		'</td>' +
		'<td>' +
		'<div>' +
		objetoDetalle.descCategoria +
		'</div>' +
		'</td>' +
		'<td>' +
		'<div align="right" >' +
		precio +
		'</div>' +
		'</td>' +
		'<td>' +
		'<div align="right">' +
		susc +
		'</div>' +
		'</td>' +
		'</tr>';

	return fila;
}

function validaNuloUndefinido(variable) {

	if ((variable === null && typeof variable === "object") ||
		(variable === undefined && typeof variable === "undefined") ||
		(variable === "" && typeof variable === "string")
	) {
		return 0;
	} else {
		return variable;
	}
}

function inputNegado(evt) {
	return false;
}

function formateo(value, currency) {
	r = value;
	if (value != "" && value != null && !isNaN(value)) {
		var n = parseFloat(value);
		r = n.formatDLA();
		if (currency) {
			r = "$ " + r;
		}
	}
	return r;
};

function formatMiles(value) {

	var n = parseFloat(value);
	n = n.formatDLA();
	n = n.substring(0, n.length - 3);
	return n;
}

$(document)
	.ready(
		function() {

			$('#fecha').datepicker({ dateFormat: 'mm-yy' });
			getDataAction();

			$('#botonConsultar').click(function() {
				getDataAction();
			});

		}
	);


