package com.mx.dla.dda.contrato.generales.daos;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.DetalleCatalogoContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.InfoDetalleContratoDTO;


public interface GeneralesDAO {
	
	public void registrarContrato(ContratoDTO contrato);
	
	public void actualizaNumeroContrato( @Param("idContrato") Long idContrato, @Param("numeroContrato") String numeroContrato);

	public ContratoDTO obtenerContrato(@Param("idContrato") Long idContrato);
	
	public void actualizaContrato(@Param("campoContrato") Long campoContrato, @Param("campoEstudio") Long campoEstudio, 
								@Param("campoFechaInicio") Date campoFechaInicio, @Param("campoFechaFin") Date campoFechaFin, 
								@Param("apartado") Long apartado, @Param("annios") String annios, @Param("meses") String meses, 
								@Param("campoFechaAutorizacion") Date campoFechaAutorizacion, @Param("indicador") String indicador);
	
	//public void llamarEliminaContrato(@Param("idContrato") Long idContrato, @Param("noError") Long noError, @Param("strError") String strError);
	
	public void llamarEliminaContrato(Map<String, Object> params);
	
	public String llamarCrearNumeroContrato(Map<String, Object> params);

	public void actualizaIdEstudioContrato( @Param("idContrato") Long idContrato, @Param("idEstudio") Long idEstudio);
	
	public void eliminaEstudioVirtual(@Param("idEstudio") Long idEstudio);
	
	public void actulizaEstudioTitulos(@Param("idEstudioAct") Long idEstudioAct, @Param("idEstudioNew") Long idEstudioNew);
	
	public AreaDTO obtenerAreaPorExpediente(@Param("expediente") String expediente);
	
	public AreaDTO obtenerAreaPorOrdenWF(@Param("ordenWF") Integer ordenWF);
	
	public List<AreaDTO> obtenerAreasFinalizadoras();
	
	/*Function to EstudiosBO*/
	public String obtenIdSapEstudio(@Param("idEstudio") Long idEstudio);
	
	public List<ContratoDTO> buscarContratosPorIdContratoOriginal(@Param("idContratoOriginal")Long idContratoOriginal);
	
	public FechasDTO obtenerFechasMaximaMinimaDeContratosPorContratoOriginal(@Param("idContratoOriginal") Long idContratoOriginal);
	
	public String obtenerFechaSAP();
	
	public InfoDetalleContratoDTO obtenDetalleContrato(@Param("idContrato") Long idContrato);
	
	public List<DetalleCatalogoContratoDTO> obtenDetalleCatalogos(@Param("idContrato") Long idContrato);
	
	public void crearListaNuevaTransaccion(@Param("idContrato") Long idContrato, @Param("fechaInicio") Date fechaInicio);
	
	public void actualizaFechaLista(@Param("idContrato") Long idContrato, @Param("fechaInicio") Date fechaInicio);

	public void cambiarAddendum(@Param("idContrato") Long idContrato, @Param("numeroContrato")String numeroContrato);
	
}
