package com.mx.dla.dda.contrato.titulo.bos;

import java.util.Calendar;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.global.bos.BaseBO;

@Component
public class TitulosUtilBO extends BaseBO{
	
	@Autowired
	private TituloDAO tituloDAO;
	
	public  Titulo getTituloGuardar(Titulo t, ContratoDTO c){		
		t.setIdContrato(c.getIdContrato());
		t.setVidaUtil  (calcularVidaUtil(t.getFechaInicio(),t.getFechaFin()));
		t.setMesesvu   (calculaMesesVidaUtil(t.getFechaInicio(),t.getFechaFin()));
		t.setEstatus   ("ACTIVO");
		return t;
	}
			
	public   String calcularVidaUtil(Date inicio, Date fin)
	{
		return tituloDAO.calcularVidaUtil(inicio, fin, "SAP");
	}
	
	/**
	 * Calcula la diferencia en meses entre dos fechas
	 * @param first less date than second param
	 * @param second greater date than first param
	 * @return diference in months 
	 */
	public static Long calculaDiferencia(Date first, Date second)
	{
		Integer monthsPerYear = 12;
		Calendar finalDate = Calendar.getInstance();
		Calendar startDate = Calendar.getInstance();
		finalDate.setTime(second);
		startDate.setTime(first);

		Integer finalYear = finalDate.get(Calendar.YEAR);
		Integer startYear = startDate.get(Calendar.YEAR);
		Integer finalMonth = finalDate.get(Calendar.MONTH) + 1;
	    Integer startMonth = startDate.get(Calendar.MONTH) + 1;
	    Integer months = (((finalYear-startYear)*monthsPerYear + finalMonth) - startMonth) + 1;
	    	    
		return months.longValue();
	}
	
	public  String calculaMesesVidaUtil(Date inicio, Date fin)
	{
		return tituloDAO.calcularVidaUtil(inicio, fin, "DDA");
	}
	
	public  Titulo getTituloSerieAuto(Titulo t, String name, String episodio){		
		t.setDescTitulo(name);
	    t.setEpisodio(episodio);
		t.setIdBv(null);
		return t;
	}
	           	                    				            
	public  Titulo getTituloByTitulo(Titulo origen, Titulo bd){		
		bd.setNombreUnico(origen.getNombreUnico());		
		bd.setFechaInicio(origen.getFechaInicio());
		bd.setFechaFin(origen.getFechaFin());
		bd.setVidaUtil(calcularVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		bd.setMesesvu(calculaMesesVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		bd.setPagoCateg(origen.getPagoCateg());
		bd.setDescTitulo(origen.getDescTitulo());
		bd.setCategoriaTit(origen.getCategoriaTit());
		bd.setCategoriaTit(origen.getCategoriaTit());
		bd.setPrecioAnual(origen.getPrecioAnual());		
		bd.setTemporada(origen.getTemporada());
		bd.setEpisodio(origen.getEpisodio());
		bd.setPjeExclusivo(origen.getPjeExclusivo());
		bd.setMesesExclusivo(origen.getMesesExclusivo());
		bd.setIdBv(origen.getIdBv());
		bd.setBriefcase(origen.isBriefcase());
		bd.setFlgcalculoPrecio(origen.getFlgcalculoPrecio());	
		bd.setAnioContrato(origen.getAnioContrato());
		return bd;
	}
	
	public  Titulo copiarTitulo(Titulo origen, Titulo destino){		
		destino.setNombreUnico(origen.getNombreUnico());
		destino.setDescTitulo (origen.getDescTitulo());
		destino.setIdBv       (origen.getIdBv());
		destino.setTemporada  (origen.getTemporada());
		destino.setEpisodio   (origen.getEpisodio());		
		destino.setFechaInicio(origen.getFechaInicio());
		destino.setFechaFin   (origen.getFechaFin());
		destino.setVidaUtil   (calcularVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		destino.setMesesvu    (calculaMesesVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		destino.setAnioContrato(origen.getAnioContrato());
		destino.setBriefcase  (origen.isBriefcase());
		destino.setPagoCateg  (origen.getPagoCateg());
		destino.setCategoriaTit(origen.getCategoriaTit());										
		destino.setPrecioAnual(origen.getPrecioAnual());				
		destino.setPjeExclusivo(origen.getPjeExclusivo());
		destino.setMesesExclusivo(origen.getMesesExclusivo());				
		destino.setFlgcalculoPrecio(origen.getFlgcalculoPrecio());
		destino.setCosto(origen.getCosto());		
		return destino;
	}
	
}
